//=======================================================================================
/**
 * @file ItemInfoBase.h
 * @briefuvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.14
 */
//=======================================================================================
#include <gflib.h>
#include <system/main.h>
#include <battle/btlv/btlv_core.h>
#include "AppBase.h"
#include "ItemInfoBase.h"


namespace btl {
  namespace app {



    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param app_heap          gpAvP[Vq[v
     * @param app_heap_size     gpAvP[Vq[ṽTCY
     * @param device_heap       gpfoCXq[v
     * @param device_heap_size  gpfoCXq[ṽTCY
     * @param btlv_system       og`RAVXe
     */
    //---------------------------------------------------------------------------------
    ItemInfoBase::ItemInfoBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        BattleViewSystem* btlv_system ) :
      AppBase( 
          app_heap, HEAPID_BATTLE_ITEM_INFO, app_heap_size, 
          device_heap, HEAPID_BATTLE_ITEM_INFO_DEVICE, device_heap_size, 
          btlv_system ),
      m_settings(),
      m_result( RESULT_NULL )
    {
    }



    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    ItemInfoBase::~ItemInfoBase()
    {
    }



    //---------------------------------------------------------------------------------
    /**
     * @brief ʂ擾
     */
    //---------------------------------------------------------------------------------
    ItemInfoBase::Result ItemInfoBase::GetResult( void ) const
    {
      return m_result;
    }



  }  // namespace app
}  // namespace btl
