//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		DressUpModel.cpp
 *	@brief  ւ̂ł郂f
 *	@author	Koji Kawada
 *	@date		2011.09.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#if 0
// @todo
\[X܂͗vCBresourceő啶B
#endif


#include <gflib.h>

#include "system/motion/BaseMotionCharacter.h"

#include "system/dress_up/DressUpModel.h"


namespace xy_system {
namespace dress_up {


//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------
const DressUpModel::Profile DressUpModel::DEFAULT_PROFILE =
{
  PARTELEMENT_HEAD_SHORT,
  PARTELEMENT_UPPER_A,
  PARTELEMENT_LOWER_PANTS,
  SKIN_EUROPEAN
};
  
DressUpModel::DressUpModel(void)
  : m_base_model(NULL),
    m_skin(VALUE_NONE),
    m_base_model_bit_flag(MODEL_BIT_FLAG_NONE)
{
  for( s32 i=0; i<PART_MAX; ++i )
  {
    m_part_model_array[i] = NULL;
  }

  for( s32 i=0; i<PART_MAX; ++i )
  {
    m_part_array[i] = VALUE_NONE;
  }

  for( s32 i=0; i<PART_MAX; ++i )
  {
    m_part_model_bit_flag_array[i] = MODEL_BIT_FLAG_NONE;
  }

  {
    // resource
    m_resource = NULL;
    InitializeIndexInResource();
  }
}
DressUpModel::~DressUpModel()
{
  Destroy();
}

void DressUpModel::Create(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    gfl::grp::g3d::Resource* resource,
    const Profile*           profile
)
{
  {
    // resource
    static const char* name_of_base_model = "base";
    static const char* name_of_part_model_array[PART_MAX][PARTELEMENT_MAX] =
    {
      { "short", "long"  },
      { "a", "b" },
      { "pants", "skirt" },
    };
    static const char* name_of_part_texture_array[PART_MAX][PARTELEMENT_MAX][SKIN_MAX] =
    {
      {
        { "short_eu", "short_af", "short_as" },
        { "long_eu", "long_af", "long_as" },
      },
      {
        { "a_eu", "a_af", "a_as" },
        { "b_eu", "b_af", "b_as" },
      },
      {
        { "pants_eu", "pants_af", "pants_as" },
        { "skirt_eu", "skirt_af", "skirt_as" },
      },
    };
    static const char* name_of_part_skeletal_animation_array[PART_MAX][PARTELEMENT_MAX][RESOURCE_ANIMATION_MAX] =
    {
      {
        { "short_0", "short_1", "short_2", "short_3" },
        { "long_0", "long_1", "long_2", "long_3" },
      },
      {
        { "a_0", "a_1", "a_2", "a_3" },
        { "b_0", "b_1", "b_2", "a_3" },
      },
      {
        { "pants_0", "pants_1", "pants_2", NULL },
        { "skirt_0", "skirt_1", "skirt_2", NULL },
      },
    };

    m_resource = resource;
    m_index_in_resource_of_base_model = resource->GetModelsIndex(name_of_base_model);
    for(s32 i=0; i<PART_MAX; ++i)
    {
      for(s32 j=0; j<PARTELEMENT_MAX; ++j)
      {
        m_index_in_resource_of_part_model_array[i][j] = resource->GetModelsIndex(name_of_part_model_array[i][j]);
        for(s32 k=0; k<SKIN_MAX; ++k)
        {
          m_index_in_resource_of_part_texture_array[i][j][k] = resource->GetTexturesIndex(name_of_part_texture_array[i][j][k]);
        }
        for(s32 k=0; k<RESOURCE_ANIMATION_MAX; ++k)
        {
          m_index_in_resource_of_part_skeletal_animation_array[i][j][k] = resource->GetSkeletalAnimsIndex(name_of_part_skeletal_animation_array[i][j][k]);
        }
      }
    }
  }

  m_base_model = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Model;
  m_base_model->Create(heap_allocator, device_allocator, m_resource, m_index_in_resource_of_base_model);
  m_base_model_bit_flag = MODEL_BIT_FLAG_NONE;
  m_base_model_bit_flag |= MODEL_BIT_FLAG_NEED_AFTER_CREATE;

  ChangeComponent(heap_allocator, device_allocator, COMPONENT_SKIN, profile->skin);
  ChangeComponent(heap_allocator, device_allocator, COMPONENT_PART, PART_HEAD, profile->part_head);
  ChangeComponent(heap_allocator, device_allocator, COMPONENT_PART, PART_UPPER, profile->part_upper);
  ChangeComponent(heap_allocator, device_allocator, COMPONENT_PART, PART_LOWER, profile->part_lower);
}
void DressUpModel::Destroy(void)
{
  {
    // resource
    InitializeIndexInResource();
    m_resource = NULL;
  }

  for( s32 i=0; i<PART_MAX; ++i )
  {
    m_part_model_bit_flag_array[i] = MODEL_BIT_FLAG_NONE;
  }
  m_base_model_bit_flag = MODEL_BIT_FLAG_NONE;

  m_skin = VALUE_NONE;
  for( s32 i=0; i<PART_MAX; ++i )
  {
    m_part_array[i] = VALUE_NONE;
  }

  for( s32 i=0; i<PART_MAX; ++i )
  {
    if( m_part_model_array[i] )
    {
      GFL_DELETE m_part_model_array[i];
      m_part_model_array[i] = NULL;
    }
  }
  if( m_base_model )
  {
    GFL_DELETE m_base_model;
    m_base_model = NULL;
  }
}
void DressUpModel::ChangeComponent(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    s32 arg0, s32 arg1, s32 arg2)
{
  // arg0Component
  switch(arg0)
  {
  case COMPONENT_PART:
    {
      // arg1Part
      // arg2PartelementXXX(PartelementHead or PartelementUpper or PartelementLower)
      ChangePart(heap_allocator, device_allocator, arg1, arg2);
    }
    break;
  case COMPONENT_SKIN:
    {
      // arg1Skin
      // arg2͎gpȂ
      ChangeSkin(arg1);
    }
    break;
  }
}
/*
  void ChangeComponent(
      gfl::heap::NwAllocator*  heap_allocator,
      gfl::heap::NwAllocator*  device_allocator,
      const Profile*           profile = &DEFAULT_PROFILE
  );
*/



void DressUpModel::ChangePart(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    s32 part, s32 partelement
)
{
  if( m_part_array[part] != partelement )
  {
    if( m_part_model_array[part] )
    {
      GFL_DELETE m_part_model_array[part];
    }
    m_part_model_array[part] = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Model;
    m_part_model_array[part]->Create(heap_allocator, device_allocator, m_resource, m_index_in_resource_of_part_model_array[part][partelement]);
    m_part_model_array[part]->CreateReplaceBoneData(heap_allocator, m_base_model);
    if( m_skin != VALUE_NONE )
    {
      m_part_model_array[part]->SetMaterialTextureMapperTexture(0, 0, m_resource, m_index_in_resource_of_part_texture_array[part][partelement][m_skin]);
    }
    m_part_model_bit_flag_array[part] = MODEL_BIT_FLAG_NONE;
    m_part_model_bit_flag_array[part] |= MODEL_BIT_FLAG_NEED_AFTER_CREATE;
    m_part_array[part] = partelement;
  }
}
void DressUpModel::ChangeSkin(
    s32 skin
)
{
  if( m_skin != skin )
  {
    for(s32 i=0; i<PART_MAX; ++i)
    {
      if( m_part_model_array[i] )
      {
        m_part_model_array[i]->SetMaterialTextureMapperTexture(0, 0, m_resource, m_index_in_resource_of_part_texture_array[i][m_part_array[i]][skin]);
      }
    }
    m_skin = skin;
  }
}

  void ChangeAnimation(
      gfl::heap::NwAllocator*  heap_allocator, 
      gfl::heap::NwAllocator*  device_allocator,
      s32                      animation_no,  // @todo m_resourceɃAj[VĂ̂͂ǂȂ񂾂낤
      u32                      change_frame = 0,
      u32                      slot_index = 0,
      s32                      max_anim_members = gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRST,
      bool                     force = false
  );

  void SetTranslate(const gfl::math::VEC3& t);

  void AddToScene(gfl::grp::g3d::Scene* scene);
  void RemoveFromScene(gfl::grp::g3d::Scene* scene);
  void SwitchEdgeMap(gfl::grp::g3d::Scene* scene, const b32 cast_on);

void DressUpModel::SetMotion(proj::motion::BaseMotionCharacter* motion_character)
{
  motion_character->ToModel(m_base_model);

  for(s32 i=0; i<PART_MAX; ++i)
  {
    if( m_part_model_array[i] )
    {
      m_part_model_array[i]->SetWorldReplaceBone(m_base_model);
    }
  }
}

// resource
void DressUpModel::InitializeIndexInResource(void)
{
  m_index_in_resource_of_base_model = gfl::grp::g3d::Resource::RESOURCE_INDEX_NOT_FOUND;
  for(s32 i=0; i<PART_MAX; ++i)
  {
    for(s32 j=0; j<PARTELEMENT_MAX; ++j)
    {
      m_index_in_resource_of_part_model_array[i][j] = gfl::grp::g3d::Resource::RESOURCE_INDEX_NOT_FOUND;
      for(s32 k=0; k<SKIN_MAX; ++k)
      {
        m_index_in_resource_of_part_texture_array[i][j][k] = gfl::grp::g3d::Resource::RESOURCE_INDEX_NOT_FOUND;
      }
      for(s32 k=0; k<RESOURCE_ANIMATION_MAX; ++k)
      {
        m_index_in_resource_of_part_skeletal_animation_array[i][j][k] = gfl::grp::g3d::Resource::RESOURCE_INDEX_NOT_FOUND;
      }
    }
  }
}


} // namespace dress_up
} // namespace xy_system
