#ifndef __MOVE3DVISIBLEMODEL_H__
#define __MOVE3DVISIBLEMODEL_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		Move3DVisibleModel.h
 *	@brief  샂f3Ďڃf
 *	@author	Koji Kawada
 *	@date		2011.09.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <gflib.h>

#include "system/motion/BaseMotionCharacter.h"
#include "system/dress_up/DressUpModel.h"


namespace field{
namespace mmodel{


//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------
class Move3DVisibleModel
{
  GFL_FORBID_COPY_AND_ASSIGN(Move3DVisibleModel);

public:
  enum Type
  {
    TYPE_NONE,
    TYPE_MODEL,
    TYPE_DRESS_UP_MODEL
  };

public:
  Move3DVisibleModel(void);
  virtual ~Move3DVisibleModel();

  void CreateModel(
      gfl::heap::NwAllocator*  heap_allocator,
      gfl::heap::NwAllocator*  device_allocator,
      gfl::grp::g3d::Resource* resource,
      const s32                index_in_resource
  );
  void CreateDressUpModel(
      gfl::heap::NwAllocator*  heap_allocator,
      gfl::heap::NwAllocator*  device_allocator,
      gfl::grp::g3d::Resource* resource,
      const s32                index_in_resource
  );
  void Destroy(void);
  
  void SetTranslate(const gfl::math::VEC3& t);

  void AddToScene(gfl::grp::g3d::Scene* scene);
  void RemoveFromScene(gfl::grp::g3d::Scene* scene);
  void SwitchEdgeMap(gfl::grp::g3d::Scene* scene, const b32 cast_on);

  void SetMotion(proj::motion::BaseMotionCharacter* motion_character);

public:
  Type                                GetType(void) const { return m_type; }
  gfl::grp::g3d::Model*               GetModel(void) const { return m_model; }
  xy_system::dress_up::DressUpModel*  GetDressUpModel(void) const { return m_dress_up_model; }

private:
  Type                                m_type;
  gfl::grp::g3d::Model*               m_model;
  xy_system::dress_up::DressUpModel*  m_dress_up_model;
};


} // field
} // mmodel

#endif	// __MOVE3DVISIBLEMODEL_H__

