//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		Move3DVisibleModel.cpp
 *	@brief  샂f3Ďڃf
 *	@author	Koji Kawada
 *	@date		2011.09.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <gflib.h>

#include "Move3DVisibleModel.h"


namespace field{
namespace mmodel{


//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------
Move3DVisibleModel::Move3DVisibleModel(void)
  : m_type(TYPE_NONE),
    m_model(NULL),
    m_dress_up_model(NULL)
{
  // Ȃ
}
Move3DVisibleModel::~Move3DVisibleModel()
{
  Destroy();
}

void Move3DVisibleModel::CreateModel(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    gfl::grp::g3d::Resource* resource,
    const s32                index_in_resource
)
{
  if( m_type == TYPE_NONE )
  {
    m_model = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Model;
    m_model->Create(heap_allocator, device_allocator, resource, index_in_resource);
    m_type = TYPE_MODEL;
  }
  else
  {
    GFL_ASSERT_MSG(0, "Ƀ^Cv%d̃f𐶐Ă̂Őł܂B\n", m_type);
  }
}

void Move3DVisibleModel::CreateDressUpModel(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    gfl::grp::g3d::Resource* resource,
    const s32                index_in_resource
)
{
  if( m_type == TYPE_NONE )
  {
    //m_dress_up_model = GFL_NEW(heap_allocator->GetHeapBase()) xy_system::dress_up::DressUpModel;
    //m_dress_up_model->Create(heap_allocator, device_allocator, resource, index_in_resource);
    m_type = TYPE_DRESS_UP_MODEL;
  }
  else
  {
    GFL_ASSERT_MSG(0, "Ƀ^Cv%d̃f𐶐Ă̂Őł܂B\n", m_type);
  }
}

void Move3DVisibleModel::Destroy(void)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      if( m_model )
      {
        GFL_DELETE m_model;
        m_model = NULL;
      }
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
      if( m_dress_up_model )
      {
        GFL_DELETE m_dress_up_model;
        m_dress_up_model = NULL;
      }
    }
    break;
  }
  m_type = TYPE_NONE;
}

void Move3DVisibleModel::SetTranslate(const gfl::math::VEC3& t)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      m_model->SetTranslate(t);
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
      //m_dress_up_model->;
    }
    break;
  }
}

void Move3DVisibleModel::AddToScene(gfl::grp::g3d::Scene* scene)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      scene->AddSceneNode( m_model );
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
    }
    break;
  }
}
void Move3DVisibleModel::RemoveFromScene(gfl::grp::g3d::Scene* scene)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      scene->RemoveSceneNode( m_model );
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
    }
    break;
  }
}
void Move3DVisibleModel::SwitchEdgeMap(gfl::grp::g3d::Scene* scene, const b32 cast_on)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      scene->SwitchEdgeMapModel( m_model, cast_on );
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
    }
    break;
  }
}

void Move3DVisibleModel::SetMotion(proj::motion::BaseMotionCharacter* motion_character)
{
  switch( m_type )
  {
  case TYPE_MODEL:
    {
      motion_character->ToModel(m_model);
    }
    break;
  case TYPE_DRESS_UP_MODEL:
    {
    }
    break;
  }
}


} // field
} // mmodel
