#pragma	once

#include "gamesystem/GameStrLen.h"
#include "netapp/gfeachother/GFEachOther.h"


namespace field {
namespace subscreen {

class PSS_SendData {
public:
	typedef struct {
		gfl::str::STRCODE	name[gamesystem::STRLEN_PLAYER_NAME];
		u32	id;
		bool	enable;
	}PSS_SEND_DATA;


	PSS_SendData( const PSS_SEND_DATA * dat, gfl::heap::HeapBase * pBase, gfl::heap::HeapBase * pDev );
	virtual ~PSS_SendData(void);

	void Update(void);

	void Finalized(void);
	bool IsFinalized(void);

	void SetMyData( const PSS_SEND_DATA * dat );
	const PSS_SEND_DATA * GetMyData(void);

	const PSS_SEND_DATA * GetFriendData( u32 index );

private:
	void CreateGFEachOther( const PSS_SEND_DATA * dat, gfl::heap::HeapBase * pBase, gfl::heap::HeapBase * pDev );
	void DeleteGFEachOther(void);

private:
	netapp::beacon::GFEachOther * gfEachOther;

	PSS_SEND_DATA	myData;		// ̃f[^

	PSS_SEND_DATA	friendData[netapp::beacon::GFEachOther::BEACON_MAX];				// FB̃f[^
	PSS_SEND_DATA	acquaintanceData[netapp::beacon::GFEachOther::BEACON_MAX];	// m荇̃f[^
	PSS_SEND_DATA	strangerData[netapp::beacon::GFEachOther::BEACON_MAX];			// ʂ肷̃f[^
};

}		// subscreen
}		// field
