#include "fieldmenu_pss_senddata.h"


namespace field {
namespace subscreen {


PSS_SendData::PSS_SendData( const PSS_SEND_DATA * dat, gfl::heap::HeapBase * pBase, gfl::heap::HeapBase * pDev )
{
	CreateGFEachOther( dat, pBase, pDev );
}

PSS_SendData::~PSS_SendData(void)
{
	GFL_ASSERT( IsFinalized() );

	DeleteGFEachOther();
}

void PSS_SendData::Update(void)
{
	gfEachOther->Main();

	for( int i=0; i<netapp::beacon::GFEachOther::BEACON_MAX; i++ ){
		const PSS_SEND_DATA * buf = (const PSS_SEND_DATA *)gfEachOther->GetBeacon( i );
		if( buf == NULL ){
			break;
		}
	}
}

void PSS_SendData::CreateGFEachOther( const PSS_SEND_DATA * dat, gfl::heap::HeapBase * pBase, gfl::heap::HeapBase * pDev )
{
	gfEachOther = GFL_NEW( pBase ) netapp::beacon::GFEachOther::GFEachOther( pBase, pDev );

	myData = *dat;
	gfEachOther->Initialize( (const u8 *)&myData );
}

void PSS_SendData::DeleteGFEachOther(void)
{
	GFL_DELETE gfEachOther;
}

void PSS_SendData::Finalized(void)
{
	gfEachOther->Finalize();
}

bool PSS_SendData::IsFinalized(void)
{
	return gfEachOther->IsFinalized();
}

void PSS_SendData::SetMyData( const PSS_SEND_DATA * dat )
{
	myData = *dat;
	gfEachOther->ChangeData( (const u8 *)&myData );
}

const PSS_SendData::PSS_SEND_DATA * PSS_SendData::GetMyData(void)
{
	return &myData;
}

const PSS_SendData::PSS_SEND_DATA * PSS_SendData::GetFriendData( u32 index )
{
	return &friendData[index];
}




}		// subscreen
}		// field
