//============================================================================
/**
 *
 *	@file		ScriptWork.h
 *	@brief  
 *	@author hosaka genya
 *	@data		2011.09.13
 *
 */
//============================================================================
#ifndef __SCRIPTWORK_H__
#define __SCRIPTWORK_H__ 

//system
#include "gamesystem/GameEvent.h"

#include "field/EventWorkDef.h" // CxgtOA[N`

//#include "../../src/field/movemodel/FieldMoveModelBase.h" // for MoveModelBase
#include "..//movemodel/FieldMoveModelBase.h" // for MoveModelBase

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

//--------------------------------------------------------------
///	script::Work XNvg[N
//==============================================================
class Work
{ 
  GFL_FORBID_COPY_AND_ASSIGN( Work );
public:
  Work( gamesystem::GameEvent* p_event, gamesystem::GameManager* p_gman );
  ~Work( void ){}
  
  gamesystem::GameEvent* GetEvent( void ) const { return m_pBaseEvent; }

  u16* GetSeq( void ) { return &m_Seq; }
  void** GetUserWork( void ) { return &m_pUserWork; }
  void ClearUserWork( void );
  
  mmodel::MoveModelBase* GetTargetObj( void ) const { return m_pTalkModel; }
  void SetTargetObj( mmodel::MoveModelBase* p_mdl );
  
  u16* GetEventWork( u16 work_no );
  u16  GetEventWorkValue( u16 work_no );
  bool SetEventWorkValue( u16 work_no, u16 value );

private:

  enum
  {
    MAGIC_NO = 0x3643f,
    TEMP_WORK_START = SCWK_AREA_START,
    TEMP_WORK_END = USERWK_AREA_END,
    TEMP_WORK_SIZE = TEMP_WORK_END - TEMP_WORK_START,

    USERWK_SIZE = USERWK_AREA_END - USERWK_AREA_START,
  };
  
  u32 m_MagicNo;
  u16 m_Seq;
  void* m_pUserWork;
  gamesystem::GameManager*  m_pGameManager;
  gamesystem::GameEvent* m_pBaseEvent;
  mmodel::MoveModelBase* m_pTalkModel;
	
  u16 m_ScrTempWork[ TEMP_WORK_SIZE ];	//[N(ANSWORK,TMPWORKȂǂ̑)

  u16* GetTempWork( u16 work_no );

#if 0
  //
  //script.c Privateȃo
  //
	u32 magic_no;			//Cxg̃[NXNvg䃏[N𔻕
	
  //
  //SCRIPT_WORKɈŏAReadOnlyŊOJ郁o
  //
	u16 start_scr_id;			//C̃XNvgID
	MMDL *target_obj;

	HEAPID main_heapID;

	GAMESYS_WORK *gsys;
  GMEVENT *gmevent; //XNvgsĂGMEVENT*
	SCRIPT_FLDPARAM fld_param;

	u16 *ret_script_wk;			//XNvgʂ郏[Ñ|C^

  BOOL is_sp_flag;    ///<XNvgǂH̃tO@TRUE=XNvg
  SCRIPT_TYPE scr_type;   ///<sXNvg̎

  //
  //script.cŎgpȂAOJpo
  //  public R/W
  //
	WORDSET* wordset;				//PZbg
	STRBUF* msg_buf;				//bZ[Wobt@|C^
	STRBUF* tmp_buf;				//e|obt@|C^
	GFL_FONT* font;			    //tHg|C^@C_aÍtHgɎgp
#endif 
};

GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

#endif // __SCRIPTWORK_H__
