//=============================================================================
/**
 *
 *	@file		ScriptWork.cpp
 *	@brief  
 *	@author hosaka genya
 *	@data		2011.09.13
 *
 */
//=============================================================================
#include "ScriptWork.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

//-----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	gamesystem::GameEvent* event CxgNꂽ̃Cxg
 */
//-----------------------------------------------------------------------------
Work::Work( gamesystem::GameEvent* p_event, gamesystem::GameManager* p_gman ) :
  m_MagicNo( MAGIC_NO ),
  m_Seq(0),
  m_pUserWork( NULL ),
  m_pGameManager( p_gman ),
  m_pBaseEvent( p_event )
{

}

//-----------------------------------------------------------------------------
/**
 *	@brief  [U[[NNA
 */
//-----------------------------------------------------------------------------
void Work::ClearUserWork( void )
{
  GFL_SAFE_DELETE( m_pUserWork );
}


//-----------------------------------------------------------------------------
/**
 *	@brief  bfݒ
 *
 *	@param	mmodel::MoveModelBase* p_mdl 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void Work::SetTargetObj( mmodel::MoveModelBase* p_mdl )
{
  m_pTalkModel = p_mdl;
  if( p_mdl )
  {
    u16* p_objid;
    p_objid = GetTempWork( SCWK_TARGET_OBJID );
    *p_objid = p_mdl->GetOBJID();
  }
}

//-----------------------------------------------------------------------------
/**
 *	@brief  Cxg[N擾
 *
 *	@param	u16 work_no  [Nio[
 *
 *	@retval [ÑAhX
 *
 *  @li	work_no < 0x8000	ʏ̃Z[u[N
 *  @li	work_no >= 0x8000	XNvg䃏[N̒ɊmۂĂ郏[N
 */
//-----------------------------------------------------------------------------
u16* Work::GetEventWork( u16 work_no )
{
  EventWork* ev = m_pGameManager->GetGameData()->GetEventWork();
  
  if( work_no < SVWK_START )
  {
    GFL_ASSERT(0);
    return NULL;
  }
  
  if( work_no < SCWK_START )
  {
    return ev->GetEventWorkAdrs( work_no );
  }
  
  if( work_no < SCWK_END )
  {
    //XNvg䃏[N̒ŁAANSWORKȂǂ̃[NmۂĂ܂
    return GetTempWork( work_no );
  }
  
  GFL_ASSERT(0);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  Cxg[N̒l擾
 *
 *	@param	u16 work_no  [Nio[
 *
 *	@retval [N̒l
 */
//-----------------------------------------------------------------------------
u16 Work::GetEventWorkValue( u16 work_no )
{
  u16 *res = GetEventWork( work_no );
  if( res == NULL ){ GFL_ASSERT(0); return work_no; }
  return *res;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  Cxg[N̒lZbg
 *
 *	@param	u16 work_no  [Nio[
 *	@param	value  Zbgl
 *
 *	@retval true:Zbgł, false:łȂ
 */
//-----------------------------------------------------------------------------
bool Work::SetEventWorkValue( u16 work_no, u16 value )
{
  u16 *res = GetEventWork( work_no );
  if( res == NULL ){ return false; }
  *res = value;
  return true;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  ꎞL[N擾
 *
 *	@param	u16 work_no [NNO
 *
 *	@retval [Nւ̃AhX
 */
//-----------------------------------------------------------------------------
u16* Work::GetTempWork( u16 work_no )
{
  GFL_ASSERT( work_no >= TEMP_WORK_START );
  GFL_ASSERT( work_no < TEMP_WORK_END );
  
  return &( m_ScrTempWork[ work_no - TEMP_WORK_START ] );
}

GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

