//=======================================================================================
/**
 * @file app_status_WazaList.cpp
 * @brief Xe[^Xʂ̋Z\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <system/main.h>
#include "app_status_Common.h"
#include "app_status_WazaList.h"


namespace app { 
  namespace status {



    // q[vTCY
    const u32 WazaList::APP_HEAPSIZE    =   0x1000;
    const u32 WazaList::DEVICE_HEAPSIZE = 0x100000;



    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //-------------------------------------------------------------------------------
    WazaList::WazaList( void ) :
      Common( 
          HEAPID_STATUS_WAZALIST, APP_HEAPSIZE, 
          HEAPID_STATUS_DEVICE_WAZALIST, DEVICE_HEAPSIZE ),
      m_result( RESULT_NONE )
    {
    }



    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    WazaList::~WazaList()
    {
    }




    //-------------------------------------------------------------------------------
    /**
     * @brief \|PύX
     * @param pokepara  \p[^
     */
    //-------------------------------------------------------------------------------
    void WazaList::ChangePokemon( const pml::pokepara::PokemonParam* pokeparam )
    {
    }






    //-------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //-------------------------------------------------------------------------------
    void WazaList::Update( void )
    {
      m_result = RESULT_NONE;

      gfl::ui::Button* button = this->GetButton();
      if( button->IsTrigger( gfl::ui::BUTTON_UP ) )
      {
        m_result = RESULT_PREV_POKE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_DOWN ) )
      {
        m_result = RESULT_NEXT_POKE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_RIGHT ) )
      {
        m_result = RESULT_RIBBON;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_B ) )
      {
        m_result = RESULT_RETURN;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_X ) )
      {
        m_result = RESULT_EXIT;
      }
    }





    //-------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //-------------------------------------------------------------------------------
    void WazaList::Draw( void )
    {
    }





  } // namespace status 
} // namespace app
