//=======================================================================================
/**
 * @file app_status_RibbonList.cpp
 * @brief Xe[^Xʂ̃{\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <system/main.h>
#include "app_status_Common.h"
#include "app_status_RibbonList.h"


namespace app { 
  namespace status {



    // q[vTCY
    const u32 RibbonList::APP_HEAPSIZE    =   0x1000;
    const u32 RibbonList::DEVICE_HEAPSIZE = 0x100000;



    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //-------------------------------------------------------------------------------
    RibbonList::RibbonList( void ) :
      Common( 
          HEAPID_STATUS_RIBBONLIST, APP_HEAPSIZE, 
          HEAPID_STATUS_DEVICE_RIBBONLIST, DEVICE_HEAPSIZE ),
      m_result( RESULT_NONE )
    {
    }



    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    RibbonList::~RibbonList()
    {
    }




    //-------------------------------------------------------------------------------
    /**
     * @brief \|PύX
     * @param pokepara  \p[^
     */
    //-------------------------------------------------------------------------------
    void RibbonList::ChangePokemon( const pml::pokepara::PokemonParam* pokeparam )
    {
    }






    //-------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //-------------------------------------------------------------------------------
    void RibbonList::Update( void )
    {
      m_result = RESULT_NONE;

      gfl::ui::Button* button = this->GetButton();
      if( button->IsTrigger( gfl::ui::BUTTON_UP ) )
      {
        m_result = RESULT_PREV_POKE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_DOWN ) )
      {
        m_result = RESULT_NEXT_POKE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_LEFT ) )
      {
        m_result = RESULT_WAZA;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_B ) )
      {
        m_result = RESULT_RETURN;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_X ) )
      {
        m_result = RESULT_EXIT;
      }
    }





    //-------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //-------------------------------------------------------------------------------
    void RibbonList::Draw( void )
    {
    }





  } // namespace status 
} // namespace app
