//========================================================================================
/**
 * @file app_status_Process.h
 * @brief |PXe[^XʃvZX
 * @author obata_toshihiro
 * @date 2011.09.10
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h> 
#include <app/status/app_status_Process.h> 
#include "app_status_Common.h"
#include "app_status_Params.h"
#include "app_status_TrMemo.h"
#include "app_status_Info.h"
#include "app_status_WazaList.h"
#include "app_status_RibbonList.h"


namespace app {
  namespace status {




    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //--------------------------------------------------------------------------------
    Process::Process( void ) : 
      m_settings(),
      m_now_poke_index( 0 ),
      m_seq( SEQ_WAZA ),
      m_params( NULL ),
      m_memo( NULL ),
      m_info( NULL ),
      m_wazalist( NULL ),
      m_ribbonlist( NULL )
    {
    }



    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    Process::~Process()
    {
    }



    //--------------------------------------------------------------------------------
    /**
     * @brief \ݒZbg
     */
    //--------------------------------------------------------------------------------
    void Process::SetSetting( const Setting& settings )
    {
      m_settings = settings;
      m_now_poke_index = settings.init_poke_index;
    }








    //--------------------------------------------------------------------------------
    /**
     * @brief	vZX̏
     * @param proc_manager  vZX̃}l[W
     * @retval RES_CONTINUE  p
     * @retval RES_FINISH    I
     */
    //-------------------------------------------------------------------------------- 
    gfl::proc::Result Process::InitFunc( gfl::proc::Manager* proc_manager )
    {
      Common::Initialize();

      gfl::heap::HeapBase* heap = Common::GetRootHeap(); 
      app::util::Initialize( heap );

      m_params = GFL_NEW( heap ) Params();
      m_memo = GFL_NEW( heap ) TrMemo();
      m_info = GFL_NEW( heap ) Info();
      m_wazalist = GFL_NEW( heap ) WazaList();
      m_ribbonlist = GFL_NEW( heap ) RibbonList();

      this->ChangeSequence( SEQ_WAZA );

      return gfl::proc::RES_FINISH;
    }





    //-------------------------------------------------------------------------------- 
    /**
     * @brief vZX̏I
     * @param proc_manager  vZX̃}l[W
     * @retval RES_CONTINUE  Ip
     * @retval RES_FINISH    II
     */
    //-------------------------------------------------------------------------------- 
    gfl::proc::Result Process::EndFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_DELETE m_params;
      GFL_DELETE m_memo;
      GFL_DELETE m_info;
      GFL_DELETE m_wazalist;
      GFL_DELETE m_ribbonlist;
      app::util::Finalize();
      Common::Finalize();
      return gfl::proc::RES_FINISH;
    }






    //-------------------------------------------------------------------------------- 
    /**
     * @brief vZX̍XV
     * @param proc_manager  vZX̃}l[W
     * @retval RES_CONTINUE  Cp
     * @retval RES_FINISH    CI
     */
    //-------------------------------------------------------------------------------- 
    gfl::proc::Result Process::UpdateFunc( gfl::proc::Manager* proc_manager )
    { 
      switch( m_seq ) {
      case SEQ_WAZA: return this->Update_WAZA();
      case SEQ_RIBBON: return this->Update_RIBBON();
      }
      GFL_ASSERT(0);
      return gfl::proc::RES_CONTINUE;
    }


    /**
     * @brief SEQ_WAZA ̍XV
     * @return vZX̌
     */
    gfl::proc::Result Process::Update_WAZA( void )
    {
      m_params->Update();

      m_info->Update();
      if( m_info->GetResult() == Info::RESULT_CHANGE )  // {[^b`ꂽ
      {
        m_now_poke_index = m_info->GetChangePokeIndex();
        this->ChangePokemon( SEQ_WAZA, m_now_poke_index );
      }
      else
      {
        m_wazalist->Update();
        switch( m_wazalist->GetResult() )
        {
        case WazaList::RESULT_RETURN:  //uǂvI
          return gfl::proc::RES_FINISH; 

        case WazaList::RESULT_EXIT:  //uIvI
          return gfl::proc::RES_FINISH; 

        case WazaList::RESULT_RIBBON:  // {\
          this->ChangeSequence( SEQ_RIBBON );
          return gfl::proc::RES_CONTINUE; 

        case WazaList::RESULT_PREV_POKE:  // Õ|P\
          {
            m_now_poke_index = this->GetPrevPokeIndex( m_now_poke_index );
            this->ChangePokemon( SEQ_WAZA, m_now_poke_index );
          }
          return gfl::proc::RES_CONTINUE; 

        case WazaList::RESULT_NEXT_POKE:  // ̃|P\
          {
            m_now_poke_index = this->GetNextPokeIndex( m_now_poke_index );
            this->ChangePokemon( SEQ_WAZA, m_now_poke_index );
          }
          return gfl::proc::RES_CONTINUE;
        }
      } 

      return gfl::proc::RES_CONTINUE;
    }





    /**
     * @brief SEQ_RIBBON ̍XV
     * @return vZX̌
     */
    gfl::proc::Result Process::Update_RIBBON( void )
    {
      m_memo->Update();

      m_info->Update();
      if( m_info->GetResult() == Info::RESULT_CHANGE )  // {[^b`ꂽ
      {
        m_now_poke_index = m_info->GetChangePokeIndex();
        this->ChangePokemon( SEQ_RIBBON, m_now_poke_index );
      }
      else
      {
        m_ribbonlist->Update();

        switch( m_ribbonlist->GetResult() )
        {
        case RibbonList::RESULT_RETURN:  //uǂvI
          return gfl::proc::RES_FINISH; 

        case RibbonList::RESULT_EXIT:  //uIvI
          return gfl::proc::RES_FINISH; 

        case RibbonList::RESULT_WAZA:  // 킴\
          this->ChangeSequence( SEQ_RIBBON );
          return gfl::proc::RES_CONTINUE; 

        case RibbonList::RESULT_PREV_POKE:  // Õ|P\
          {
            m_now_poke_index = this->GetPrevPokeIndex( m_now_poke_index );
            this->ChangePokemon( SEQ_RIBBON, m_now_poke_index );
          }
          return gfl::proc::RES_CONTINUE; 

        case RibbonList::RESULT_NEXT_POKE:  // ̃|P\
          {
            m_now_poke_index = this->GetNextPokeIndex( m_now_poke_index );
            this->ChangePokemon( SEQ_RIBBON, m_now_poke_index );
          }
          return gfl::proc::RES_CONTINUE;
        }
      }

      return gfl::proc::RES_CONTINUE;
    }





    /**
     * @brief Õ|P̃CfbNX擾
     * @param now  ݂̃CfbNX
     * @return ÕCfbNX
     */
    u8 Process::GetPrevPokeIndex( u8 now ) const
    {
      for( s8 i=now-1; 0<=i; i-- ) {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam(i);
        if( !pokeparam->IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ) {
          return i;
        }
      }
      return now;
    }


    /**
     * @brief ̃|P̃CfbNX擾
     * @param now  ݂̃CfbNX
     * @return ̃CfbNX
     */
    u8 Process::GetNextPokeIndex( u8 now ) const
    {
      u8 member_count = m_settings.poke_party->GetMemberCount();
      for( u8 i=now+1; i<member_count; i++ ) {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam(i);
        if( !pokeparam->IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ) {
          return i;
        }
      }
      return now;
    } 


    /**
     * @brief |Pp[^擾
     * @param index  p[eBCfbNX
     */
    const pml::pokepara::PokemonParam* Process::GetPokeParam( u8 index ) const
    {
      return m_settings.poke_party->GetMemberPointer( index );
    }



    /**
     * @brief \|PύX
     * @param seq         V[PX
     * @param poke_index  \|P̃CfbNX
     */
    void Process::ChangePokemon( Sequence seq, u8 poke_index )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam( poke_index );

      switch( seq )
      {
      default:
        GFL_ASSERT(0);

      case SEQ_WAZA:
        m_info->ChangePokemon( m_settings.poke_party, poke_index );
        m_params->ChangePokemon( pokeparam );
        m_wazalist->ChangePokemon( pokeparam );
        break;

      case SEQ_RIBBON:
        m_info->ChangePokemon( m_settings.poke_party, poke_index );
        m_memo->ChangePokemon( pokeparam );
        m_ribbonlist->ChangePokemon( pokeparam );
        break;
      }
    }



    /**
     * @brief V[PXύX
     * @param seq  ̃V[PX
     */
    void Process::ChangeSequence( Sequence seq )
    {
      switch( seq )
      {
      default:
        GFL_ASSERT(0);

      case SEQ_WAZA:
        this->ChangePokemon( seq, m_now_poke_index );
        break;

      case SEQ_RIBBON:
        this->ChangePokemon( seq, m_now_poke_index );
        break;
      }

      m_seq = seq;
    }








    //-------------------------------------------------------------------------------- 
    /**
     * @brief vZX̕`揈
     * @param proc_manager  vZX̃}l[W
     */
    //-------------------------------------------------------------------------------- 
    void Process::DrawFunc( gfl::proc::Manager* proc_manager )
    {
      switch( m_seq )
      {
      case SEQ_WAZA:
        m_info->Draw();
        m_params->Draw();
        m_wazalist->Draw();
        break;

      case SEQ_RIBBON:
        m_info->Draw();
        m_memo->Draw();
        m_ribbonlist->Draw();
        break;
      }
    }








  } // namespace status
} // namespace app
