//=======================================================================================
/**
 * @file app_status_Params.h
 * @brief Xe[^Xʂ̃p[^\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#ifndef __APPSTATUS_PARAMS_H__
#define __APPSTATUS_PARAMS_H__
#include <gflib.h>
#include <pmlib.h>
#include "app_status_Common.h"


namespace app { 
  namespace status {


    class Params : public Common
    {
      GFL_FORBID_COPY_AND_ASSIGN( Params );  // Rs[֎~


      public:

      //-------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //-------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       */
      Params( void );

      /**
       * @brief fXgN^
       */
      virtual ~Params();



      //-------------------------------------------------------------------------------
      // 
      //-------------------------------------------------------------------------------
      /**
       * @brief \|PύX
       * @param pokeparam  \p[^
       */
      void ChangePokemon( const pml::pokepara::PokemonParam* pokeparam );

      /**
       * @brief p[^\
       */
      void DispParams( void );

      /**
       * @brief Z̏\
       * @param wazano  \Z
       */
      void DispWaza( WazaNo wazano );



      //-------------------------------------------------------------------------------
      // {
      //-------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      void Update( void );

      /**
       * @brief `揈
       */
      void Draw( void );



      private:

      // Aj[Vf[^ԍ
      enum AnimationData {
        ANIME_DATA_POKE_TYPE1,
        ANIME_DATA_POKE_TYPE2,
        ANIME_DATA_HP_GAUGE,
        ANIME_DATA_EXP_GAUGE,
        ANIME_DATA_WAZA_KIND,
        ANIME_DATA_SCENE_PARAM,
        ANIME_DATA_SCENE_WAZA,
        ANIME_DATA_NUM,
      };

      // Aj[Vԍ
      enum Animation {
        ANIME_POKE_TYPE1,
        ANIME_POKE_TYPE2,
        ANIME_HP_GAUGE,
        ANIME_EXP_GAUGE,
        ANIME_WAZA_KIND,
        ANIME_SCENE_PARAM,
        ANIME_SCENE_WAZA,
        ANIME_NUM,
      };


      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 ZUKAN_PLACE_COUNT;
      static const u32 ID_PLACE_COUNT;
      static const u32 POWER_PLACE_COUNT;
      static const u32 EXP_PLACE_COUNT; 
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];

      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;


      void CreateLayoutWork( void );
      void DeleteLayoutWork( void );

      void SetupStaticStrings( void );
      void SetupPokeParam( const pml::pokepara::PokemonParam* pokeparam );
    }; 


  } // namespace status 
} // namespace app


#endif  // __APPSTATUS_PARAMS_H__
