//=======================================================================================
/**
 * @file app_status_Params.h
 * @brief Xe[^Xʂ̃p[^\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <system/main.h>
#include "app_status_Common.h"
#include "app_status_Params.h"

#include <arc/arc_def.h>
#include <arc/status.gaix>
#include <message/msg_pokemon_status.h>
#include "params.h"
#include "params_pane.h"


namespace app { 
  namespace status {


    // q[vTCY
    const u32 Params::APP_HEAPSIZE    =   0x1000;
    const u32 Params::DEVICE_HEAPSIZE = 0x100000;

    // ľ
    const u32 Params::ZUKAN_PLACE_COUNT = 3;
    const u32 Params::ID_PLACE_COUNT = 5;
    const u32 Params::POWER_PLACE_COUNT = 3;
    const u32 Params::EXP_PLACE_COUNT = 7;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Params::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, -290, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),     // rotate
      1,                              // priority
    };



    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Params::ANIME_DATA_TABLE[ Params::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_POKE_TYPE1 */ LYTRES_PARAMS_PARAMS_POKE_TYPE1_BCLAN,
      /* ANIME_DATA_POKE_TYPE2 */ LYTRES_PARAMS_PARAMS_POKE_TYPE2_BCLAN,
      /* ANIME_DATA_HP_GAUGE */ LYTRES_PARAMS_PARAMS_HP_GAUGE_BCLAN,
      /* ANIME_DATA_EXP_GAUGE */ LYTRES_PARAMS_PARAMS_EXP_GAUGE_BCLAN,
      /* ANIME_DATA_WAZA_KIND */ LYTRES_PARAMS_PARAMS_WAZA_KIND_BCLAN,
      /* ANIME_DATA_SCENE_PARAM */ LYTRES_PARAMS_PARAMS_SCENE_PARAM_BCLAN,
      /* ANIME_DATA_SCENE_WAZA */ LYTRES_PARAMS_PARAMS_SCENE_WAZA_BCLAN,
    }; 






    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //-------------------------------------------------------------------------------
    Params::Params( void ) : 
      Common( 
          HEAPID_STATUS_PARAMS, APP_HEAPSIZE, 
          HEAPID_STATUS_DEVICE_PARAMS, DEVICE_HEAPSIZE ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 )
    {
      this->CreateLayoutWork();
      this->SetupStaticStrings();
    }


    /**
     * @brief CAEg[N𐶐
     */
    void Params::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_STATUS, heap );
      m_layout_resource_id = 
        layout_system->LoadLytRes( device_allocator, &arc_file, GARC_status_params_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id, 
          LYTRES_PARAMS_PARAMS_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // XV, `ŊǗ
    } 


    /**
     * @brief ÓIZbg
     */
    void Params::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message = this->GetCommonMessage();
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_ZUKAN, message, PARAM_ZUKAN_NO );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_POKE_NAME, message, PARAM_NAME );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_POKE_TYPE, message, PARAM_TYPE );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_ID, message, PARAM_ID_NO );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_PARENT, message, PARAM_OYA );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_EXP, message, PARAM_EXP );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_NEXT_LEVEL_00, message, PARAM_EXP_NEXT_01 );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_NEXT_LEVEL_01, message, PARAM_EXP_NEXT_02 );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_HP, message, PARAM_HP );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_ATK, message, PARAM_ATK );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_DEF, message, PARAM_DEF );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_SPATK, message, PARAM_SPATK );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_SPDEF, message, PARAM_SPDEF );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_PARAMS_PANE_AGI, message, PARAM_AGI );
    }








    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    Params::~Params()
    {
    }




    //-------------------------------------------------------------------------------
    /**
     * @brief \|PύX
     * @param pokeparam  \p[^
     */
    //-------------------------------------------------------------------------------
    void Params::ChangePokemon( const pml::pokepara::PokemonParam* pokeparam )
    {
    } 




    //-------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //-------------------------------------------------------------------------------
    void Params::Update( void )
    {
    }


    //-------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //-------------------------------------------------------------------------------
    void Params::Draw( void )
    {
    }




  } // namespace status 
} // namespace app
