//=======================================================================================
/**
 * @file app_status_Info.h
 * @brief Xe[^Xʂ̃|P{\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#ifndef __APPSTATUS_INFO_H__
#define __APPSTATUS_INFO_H__
#include <gflib.h>
#include <pmlib.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "app_status_Common.h"


namespace app { 
  namespace status {


    class Info : public Common
    {
      GFL_FORBID_COPY_AND_ASSIGN( Info );  // Rs[֎~


      public:

      //-------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //-------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       */
      Info( void );

      /**
       * @brief fXgN^
       */
      virtual ~Info();



      //-------------------------------------------------------------------------------
      // 
      //-------------------------------------------------------------------------------
      /**
       * @brief \|PύX
       * @param poke_party  \p[eB
       * @param poke_index  Ԗڂ̃|PH
       */
      void ChangePokemon( const pml::PokeParty* poke_party, u8 poke_index );


      
      //-------------------------------------------------------------------------------
      // {
      //-------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      void Update( void );

      /**
       * @brief `揈
       */
      void Draw( void );



      //-------------------------------------------------------------------------------
      // 
      //-------------------------------------------------------------------------------
      enum Result {
        RESULT_NONE,   // Ȃ
        RESULT_CHANGE, // |PύX
      };

      /**
       * @brief XV̌ʂ擾
       */
      Result GetResult( void ) const { return m_result; }

      /**
       * @brief ύXΏۃ|P̃CfbNX擾
       * @note RESULT_CHANGE ̏ꍇɂ̂ݗL
       */
      u8 GetChangePokeIndex( void ) const { return m_change_poke_index; }




      private: 


      // {^ԍ
      enum Button {
        BUTTON_POKE0,
        BUTTON_POKE1,
        BUTTON_POKE2,
        BUTTON_POKE3,
        BUTTON_POKE4,
        BUTTON_POKE5,
        BUTTON_NUM,
      };

      // Aj[Vf[^ԍ
      enum AnimationData {
        ANIME_DATA_POKE_SICK,
        ANIME_DATA_POKE_DEAD,
        ANIME_DATA_POKE_POKERUS,
        ANIME_DATA_DUMMY_BALL_IN,
        ANIME_DATA_DUMMY_BALL_ROCK,
        ANIME_DATA_DUMMY_BALL_OUT,
        ANIME_DATA_BALL_00_ACTIVE,
        ANIME_DATA_BALL_00_PASSIVE,
        ANIME_DATA_BALL_01_ACTIVE,
        ANIME_DATA_BALL_01_PASSIVE,
        ANIME_DATA_BALL_02_ACTIVE,
        ANIME_DATA_BALL_02_PASSIVE,
        ANIME_DATA_BALL_03_ACTIVE,
        ANIME_DATA_BALL_03_PASSIVE,
        ANIME_DATA_BALL_04_ACTIVE,
        ANIME_DATA_BALL_04_PASSIVE,
        ANIME_DATA_BALL_05_ACTIVE,
        ANIME_DATA_BALL_05_PASSIVE,
        ANIME_DATA_NUM,
      };

      // Aj[Vԍ
      enum Animation {
        ANIME_POKE_SICK,
        ANIME_POKE_DEAD,
        ANIME_POKE_POKERUS,
        ANIME_DUMMY_BALL_IN,
        ANIME_DUMMY_BALL_ROCK,
        ANIME_DUMMY_BALL_OUT,
        ANIME_BALL_00_ACTIVE,
        ANIME_BALL_00_PASSIVE,
        ANIME_BALL_01_ACTIVE,
        ANIME_BALL_01_PASSIVE,
        ANIME_BALL_02_ACTIVE,
        ANIME_BALL_02_PASSIVE,
        ANIME_BALL_03_ACTIVE,
        ANIME_BALL_03_PASSIVE,
        ANIME_BALL_04_ACTIVE,
        ANIME_BALL_04_PASSIVE,
        ANIME_BALL_05_ACTIVE,
        ANIME_BALL_05_PASSIVE,
        // ȉ, LAj[V
        ANIME_BALL_IN,
        ANIME_BALL_ROCK = ANIME_BALL_IN + pml::PokeParty::MAX_MEMBERS,
        ANIME_BALL_OUT = ANIME_BALL_ROCK + pml::PokeParty::MAX_MEMBERS,
        ANIME_NUM = ANIME_BALL_OUT + pml::PokeParty::MAX_MEMBERS,
        ANIME_NULL,
      };

      // LAj[Vԍ
      enum ShareAnimation {
        SHARE_ANIME_BALL_IN,
        SHARE_ANIME_BALL_ROCK,
        SHARE_ANIME_BALL_OUT,
        SHARE_ANIME_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        Animation start_animation_index;                // o^CfbNX
        AnimationData animation_data_index;             // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        Result result;                            // Iꂽꍇ̌
        u8 poke_index;                            // Ή|P̃CfbNX
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        Animation hold_animation;                 // ꂽۂ̃Aj[V
        Animation release_animation;              // ꂽۂ̃Aj[V
        Animation select_animation;               // I΂ꂽۂ̃Aj[V
        Animation active_animation;               // {^Lȍۂ̃Aj[V
        Animation passive_animation;              // {^ȍۂ̃Aj[V
      };



      /**
       * @brief {[ACR
       */
      class BallIcon {
        public:
          enum State {
            STATE_WAIT,
            STATE_ROCK,
            STATE_IN,
            STATE_OUT,
          };

          // RXgN^
          BallIcon( gfl::grp::g2d::LytWk* layout_work,
              Animation in_anime, Animation out_anime, Animation rock_anime );

          // fXgN^
          virtual ~BallIcon();

          // XV
          void Update( void );

          // Ԑ
          void Wait( void ) { m_end_state = STATE_WAIT; }
          void Rock( void ) { m_end_state = STATE_ROCK; }

        private:
          gfl::grp::g2d::LytWk* m_layout_work;
          State m_end_state;
          State m_now_state;
          Animation m_in_anime;
          Animation m_out_anime;
          Animation m_rock_anime;
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 LV_PLACE_COUNT;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];

      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      BallIcon* m_ball_icons[ pml::PokeParty::MAX_MEMBERS ];

      Result m_result;
      u8 m_change_poke_index;
      s8 m_now_poke_index;


      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 
      void CreateBallIcons( void );

      void DeleteLayoutWork( void );
      void DeleteButtonManager( void );
      void DeleteBallIcons( void );

      void SetupStaticStrings( void );
      void SetupPokeParam( const pml::pokepara::PokemonParam* pokeparam );
      void SetupBallButtons( const pml::PokeParty* poke_party );

      void StartChangeAnimation( s8 old_index, s8 new_index );
    }; 


  } // namespace status 
} // namespace app


#endif  // __APPSTATUS_INFO_H__ 
