//=======================================================================================
/**
 * @file app_status_Info.h
 * @brief Xe[^Xʂ̃|P{\
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <system/main.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "app_status_Common.h"
#include "app_status_Info.h"

#include <arc/arc_def.h>
#include <arc/status.gaix>
#include <message/msg_pokemon_status.h>
#include "info.h"
#include "info_pane.h"


namespace app { 
  namespace status {


    // q[vTCY
    const u32 Info::APP_HEAPSIZE    =   0x1000;
    const u32 Info::DEVICE_HEAPSIZE = 0x100000;

    // ľ
    const u32 Info::LV_PLACE_COUNT = 3;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Info::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, -290, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),     // rotate
      1,                              // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Info::ANIME_DATA_TABLE[ Info::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_POKE_SICK */ LYTRES_INFO_INFO_POKE_SICK_BCLAN,
      /* ANIME_DATA_POKE_DEAD */ LYTRES_INFO_INFO_POKE_DEAD_BCLAN,
      /* ANIME_DATA_POKE_POKERUS */ LYTRES_INFO_INFO_POKE_POKERUS_BCLAN,
      /* ANIME_DATA_DUMMY_BALL_IN */ LYTRES_INFO_INFO_DUMMY_BALL_IN_BCLAN,
      /* ANIME_DATA_DUMMY_BALL_ROCK */ LYTRES_INFO_INFO_DUMMY_BALL_ROCK_BCLAN,
      /* ANIME_DATA_DUMMY_BALL_OUT */ LYTRES_INFO_INFO_DUMMY_BALL_OUT_BCLAN,
      /* ANIME_DATA_BALL_00_ACTIVE */ LYTRES_INFO_INFO_BALL_00_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_00_PASSIVE */ LYTRES_INFO_INFO_BALL_00_PASSIVE_BCLAN,
      /* ANIME_DATA_BALL_01_ACTIVE */ LYTRES_INFO_INFO_BALL_01_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_01_PASSIVE */ LYTRES_INFO_INFO_BALL_01_PASSIVE_BCLAN,
      /* ANIME_DATA_BALL_02_ACTIVE */ LYTRES_INFO_INFO_BALL_02_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_02_PASSIVE */ LYTRES_INFO_INFO_BALL_02_PASSIVE_BCLAN,
      /* ANIME_DATA_BALL_03_ACTIVE */ LYTRES_INFO_INFO_BALL_03_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_03_PASSIVE */ LYTRES_INFO_INFO_BALL_03_PASSIVE_BCLAN,
      /* ANIME_DATA_BALL_04_ACTIVE */ LYTRES_INFO_INFO_BALL_04_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_04_PASSIVE */ LYTRES_INFO_INFO_BALL_04_PASSIVE_BCLAN,
      /* ANIME_DATA_BALL_05_ACTIVE */ LYTRES_INFO_INFO_BALL_05_ACTIVE_BCLAN,
      /* ANIME_DATA_BALL_05_PASSIVE */ LYTRES_INFO_INFO_BALL_05_PASSIVE_BCLAN,
    }; 



    // LAj[VƂ̐ݒ
    const Info::ShareAnimationDesc Info::SHARE_ANIME_DESC[ Info::SHARE_ANIME_NUM ] = 
    {
      /* SHARE_ANIME_BALL_IN */
      {
        ANIME_BALL_IN, 
        ANIME_DATA_DUMMY_BALL_IN,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_INFO_GROUP_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BALL_ROCK */
      {
        ANIME_BALL_ROCK, 
        ANIME_DATA_DUMMY_BALL_ROCK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_INFO_GROUP_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BALL_OUT */
      {
        ANIME_BALL_OUT, 
        ANIME_DATA_DUMMY_BALL_OUT,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_INFO_GROUP_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // {^Ƃ̐ݒ
    const Info::ButtonDesc Info::BUTTON_DESC[ Info::BUTTON_NUM ] = 
    {
      /* BUTTON_POKE0 */ 
      {
        RESULT_CHANGE,
        0,
        PANENAME_INFO_PANE_BALL_00,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_00_ACTIVE,
        ANIME_BALL_00_PASSIVE,
      },
      /* BUTTON_POKE1 */ 
      {
        RESULT_CHANGE,
        1,
        PANENAME_INFO_PANE_BALL_01,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_01_ACTIVE,
        ANIME_BALL_01_PASSIVE,
      },
      /* BUTTON_POKE2 */ 
      {
        RESULT_CHANGE,
        2,
        PANENAME_INFO_PANE_BALL_02,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_02_ACTIVE,
        ANIME_BALL_02_PASSIVE,
      },
      /* BUTTON_POKE3 */ 
      {
        RESULT_CHANGE,
        3,
        PANENAME_INFO_PANE_BALL_03,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_03_ACTIVE,
        ANIME_BALL_03_PASSIVE,
      },
      /* BUTTON_POKE4 */ 
      {
        RESULT_CHANGE,
        4,
        PANENAME_INFO_PANE_BALL_04,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_04_ACTIVE,
        ANIME_BALL_04_PASSIVE,
      },
      /* BUTTON_POKE5 */ 
      {
        RESULT_CHANGE,
        5,
        PANENAME_INFO_PANE_BALL_05,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_NULL,
        ANIME_BALL_05_ACTIVE,
        ANIME_BALL_05_PASSIVE,
      },
    };








    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param layout_work  Ώۂ̃CAEg[N
     * @param in_anime     {[hmAj
     * @param out_anime    {[ntsAj
     * @param rock_anime   {[hAj
     */
    //-------------------------------------------------------------------------------
    Info::BallIcon::BallIcon( 
        gfl::grp::g2d::LytWk* layout_work,
        Animation in_anime, Animation out_anime, Animation rock_anime ) :
      m_layout_work( layout_work ),
      m_end_state( STATE_WAIT ),
      m_now_state( STATE_WAIT ),
      m_in_anime( in_anime ),
      m_out_anime( out_anime ),
      m_rock_anime( rock_anime ) 
    { 
    }


    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    Info::BallIcon::~BallIcon()
    {
    }


    //-------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //-------------------------------------------------------------------------------
    void Info::BallIcon::Update( void )
    {
      switch( m_now_state )
      {
      case STATE_WAIT:
        if( m_end_state == STATE_ROCK ) {
          m_now_state = STATE_IN;
          app::util::StartAnimation( m_layout_work, m_in_anime );
        }
        break;

      case STATE_IN:
        if( m_layout_work->IsAnimeEnd( m_in_anime ) ) {
          m_now_state = STATE_ROCK;
          app::util::StopAnimation( m_layout_work, m_in_anime );
          app::util::StartAnimation( m_layout_work, m_rock_anime );
        }
        break;

      case STATE_ROCK:
        if( m_end_state == STATE_WAIT ) {
          m_now_state = STATE_OUT;
          app::util::StopAnimation( m_layout_work, m_rock_anime );
          app::util::StartAnimation( m_layout_work, m_out_anime );
        }
        break;

      case STATE_OUT:
        if( m_layout_work->IsAnimeEnd( m_out_anime ) ) {
          m_now_state = STATE_WAIT;
          app::util::StopAnimation( m_layout_work, m_out_anime );
        }
        break;
      } 
    }










    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //-------------------------------------------------------------------------------
    Info::Info( void ) : 
      Common( 
          HEAPID_STATUS_INFO, APP_HEAPSIZE, 
          HEAPID_STATUS_DEVICE_INFO, DEVICE_HEAPSIZE ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_result( RESULT_NONE ),
      m_change_poke_index( 0 ),
      m_now_poke_index( -1 )
    {
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateButtonManager();
      this->SetupButtonManager();
      this->SetupStaticStrings();
      this->CreateBallIcons();
    }



    /**
     * @brief CAEg[N𐶐
     */
    void Info::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_STATUS, heap );
      m_layout_resource_id = 
        layout_system->LoadLytRes( device_allocator, &arc_file, GARC_status_info_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id, 
          LYTRES_INFO_INFO_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // XV, `ŊǗ
    }


    /**
     * @brief LAj[V𐶐
     */
    void Info::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].start_animation_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].animation_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      }
    }


    /**
     * @brief {^}l[W𐶐
     */
    void Info::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIME_NULL );
    }


    /**
     * @brief {^}l[WZbgAbv
     */
    void Info::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ
      }

      // gK쓮
      m_button_manager->SetSelectType( app::tool::ButtonManager::SELECT_TYPE_TRIGGER );
    }




    /**
     * @brief ÓIZbg
     */
    void Info::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message = this->GetCommonMessage();
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_INFO_PANE_LEVEL, message, PARAM_LEVEL );
      app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_INFO_PANE_ITEM, message, PARAM_ITEM );
    }



    /**
     * @brief {[ACR𐶐
     */
    void Info::CreateBallIcons( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      for( u8 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        m_ball_icons[i] = GFL_NEW( heap ) 
          BallIcon( 
            m_layout_work, 
            static_cast<Animation>( ANIME_BALL_IN + i ),
            static_cast<Animation>( ANIME_BALL_OUT + i ),
            static_cast<Animation>( ANIME_BALL_ROCK + i ) );
      }
    }






    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    Info::~Info()
    {
      this->DeleteBallIcons();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
    }


    /**
     * @brief {[ACRj
     */
    void Info::DeleteBallIcons( void )
    {
      for( u8 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        GFL_DELETE m_ball_icons[i];
      }
    }


    /**
     * @brief {^}l[Wj
     */
    void Info::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    /**
     * @brief CAEg[Nj
     */
    void Info::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }







    //-------------------------------------------------------------------------------
    /**
     * @brief \|PύX
     * @param poke_party  \p[eB
     * @param poke_index  Ԗڂ̃|PH
     */
    //-------------------------------------------------------------------------------
    void Info::ChangePokemon( const pml::PokeParty* poke_party, u8 poke_index )
    {
      const pml::pokepara::PokemonParam* pokeparam = poke_party->GetMemberPointerConst( poke_index );
      bool fast_mode_flag = pokeparam->StartFastMode();

      this->SetupBallButtons( poke_party );
      this->SetupPokeParam( pokeparam );
      this->StartChangeAnimation( m_now_poke_index, poke_index );
      m_now_poke_index = poke_index;

      pokeparam->EndFastMode( fast_mode_flag );
    } 


    /**
     * @brief {[{^̃ZbgAbv
     */
    void Info::SetupBallButtons( const pml::PokeParty* poke_party )
    {
      for( u8 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        const pml::pokepara::PokemonParam* pokeparam = poke_party->GetMemberPointerConst( i );
        if( pokeparam->IsNull() || pokeparam->IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ) {
          m_button_manager->SetButtonPassive( i );
        }
        else {
          m_button_manager->SetButtonActive( i );
        }
      }
    }


    /**
     * @brief p[^\ZbgAbv
     */
    void Info::SetupPokeParam( const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::str::StrBuf* tempbuf = app::util::GetTempStrBuf(); 

      // jbNl[
      pokeparam->GetNickName( tempbuf );
      app::util::SetTextboxPaneString( m_layout_work, PANENAME_INFO_PANE_POKE_NAME, tempbuf );

      // 
      pml::Sex sex = pokeparam->GetSex();
      app::util::SetTextboxPaneSex( m_layout_work, PANENAME_INFO_PANE_POKE_SEX, sex ); 

      // x
      u32 level = pokeparam->GetLevel();
      app::util::SetTextboxPaneNumber( 
          m_layout_work, PANENAME_INFO_PANE_LEVEL_VALUE, level, LV_PLACE_COUNT );

      // Xe[^X
      if( pokeparam->HavePokerusJustNow() ) {
        app::util::StopAnimation( m_layout_work, ANIME_POKE_SICK );
        app::util::StopAnimation( m_layout_work, ANIME_POKE_DEAD );
        app::util::StartAnimation( m_layout_work, ANIME_POKE_POKERUS );
      }
      else if( pokeparam->IsHpZero() ) {
        app::util::StopAnimation( m_layout_work, ANIME_POKE_SICK );
        app::util::StartAnimation( m_layout_work, ANIME_POKE_DEAD );
        app::util::StopAnimation( m_layout_work, ANIME_POKE_POKERUS );
      }
      else {
        pml::pokepara::Sick sick = pokeparam->GetSick();
        app::util::StartAnimation( m_layout_work, ANIME_POKE_SICK );
        app::util::StopAnimation( m_layout_work, ANIME_POKE_DEAD );
        app::util::StopAnimation( m_layout_work, ANIME_POKE_POKERUS );
        app::util::PauseAnimation( m_layout_work, ANIME_POKE_SICK, false );
        app::util::SetAnimationFrame( m_layout_work, ANIME_POKE_SICK, sick );
      }

      // ACe
      u32 itemno = pokeparam->GetParam( pml::pokepara::PARAM_ID_item );
      app::util::SetTextboxPaneItemName( 
          m_layout_work, PANENAME_INFO_PANE_ITEM_NAME, itemno, heap );

      // AACR
      app::util::SetPaneVisibility( 
          m_layout_work, PANENAME_INFO_PANE_RARE_ICON, pokeparam->IsRare() );

      // |PXR̃ACR
      if( !pokeparam->HavePokerusJustNow() && pokeparam->HavePokerusUntilNow() ) {
        app::util::SetPaneVisible( m_layout_work, PANENAME_INFO_PANE_ANTI_POKERUS );
      }
      else {
        app::util::SetPaneInvisible( m_layout_work, PANENAME_INFO_PANE_ANTI_POKERUS );
      }

      // {bNX}[N
      u32 box_mark = pokeparam->GetParam( pml::pokepara::PARAM_ID_box_mark );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_00, ( box_mark & pml::pokepara::BOX_MARK_1 ) );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_01, ( box_mark & pml::pokepara::BOX_MARK_2 ) );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_02, ( box_mark & pml::pokepara::BOX_MARK_3 ) );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_03, ( box_mark & pml::pokepara::BOX_MARK_4 ) );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_04, ( box_mark & pml::pokepara::BOX_MARK_5 ) );
      app::util::SetPaneVisibility( m_layout_work, PANENAME_INFO_PANE_BOX_MARK_05, ( box_mark & pml::pokepara::BOX_MARK_6 ) );
    }




    /**
     * @brief ւAj[VJn
     * @param old_index  ւÕ|PCfbNX
     * @param new_index  ւ̃|PCfbNX
     */
    void Info::StartChangeAnimation( s8 old_index, s8 new_index )
    {
      if( ( 0 <= old_index ) && ( old_index < pml::PokeParty::MAX_MEMBERS ) ) {
        m_ball_icons[ old_index ]->Wait();
      }

      if( ( 0 <= new_index ) && ( new_index < pml::PokeParty::MAX_MEMBERS ) ) {
        m_ball_icons[ new_index ]->Rock();
      }
    }





    //-------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //-------------------------------------------------------------------------------
    void Info::Update( void )
    {
      m_result = RESULT_NONE;

      for( u8 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        m_ball_icons[i]->Update();
      }

      m_button_manager->Update();
      if( m_button_manager->IsButtonSelected() ) {
        Button selected_button = static_cast<Button>( m_button_manager->GetSelectedButtonId() );
        m_result = BUTTON_DESC[ selected_button ].result;
        m_change_poke_index = BUTTON_DESC[ selected_button ].poke_index;
      }

      m_layout_work->Update();
    }



    //-------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //-------------------------------------------------------------------------------
    void Info::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* frame_buffer = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, frame_buffer );
    }




  } // namespace status 
} // namespace app
