//=======================================================================================
/**
 * @file app_status_Common.h
 * @brief Xe[^Xʂ̋ʊ{NX
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#ifndef __APPSTATUSCOMMON_H__
#define __APPSTATUSCOMMON_H__
#include <gflib.h>
#include <pmlib.h>


namespace app { 
  namespace status {


    class Common
    {
      GFL_FORBID_COPY_AND_ASSIGN( Common );  // Rs[֎~


      public: 

      //-------------------------------------------------------------------------------
      // EЕt
      //-------------------------------------------------------------------------------
      /**
       * @brief gp
       */
      static void Initialize( void );

      /**
       * @brief Еt
       */
      static void Finalize( void ); 


      //-------------------------------------------------------------------------------
      // ÓIf[^̎擾
      //-------------------------------------------------------------------------------
      static gfl::heap::HeapBase* GetRootHeap( void ) { return s_root_heap; }
      static gfl::heap::HeapBase* GetRootDeviceHeap( void ) { return s_root_device_heap; }
      static gfl::grp::g2d::LytSys* GetLayoutSystem( void ) { return s_layout_system; }
      static gfl::str::MsgData* GetCommonMessage( void ) { return s_common_message; }
      static gfl::str::MsgData* GetRibbonNameMessage( void ) { return s_ribbon_name_message; }
      static gfl::str::MsgData* GetRibbonInfoMessage( void ) { return s_ribbon_info_message; }





      //-------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //-------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap_id       q[v̂hc
       * @param app_heap_size     q[ṽTCY
       * @param device_heap_id    foCXq[v̂hc
       * @param device_heap_size  foCXq[ṽTCY
       */
      Common( 
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size );

      /**
       * @brief fXgN^
       */
      virtual ~Common();




      protected:
      gfl::heap::HeapBase* GetHeap( void ) const { return m_heap; }
      gfl::heap::HeapBase* GetDeviceHeap( void ) const { return m_device_heap; }
      gfl::heap::NwAllocator* GetNwAllocator( void ) const { return m_nw_allocator; }
      gfl::heap::NwAllocator* GetNwDeviceAllocator( void ) const { return m_nw_device_allocator; }
      gfl::grp::GraphicsSystem* GetGraphicsSystem( void ) const;
      gfl::ui::DeviceManager* GetUiDeviceManager( void ) const;
      gfl::ui::Button* GetButton( void ) const;
      gfl::ui::TouchPanel* GetTouchpanel( void ) const;



      private:
      static gfl::heap::HeapBase* s_root_heap;
      static gfl::heap::HeapBase* s_root_device_heap;
      static gfl::heap::NwAllocator* s_nw_root_allocator;
      static gfl::heap::NwAllocator* s_nw_root_device_allocator;
      static gfl::grp::g3d::System* s_g3d_system;
      static gfl::grp::g2d::LytSys* s_layout_system;
      static gfl::str::MsgData* s_common_message;
      static gfl::str::MsgData* s_ribbon_name_message;
      static gfl::str::MsgData* s_ribbon_info_message;

      gfl::heap::HeapBase* m_heap;
      gfl::heap::HeapBase* m_device_heap;
      gfl::heap::NwAllocator* m_nw_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;


      static void CreateRootHeap( void );
      static void InitializeGraphicsSystem( void );
      static void CreateG3dSystem( void );
      static void CreateLayoutSystem( void );
      static void SetupFont( void );
      static void CreateMessageData( void );
      void CreateHeap( 
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size );
      void CreateNwAllocator( void );

      static void DeleteRootHeap( void );
      static void FinalizeGraphicsSystem( void );
      static void DeleteG3dSystem( void );
      static void DeleteLayoutSystem( void ); 
      static void CleanupFont( void ); 
      static void DeleteMessageData( void ); 
      void DeleteHeap( void );
      void DeleteNwAllocator( void );
    };


  } // namespace status 
} // namespace app


#endif // __APPSTATUSCOMMON_H__
