//=======================================================================================
/**
 * @file app_status_Common.cpp
 * @brief Xe[^Xʂ̋ʊ{NX
 * @author obata_toshihiro
 * @date 2011.09.11
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h> 
#include <system/main.h>
#include <message/message.gaix>


namespace app { 
  namespace status {



    gfl::heap::HeapBase* Common::s_root_heap = NULL;
    gfl::heap::HeapBase* Common::s_root_device_heap = NULL;
    gfl::heap::NwAllocator* Common::s_nw_root_allocator = NULL;
    gfl::heap::NwAllocator* Common::s_nw_root_device_allocator = NULL;
    gfl::grp::g3d::System* Common::s_g3d_system = NULL;
    gfl::grp::g2d::LytSys* Common::s_layout_system = NULL;
    gfl::str::MsgData* Common::s_common_message = NULL;
    gfl::str::MsgData* Common::s_ribbon_name_message = NULL;
    gfl::str::MsgData* Common::s_ribbon_info_message = NULL;


    //-------------------------------------------------------------------------------
    /**
     * @brief gp
     */
    //-------------------------------------------------------------------------------
    void Common::Initialize( void )
    {
      Common::CreateRootHeap();
      Common::SetupFont();
      Common::InitializeGraphicsSystem();
      Common::CreateG3dSystem();
      Common::CreateLayoutSystem();
      Common::CreateMessageData();
    }


    /**
     * @brief [gq[v𐶐
     */
    void Common::CreateRootHeap( void )
    {
      // AvP[Vq[v
      gfl::heap::HeapBase* parent_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      size_t app_heap_size = parent_heap->GetTotalAllocatableSize();
      s_root_heap = gfl::heap::Manager::CreateHeap( 
          parent_heap, HEAPID_STATUS, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      s_nw_root_allocator = GFL_NEW( s_root_heap ) gfl::heap::NwAllocator( s_root_heap );

      // foCXq[v
      gfl::heap::HeapBase* parent_device_heap = 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ); 
      size_t dev_heap_size = parent_device_heap->GetTotalAllocatableSize();
      s_root_device_heap = gfl::heap::Manager::CreateHeap( 
          parent_device_heap, HEAPID_STATUS_DEVICE, dev_heap_size, gfl::heap::HEAP_TYPE_EXP );
      s_nw_root_device_allocator = 
        GFL_NEW( s_root_device_heap ) gfl::heap::NwAllocator( s_root_device_heap );
    }


    /**
     * @brief tHgZbgAbv
     */
    void Common::SetupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Initialize( s_root_device_heap );
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    /**
     * @brief OtBbNXVXe
     */
    void Common::InitializeGraphicsSystem( void )
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gfl::grp::GraphicsSystem* graphics_system = game_manager->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( s_nw_root_device_allocator );
    }


    /**
     * @brief fRcVXe𐶐
     */
    void Common::CreateG3dSystem( void )
    {
      s_g3d_system = GFL_NEW( s_root_heap ) 
        gfl::grp::g3d::System( s_nw_root_allocator, s_nw_root_device_allocator );
    }


    /**
     * @brief CAEgVXe𐶐
     */
    void Common::CreateLayoutSystem( void )
    {
      const gfl::grp::g2d::LytSysSetUp LAYOUT_SETUP_DATA = { 16, 8 };
      s_layout_system = GFL_NEW( s_root_heap ) gfl::grp::g2d::LytSys( 
          &LAYOUT_SETUP_DATA, s_nw_root_allocator, s_nw_root_device_allocator );
    }


    /**
     * @brief bZ[Wf[^𐶐
     */
    void Common::CreateMessageData( void )
    {
      s_common_message = GFL_NEW( s_root_heap ) gfl::str::MsgData( 
          L"rom:/message.garc", GARC_message_pokemon_status_DAT, 
          s_root_heap, gfl::str::MsgData::LOAD_FULL );

      s_ribbon_name_message = GFL_NEW( s_root_heap ) gfl::str::MsgData( 
          L"rom:/message.garc", GARC_message_ribbon_DAT, 
          s_root_heap, gfl::str::MsgData::LOAD_FULL );

      s_ribbon_info_message = GFL_NEW( s_root_heap ) gfl::str::MsgData( 
          L"rom:/message.garc", GARC_message_ribbon_info_DAT, 
          s_root_heap, gfl::str::MsgData::LOAD_FULL );
    }






    //-------------------------------------------------------------------------------
    /**
     * @brief Еt
     */
    //-------------------------------------------------------------------------------
    void Common::Finalize( void )
    {
      Common::DeleteMessageData();
      Common::DeleteLayoutSystem();
      Common::DeleteG3dSystem();
      Common::FinalizeGraphicsSystem();
      Common::CleanupFont();
      Common::DeleteRootHeap();
    }


    /**
     * @brief bZ[Wf[^j
     */
    void Common::DeleteMessageData( void )
    {
      GFL_DELETE s_common_message;
      GFL_DELETE s_ribbon_name_message;
      GFL_DELETE s_ribbon_info_message;
    }


    /**
     * @brief CAEgVXej
     */
    void Common::DeleteLayoutSystem( void )
    {
      GFL_DELETE s_layout_system; 
    }


    /**
     * @brief fRcVXej
     */
    void Common::DeleteG3dSystem( void )
    {
      GFL_DELETE s_g3d_system; 
    }


    /**
     * @brief OtBbNXVXěЕt
     */
    void Common::FinalizeGraphicsSystem( void )
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gfl::grp::GraphicsSystem* graphics_system = game_manager->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }


    /**
     * @brief tHǧЕt
     */
    void Common::CleanupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Terminate();
    }


    /**
     * @brief [gq[vj
     */
    void Common::DeleteRootHeap( void )
    {
      GFL_DELETE s_nw_root_allocator;
      GFL_DELETE s_nw_root_device_allocator;
      gfl::heap::Manager::DeleteHeap( s_root_heap );
      gfl::heap::Manager::DeleteHeap( s_root_device_heap );
    }










    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param app_heap_id         q[v̂hc
     * @param app_heap_size       q[ṽTCY
     * @param device_heap_id      foCXq[v̂hc
     * @param device_heap_size    foCXq[ṽTCY
     */
    //-------------------------------------------------------------------------------
    Common::Common( 
        gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
        gfl::heap::HEAPID device_heap_id, u32 device_heap_size ) :
      m_heap( NULL ),
      m_device_heap( NULL ),
      m_nw_allocator( NULL ),
      m_nw_device_allocator( NULL )
    {
      this->CreateHeap( app_heap_id, app_heap_size, device_heap_id, device_heap_size );
      this->CreateNwAllocator();
    }


    /**
     * @brief q[v𐶐
     * @param app_heap_id         q[v̂hc
     * @param app_heap_size       q[ṽTCY
     * @param device_heap_id      foCXq[v̂hc
     * @param device_heap_size    foCXq[ṽTCY
     */
    void Common::CreateHeap( 
        gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
        gfl::heap::HEAPID device_heap_id, u32 device_heap_size )
    {
      if( !m_heap ) {
        gfl::heap::HeapBase* parent_heap = this->GetRootHeap();
        m_heap = gfl::heap::Manager::CreateHeap( 
            parent_heap, app_heap_id, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }

      if( !m_device_heap ) {
        gfl::heap::HeapBase* parent_heap = this->GetRootDeviceHeap();
        m_device_heap = gfl::heap::Manager::CreateHeap( 
            parent_heap, device_heap_id, device_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }
    }


    /**
     * @brief AP[^𐶐
     */
    void Common::CreateNwAllocator( void ) 
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::HeapBase* device_heap = this->GetDeviceHeap();

      if( !m_nw_allocator ) {
        m_nw_allocator = GFL_NEW( heap ) gfl::heap::NwAllocator( heap );
      }

      if( !m_nw_device_allocator ) {
        m_nw_device_allocator = GFL_NEW( heap ) gfl::heap::NwAllocator( device_heap );
      }
    }





    //-------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-------------------------------------------------------------------------------
    Common::~Common()
    {
      this->DeleteNwAllocator();
      this->DeleteHeap();
    }


    /**
     * @brief AP[^j
     */
    void Common::DeleteNwAllocator( void )
    {
      if( m_nw_allocator ) {
        GFL_DELETE m_nw_allocator;
        m_nw_allocator = NULL;
      }

      if( m_nw_device_allocator ) {
        GFL_DELETE m_nw_device_allocator;
        m_nw_device_allocator = NULL;
      }
    }


    /**
     * @brief q[vj
     */
    void Common::DeleteHeap( void )
    {
      if( m_heap ) {
        gfl::heap::Manager::DeleteHeap( m_heap );
        m_heap = NULL;
      }

      if( m_device_heap ) {
        gfl::heap::Manager::DeleteHeap( m_device_heap );
        m_device_heap = NULL;
      }
    }







    /**
     * @brief OtBbNXVXe擾
     */
    gfl::grp::GraphicsSystem* Common::GetGraphicsSystem( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetGraphicsSystem();
    }

    /**
     * @brief UIfoCX}l[W擾
     */
    gfl::ui::DeviceManager* Common::GetUiDeviceManager( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetUiDeviceManager();
    }

    /**
     * @brief {^擾
     */
    gfl::ui::Button* Common::GetButton( void ) const
    {
      gfl::ui::DeviceManager* device_manager = this->GetUiDeviceManager();
      return device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
    }

    /**
     * @brief ^b`pl擾
     */
    gfl::ui::TouchPanel* Common::GetTouchpanel( void ) const
    {
      gfl::ui::DeviceManager* device_manager = this->GetUiDeviceManager();
      return device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );
    }




  } // namespace status 
} // namespace app
