//========================================================================================
/**
 * @file app_status_Process.h
 * @brief |PXe[^XʃvZX
 * @author obata_toshihiro
 * @date 2011.09.10
 */
//========================================================================================
#ifndef __APP_STATUS_PROCESS_H__
#define __APP_STATUS_PROCESS_H__
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>


namespace app {
  namespace status {

    class Params;
    class TrMemo;
    class Info;
    class WazaList;
    class RibbonList;


    class Process : public gamesystem::GameProc
    {
      public:


        //--------------------------------------------------------------------------------
        // RXgN^EfXgN^
        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         */
        Process( void );

        /**
         * @brief fXgN^
         */
        virtual ~Process();



        //--------------------------------------------------------------------------------
        // O
        //--------------------------------------------------------------------------------
        struct Setting {
          pml::PokeParty* poke_party;
          u8 init_poke_index;
        };

        /**
         * @brief \ݒZbg
         */
        void SetSetting( const Setting& settings );




        //--------------------------------------------------------------------------------
        // vZXƂĂ̓
        //-------------------------------------------------------------------------------- 
        /**
         * @brief	vZX̏
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  p
         * @retval RES_FINISH    I
         */
        virtual gfl::proc::Result InitFunc( gfl::proc::Manager* proc_manager );

        /**
         * @brief vZX̍XV
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Cp
         * @retval RES_FINISH    CI
         */
        virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* proc_manager );

        /**
         * @brief vZX̕`揈
         * @param proc_manager  vZX̃}l[W
         */
        virtual void DrawFunc( gfl::proc::Manager* proc_manager );

        /**
         * @brief vZX̏I
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Ip
         * @retval RES_FINISH    II
         */
        virtual gfl::proc::Result EndFunc( gfl::proc::Manager* proc_manager );






      protected: 

        // V[PX
        enum Sequence {
          SEQ_WAZA,
          SEQ_RIBBON,
        };

        Setting m_settings;
        u8 m_now_poke_index;
        Sequence m_seq;

        Params* m_params;
        TrMemo* m_memo;
        Info* m_info;
        WazaList* m_wazalist; 
        RibbonList* m_ribbonlist; 

        gfl::proc::Result Update_WAZA( void );
        gfl::proc::Result Update_RIBBON( void );
        u8 GetPrevPokeIndex( u8 now_index ) const;
        u8 GetNextPokeIndex( u8 now_index ) const;
        void ChangePokemon( Sequence seq, u8 poke_index );
        void ChangeSequence( Sequence seq );
        const pml::pokepara::PokemonParam* GetPokeParam( u8 index ) const;
    };


  } // namespace status
} // namespace app


#endif // __APP_STATUS_PROCESS_H__
