//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PokemonShaderModel.h
 *	@brief  |PVF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.09.09
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __POKEMON_SHADER_MODEL_H__
#define __POKEMON_SHADER_MODEL_H__

// CTR_SDK

// NW4C
#include <nw/gfx.h>
#include <nw/gfx/gfx_Model.h>

// gflib
#include <gfl_Macros.h>
#include <gfl_Heap.h>

//  gflib grp
#include <grp/gfl_RenderTarget.h>

// gflib grp g3d
#include <grp/g3d/gfl_G3dModel.h>
#include <grp/g3d/gfl_G3dCamera.h>
#include <grp/g3d/gfl_G3dShadowGroup.h>

#include <math/gfl_Vec.h>

#include <base/gfl_KeyContainer.h>

namespace xy_system {

class PokemonShaderModel : public gfl::grp::g3d::Model
{
  GFL_FORBID_COPY_AND_ASSIGN(PokemonShaderModel);
  
public:  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  PokemonShaderModel(void);
  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~PokemonShaderModel();
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *
   *  @param[in]     allocator          AP[^
   *  @param[in]     device_allocator   foCX̃AP[^
   *  @param[in]     resource           \[X
   *  @param[in]     index_in_resource  \[XɂCfbNX
   *  @param[in]     description        ݒe
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*           allocator,
      gfl::heap::NwAllocator*           device_allocator,
      gfl::grp::g3d::Resource*          resource,
      s32                               index_in_resource,
      Description*                      description  = NULL
  );
  
  //-----------------------------------------------------------------------------
  /**
   * @brief J[ݒ
   * @param color
   */
  //-----------------------------------------------------------------------------
  void SetRimColor( gfl::math::VEC4 color );
  
  //-----------------------------------------------------------------------------
  /**
   * @brief sxNgݒ
   * @param vec
   */
  //-----------------------------------------------------------------------------
  void SetDirLightVec( gfl::math::VEC4 vec );
  
private:
  
  //-----------------------------------------------------------------------------
  /**
   * @brief Cg̓ݒ
   * @param param
   */
  //-----------------------------------------------------------------------------
  void SetLightPowScale( gfl::math::VEC4 param );
  
  //-------------------------------------
  ///	v_[pXbg
  //=====================================  
  class PokeShaderCallbackSlot : public nw::gfx::Model::RenderSlot
  {
    friend class PokemonShaderModel;
  public:
      virtual void Invoke(nw::gfx::Model* model, nw::gfx::ResMesh mesh, nw::gfx::RenderContext* renderContext);
      
      enum{
        LightPowScale = 0,
        DirLightVec,
        RimColor,
      };

  private:
    PokeShaderCallbackSlot() : nw::gfx::Model::RenderSlot(NULL)
    {
      m_DirLightVec.Set(0.0f, 0.0f, 1.0f, 0.0f);
    }
    
    gfl::math::VEC4             m_LightPowScale;
    gfl::math::VEC4             m_DirLightVec;    
    gfl::math::VEC4             m_RimColor;
  };
  
  PokeShaderCallbackSlot                m_PokeShaderCallbackSlot;
  

};
  


}  // namespace xy_system

#endif