//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PokemonShaderModel.cpp
 *	@brief  |PVF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.09.09
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "PokemonShaderModel.h"

namespace xy_system {

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------  
PokemonShaderModel::PokemonShaderModel(void) : Model()
{
  
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
PokemonShaderModel::~PokemonShaderModel()
{
  this->GetNwModel()->PreRenderSignal().Disconnect( &this->m_PokeShaderCallbackSlot );
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void PokemonShaderModel::Create(
    gfl::heap::NwAllocator*           allocator,
    gfl::heap::NwAllocator*           device_allocator,
    gfl::grp::g3d::Resource*          resource,
    s32                               index_in_resource,
    Description*                      description
)
{
  Model::Create( allocator, device_allocator, resource, index_in_resource, description );
  
  this->GetNwModel()->PreRenderSignal().Connect( &this->m_PokeShaderCallbackSlot );
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void PokemonShaderModel::SetRimColor( gfl::math::VEC4 color )
{
  m_PokeShaderCallbackSlot.m_RimColor = color;
  
  for( int i = 0; i < this->GetNwModel()->GetMaterialCount(); ++i )
  {
    nw::gfx::Material               *material = this->GetNwModel()->GetMaterial( i );
    nw::gfx::ResMaterial            res_material = material->GetTextureMapperResMaterial();
    nw::gfx::ResTextureCoordinator  res_tex_coord;
    nw::gfx::ResMaterialColor       res_color = res_material.GetMaterialColor();

    res_color.SetConstant1( color.x, color.y, color.z, 0.0f );
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void PokemonShaderModel::SetLightPowScale( gfl::math::VEC4 param )
{
  m_PokeShaderCallbackSlot.m_LightPowScale = param;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void PokemonShaderModel::SetDirLightVec( gfl::math::VEC4 vec )
{
  m_PokeShaderCallbackSlot.m_DirLightVec = vec;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void PokemonShaderModel::PokeShaderCallbackSlot::Invoke(nw::gfx::Model* model, nw::gfx::ResMesh mesh, nw::gfx::RenderContext* renderContext)
{
  return;
  
  nw::gfx::Material                     *setting_material;
  const s32                             index = mesh.GetMaterialIndex();
  nw::gfx::Material                     *target_material = model->GetMaterial( index );
  
#if GFL_DEBUG  
  if ( target_material == NULL )
  {
    GFL_PRINT("[%s] doesn't have materials.\n", model->GetName() );
    GFL_ASSERT( target_material );
  }
#endif
  nw::gfx::ResMaterial                      target_res_material = target_material->GetTextureMapperResMaterial();
  
  for ( int i = 0; i < target_res_material.GetShaderParametersCount(); ++i  )
  {
    nw::gfx::res::ResShaderParameter      param = target_res_material.GetShaderParameters( i );
    
    switch( param.GetSymbolIndex() ){
    case LightPowScale:
      //param.GetParameter().SetValue( m_LightPowScale );
      break;
    case DirLightVec:
      param.GetParameter().SetValue( m_DirLightVec );
      break;
    case RimColor:
      param.GetParameter().SetValue( m_RimColor );
      break;
    default:
      break;
    }
    
    
    //const char* name = param.GetName();
    //ISHIGURO_PRINT("[%d]%s\n", symbolIndex, name );
  }
 
#if 0  
  nw::gfx::ShaderProgram                    *pShader = renderContext->GetShaderProgram();
  nw::gfx::res::ResShaderParameterValue     value;
  
  value.SetUniformType( nw::gfx::res::ResShaderParameterValue::TYPE_FLOAT4 );
  value.SetValue( m_RimColor );
  
  pShader->SetUserVertexUniform( 10, value );
#endif
}

}  // namespace xy_system

