//============================================================================================
/**
 * @file		sv_kawaigari.cpp
 * @brief		Z[uf[^F킢
 * @author	k.ohno
 * @date		11.09.01
 * class		savedata::Kawaigari::
 */
//============================================================================================
#include "savedata/sv_kawaigari.h"

GFL_NAMESPACE_BEGIN(savedata)

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
Kawaigari::Kawaigari(gfl::heap::HeapBase* heap)
{

//  pBackup = GFL_NEW( gfl::fs::BackupData(heap, &x) );
//  mpAll = pBackup->GetBuffer();
//  GFL_ASSERT_STOP(pBackup);

}


Kawaigari::~Kawaigari()
{
 // GFL_DELETE pBackup;

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		킢َ̂qꂩ瓾  (g͕ωȂ)
 * @param		index   Ă鏇
 * @return	ACeۑꏊ
 */
//--------------------------------------------------------------------------------------------
u8 Kawaigari::GetCake( int index )
{
  GFL_ASSERT(index < TREATS_NUM_MAX);
  if(index < TREATS_NUM_MAX){
    return mpAll->love.cake[index];
  }
  return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		킢َ̂qɐݒ肷
 * @param		index	 Ă鏇
 * @param		cakeno َqԍ
 */
//--------------------------------------------------------------------------------------------
void Kawaigari::SetCake( const int index, const u8 cakeno )
{
  GFL_ASSERT(index < TREATS_NUM_MAX);
  if(index < TREATS_NUM_MAX){
    mpAll->love.cake[index] = cakeno;
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		킢َ̂q̍Ōɒǉ
 * @param		cakeno َqԍ
 */
//--------------------------------------------------------------------------------------------
void Kawaigari::AddCake( const u8 cakeno )
{
  int i;
  
  for(i=0;i<TREATS_NUM_MAX;i++){
    if(mpAll->love.cake[i] == 0){
      mpAll->love.cake[i] = cakeno;
    }
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		؂̎Q[̃NAxݒ
 * @param		level	 x
 */
//--------------------------------------------------------------------------------------------
void Kawaigari::SetNutsGameLevel( const int level )
{
  mpAll->nuts.nutsGameLevel = level;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		؂̎Q[̃NAx擾
 * @param		cakeno َqԍ
 */
//--------------------------------------------------------------------------------------------
int Kawaigari::GetNutsGameLevel( void )
{
  return mpAll->nuts.nutsGameLevel;
}


GFL_NAMESPACE_END(savedata)


