#ifndef __SV_KWAIGARI_H__
#define __SV_KWAIGARI_H__
//============================================================================================
/**
 * @file		sv_kawaigari.h
 * @brief		Z[uf[^F킢̃|Pp[^ȊOłf[^
 * @author	k.ohno
 * @date		11.09.01
 * class		savedata::Kawaigari::
 */
//============================================================================================
#pragma	once

#include <gflib.h>


GFL_NAMESPACE_BEGIN(savedata)

class Kawaigari {
public:

  static const int TREATS_NUM_MAX = 100;  //킢؂̎

  struct MINIGAME_NUTS_ST{
    //@todo ~jQ[ŕKvɂȂp[^
    u8 nutsGameLevel;
    u8 dummy1;
    u8 dummy2;
    u8 dummy3;
	};

  struct KAWAIGARI_ST{
    //@todo 킢ɕKvȂ̂߂
    u8 cake[TREATS_NUM_MAX];  // َq̒g
  };

private:

  struct ALL_ST{
    KAWAIGARI_ST love;
    MINIGAME_NUTS_ST nuts;
  };

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 */
	//--------------------------------------------------------------------------------------------
	Kawaigari(gfl::heap::HeapBase* heap);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
  ~Kawaigari(void);

private:

  gfl::fs::BackupData* pBackup;
  ALL_ST* mpAll;

public:

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		킢َ̂qꂩ瓾  (g͕ωȂ)
	 * @param		index   Ă鏇
	 * @return	ACeۑꏊ
	 */
	//--------------------------------------------------------------------------------------------
  u8 GetCake( int index );
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		킢َ̂qɐݒ肷
	 * @param		index	 Ă鏇
	 * @param		cakeno َqԍ
	 */
	//--------------------------------------------------------------------------------------------
	void SetCake( const int index, const u8 cakeno );
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		킢َ̂q̍Ōɒǉ
	 * @param		cakeno َqԍ
	 */
	//--------------------------------------------------------------------------------------------
	void AddCake( const u8 cakeno );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		؂̎Q[̃NAxݒ
	 * @param		level	 x
	 */
	//--------------------------------------------------------------------------------------------
	void SetNutsGameLevel( const int level );
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		؂̎Q[̃NAx擾
	 * @param		cakeno َqԍ
	 */
	//--------------------------------------------------------------------------------------------
	int GetNutsGameLevel( void );

};

GFL_NAMESPACE_END(savedata)


#endif// __SV_KWAIGARI_H__
