//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		GameTime.cpp
 *	@brief  Q[ԃf[^
 *	@author	tomoya takahahi
 *	@date		2011.09.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "savedata/GameTime.h"


namespace savedata
{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------


  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[Ԃ̏
   */
  //-----------------------------------------------------------------------------
  void GameTime::Initialize( void* p_work )
  {
    Data* p_data = static_cast<Data*>(p_work);

    
    gfl::std::DateTime date;                          // ̓擾
    gfl::std::DateTime::GetNow( &date );

    p_data->use_flag = DATA_ID;                       // IWiID𖄂ߍށB
    SetDate( p_data, &date );
    SetDay( p_data, static_cast<u32>(date.GetDateTimeToDay()) );
    p_data->start_sec = date.GetDateTimeToSecond();   // Q[Jn
    p_data->clear_sec = 0;
    p_data->penalty_time = 0;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  f[^TCY̎擾
   */
  //-----------------------------------------------------------------------------
  size_t GameTime::GetDataSize( void )
  {
    return sizeof(Data);
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  @\Ă邩̃tO
   *
   *	@retval true    @\ĂB
   *	@retval false   @\ĂȂB
   */
  //-----------------------------------------------------------------------------
  bool GameTime::IsUseFlag( const Data* cp_data )
  {
    if( cp_data->use_flag == DATA_ID ){
      return true;
    }
    return false;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ̓ۑ
   *
   *	@param	p_date      ۑ̈
   *	@param  cp_dateTime ̓
   */
  //-----------------------------------------------------------------------------
  void GameTime::SetDate( Data* p_data, const gfl::std::DateTime* cp_dateTime )
  {
    p_data->sv_date.year  = cp_dateTime->GetYear();
    p_data->sv_date.month = cp_dateTime->GetMonth();
    p_data->sv_date.day   = cp_dateTime->GetDay();
    p_data->sv_date.hour  = cp_dateTime->GetHour();
    p_data->sv_date.minute  = cp_dateTime->GetMinute();
    p_data->sv_date.second  = cp_dateTime->GetSecond();
    p_data->sv_date.milliSecond = cp_dateTime->GetMilliSecond();
  }

  
  //----------------------------------------------------------------------------
  /**
   *	@brief  ̎擾
   *
   *	@param	cp_date    Z[u
   *	@param  p_dateTime  i[
   */
  //-----------------------------------------------------------------------------
  void GameTime::GetDate( const Data* cp_data, gfl::std::DateTime* p_dateTime )
  {
    gfl::std::DateTime date( cp_data->sv_date.year, 
        cp_data->sv_date.month,
        cp_data->sv_date.day,
        cp_data->sv_date.hour,
        cp_data->sv_date.minute,
        cp_data->sv_date.second,
        cp_data->sv_date.milliSecond );
    gfl::std::DateTime::Copy( &date, p_dateTime );
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[ԁij@Pʂ̐ݒ
   *
   *	@param u32 Q[
   */
  //-----------------------------------------------------------------------------
  void GameTime::SetDay( Data* p_data, u32 day )
  {
    p_data->sv_day = day;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[ԁij@Pʂ̃CxgXVɗp擾
   *
   *	@return u32 Q[
   */
  //-----------------------------------------------------------------------------
  u32 GameTime::GetDay( const Data* cp_data )
  {
    return cp_data->sv_day;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[JnԂ̎擾
   */
  //-----------------------------------------------------------------------------
  s64 GameTime::GetStartSec( const Data* cp_data )
  {
    return cp_data->start_sec;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[NAԂ̐ݒ
   */
  //-----------------------------------------------------------------------------
  void GameTime::SetClearSec( Data* p_data, s64 clear_sec )
  {
    p_data->clear_sec = clear_sec;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[NAԂ̐ݒ
   */
  //-----------------------------------------------------------------------------
  s64 GameTime::GetClearSec( const Data* cp_data )
  {
    return cp_data->clear_sec;
  }
  

  //----------------------------------------------------------------------------
  /**
   *	@brief  yieB[h`FbN
   *
   *	@param	cp_data f[^
   *
   *	@retval true  yieB[h
   *	@retval false Ȃ
   */
  //-----------------------------------------------------------------------------
  bool GameTime::IsPenaltyMode( const Data* cp_data )
  {
    if( cp_data->penalty_time != 0 ){
      return true;
    }
    return false;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  yieBԂ̐ݒ
   *
   *	@param	p_data f[^
   */
  //-----------------------------------------------------------------------------
  void GameTime::SetPenaltyTime( Data* p_data )
  {
    //yieBԂZbg
    p_data->penalty_time = 60 * 24;	//24

    //Ԍo߂ɂ
    gfl::std::DateTime date;
    gfl::std::DateTime::GetNow(&date);

    //ݒ
    SetDate( p_data, &date );
    p_data->sv_day = static_cast<u32>(date.GetDateTimeToDay());
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  yieBԁ@JEg_E
   *
   *	@param	p_data        f[^
   *	@param	diff_minute   oߕ
   */
  //-----------------------------------------------------------------------------
  void GameTime::CountDownPenaltyTime( Data* p_data, int diff_minute )
  {
    //Z[uf[^ɃS~Ăꍇ̑΍
    if (p_data->penalty_time > 24 * 60) {
      p_data->penalty_time = 24 * 60;
    }

    if (p_data->penalty_time < diff_minute) {
      p_data->penalty_time = 0;
    } else {
      p_data->penalty_time -= diff_minute;
    }
  }


} // namespace savedata
