//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		EvTime.cpp
 *	@brief  Q[Ԑ֘A
 *  @author	tamada
 *  @date	2006.02.03
 *  @date 2011.09.11    takahashi tomoya ڐA
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "EvTime.h"

namespace field{

#if PM_DEBUG
#define DEBUG_FIELD_EVTIME_ON (1)

#if DEBUG_FIELD_EVTIME_ON

  static void DEBUG_EVTIME_DEBUG_PRINT( const savedata::GameTime::Data* cp_gtime, const gfl::std::DateTime* cp_now )
  {

    if( cp_gtime ){
      gfl::std::DateTime date;
      savedata::GameTime::GetDate( cp_gtime, &date );
      GFL_PRINT( "SaveTime %d/%d/%d  %02d:%02d:%02d\n", 
          date.GetYear(), 
          date.GetMonth(), 
          date.GetDay(), 
          date.GetHour(), 
          date.GetMinute(), 
          date.GetSecond() );
    }

    if( cp_now ){
      GFL_PRINT( "NowTime %d/%d/%d  %02d:%02d:%02d\n", 
          cp_now->GetYear(), 
          cp_now->GetMonth(), 
          cp_now->GetDay(), 
          cp_now->GetHour(), 
          cp_now->GetMinute(), 
          cp_now->GetSecond() );
    }
    
  }
  
#endif

#define DEBUG_EVTIME_DEBUG_PRINT(...) ((void)0)

#endif
  
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  //----------------------------------------------------------------------------
  /**
   *	@brief  CxgԍXV
   */
  //-----------------------------------------------------------------------------
  void EvTime::Update(gamesystem::GameData * gdata)
  {
    gfl::std::DateTime date;
    savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    s32 diff_day, diff_minute;


    if( !savedata::GameTime::IsUseFlag(p_gtime) ){
      // sȃZ[uf[^ԂȂ̂ŁAXVȂB
      return ;
    }

    // ̎Ԏ擾
    gfl::std::DateTime::GetNow( &date );
    
    // XV
    if( changeTimeCalc( p_gtime, &date, &diff_day, &diff_minute ) ){
      // Ԍo߂Ɉُ킪ꍇ̓X[
      return ;
    }

    if( (diff_minute == 0) && (diff_day != 0) ){
      GFL_ASSERT_MSG( 0, "iłȂ̂ɓi񂾁B" );
      return ;
    }

    if( diff_minute ){
      // yieBԌvZ
      savedata::GameTime::CountDownPenaltyTime( p_gtime, diff_minute );
      // XV̏
      UpdateMinuteEvent( gdata, diff_minute, &date );
    }
    
    if( diff_day ){
      // ɂXṼCxg
      UpdateDayEvent( gdata, diff_day );
    }
    
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[f[^A݂̎Ԃ擾B
   */
  //-----------------------------------------------------------------------------
  void EvTime::GetDateTime( const gamesystem::GameData * gdata, gfl::std::DateTime* datetime )
  {
    const savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    savedata::GameTime::GetDate( p_gtime, datetime );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  N̎擾
   */
  //-----------------------------------------------------------------------------
  s32 EvTime::GetYear( const gamesystem::GameData * gdata )
  {
    gfl::std::DateTime datetime;
    GetDateTime( gdata, &datetime );
    return datetime.GetYear();
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  ̎擾
   */
  //-----------------------------------------------------------------------------
  s32 EvTime::GetHour( const gamesystem::GameData * gdata )
  {
    gfl::std::DateTime datetime;
    GetDateTime( gdata, &datetime );
    return datetime.GetHour();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ̎擾
   */
  //-----------------------------------------------------------------------------
  s32 EvTime::GetMinute( const gamesystem::GameData * gdata )
  {
    gfl::std::DateTime datetime;
    GetDateTime( gdata, &datetime );
    return datetime.GetMinute();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  b̎擾
   */
  //-----------------------------------------------------------------------------
  s32 EvTime::GetSecond( const gamesystem::GameData * gdata )
  {
    gfl::std::DateTime datetime;
    GetDateTime( gdata, &datetime );
    return datetime.GetMinute();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ][Ԃ擾
   */
  //-----------------------------------------------------------------------------
  gamesystem::TimeZone::Zone EvTime::GetTimeZone(const gamesystem::GameData * gdata)
  {
    const savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    gfl::std::DateTime datetime;
    savedata::GameTime::GetDate( p_gtime, &datetime );

    return gamesystem::TimeZone::ConvertHourToTimeZone( datetime.GetHour() );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[JnԂ̎擾
   *
   *	@param	gdata   Q[f[^
   *	@param	date  Jnԉ\
   */
  //-----------------------------------------------------------------------------
  void EvTime::GetGameStartDateTime(const gamesystem::GameData * gdata, gfl::std::DateTime * date)
  {
    const savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    date->SetDateTimeToSecond( savedata::GameTime::GetStartSec( p_gtime ) );
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[NAԂ̎擾
   *
   *	@param	gdata   Q[f[^
   *	@param	date  NAԉ\
   */
  //-----------------------------------------------------------------------------
  void EvTime::GetGameClearDateTime(const gamesystem::GameData * gdata, gfl::std::DateTime * date)
  {
    const savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    date->SetDateTimeToSecond( savedata::GameTime::GetClearSec( p_gtime ) );
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  Q[NAԂ̐ݒ
   */
  //-----------------------------------------------------------------------------
  void EvTime::SetGameClearDateTime(gamesystem::GameData * gdata)
  {
    savedata::GameTime::Data* p_gtime = gdata->GetGameTime();
    gfl::std::DateTime date;
    gfl::std::DateTime::GetNow( &date );
    savedata::GameTime::SetClearSec( p_gtime, date.GetDateTimeToSecond() );
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  ɂXVCxg
   *
   *	@param	* gdata   Q[f[^
   *	@param	diff_days ςɂ
   */
  //-----------------------------------------------------------------------------
  void EvTime::UpdateDayEvent(gamesystem::GameData * gdata, s32 diff_days)
  {
    bool is_penalty = savedata::GameTime::IsPenaltyMode(gdata->GetGameTime());

    
    //L̂悤ȊŎԊ֘ACxgXVǉ
    //
    //TVData_Update(gdata, diff_days);
    //ZukanHyouka_Update
    //c

    
    if(!is_penalty){  //yieB^CłȂƂ
    }
#if 0
    SAVE_CONTROL_WORK* save = GAMEDATA_GetSaveControlWork( (GAMEDATA*)gdata );


    //1ɃNAtO
    EVENTWORK_ClearTimeFlags( GAMEDATA_GetEventWork( gdata ) );
  //  TimeEventFlagClear(gdata);

    // ̎O[vXV
  //  RandomGroup_Update(SaveData_GetRandomGroup(gdata->savedata), diff_days);

    //GJEg֘A_̎XV
    EncDataSave_UpdateGenerate( save );

    //|PX̌o߂
    {
      POKEPARTY *ppt;

      ppt = GAMEDATA_GetMyPokemon( gdata );
      POKERUS_DecCounter( ppt, diff_days );
    }

    // R[hf[^11XV
    RECORD_1day_Update( GAMEDATA_GetRecordPtr(gdata) );

    // WIlbg11XV
    WIFIHISTORY_Update(SaveData_GetWifiHistory(save));

    //|PNW
    {
  //    SysWorkUpdatePokeLot(gdata->savedata, diff_days);
    }

    // WFBClAACe
    {
      // HEAPID_PROC@e|ƂĎgp
      FIELD_WFBC_CORE_CalcOneDataStart( gdata, diff_days, HEAPID_PROC );
    }

    //WIFIʐMf[^̍XV
  //  WIFIHISTORY_Update(SaveData_GetWifiHistory(gdata->savedata));

    //[_[F{̂ႢlvɈړ
    QuestionnaireWork_DateChangeUpdate( SaveData_GetQuestionnaire(save) );

    //tB[O`FbNFPP`FbN
    IRC_COMPATIBLE_SV_ClearDayFlag( IRC_COMPATIBLE_SV_GetSavedata(save) );

#endif
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  XVCxg
   *
   *	@param	gdata         Q[f[^
   *	@param	diff_minute   ς
   *	@param	now           ̎
   */
  //-----------------------------------------------------------------------------
  void EvTime::UpdateMinuteEvent(gamesystem::GameData * gdata, s32 diff_minute, const gfl::std::DateTime * now)
  {


    // BWł́Aȉ̂悤ȍƂĂB
#if 0
    //ɂȂ(o߂)ȂΕς莝VFC~̃tH߂
    {
      POKEPARTY *ppt;
      int season;
      SAVE_CONTROL_WORK* sv = GAMEDATA_GetSaveControlWork(gdata);
      ppt = SaveData_GetTemotiPokemon(sv);
      season = GAMEDATA_GetSeasonID(gdata);
      SHEIMI_NFORM_ChangeNormal_TimeUpdate(gdata, ppt, diff_minute, now, season);
    }  

    // df̃`sIj[X\c莞ԂfNg
    {
      SAVE_CONTROL_WORK* sv = GAMEDATA_GetSaveControlWork(gdata);
      MISC* misc = SaveData_GetMisc( sv );
      MISC_DecChampNewsMinutes( misc, diff_minute );
    }
#endif

  }

  //------------------------------------------------------------------
  /**
   * @brief oߎԂ̎Zo
   * @param tm            ԌoߊǗ[N
   * @param now_date      ݂̓tE
   * @param diff_day      ߋ猻݂ւ̌oߎԁiPʁj
   * @param diff_minute   ߋ猻݂ւ̌oߎԁiPʁj
   * @return  BOOL  擾ꂽǂiTRUE=AFALSE=ُ͈Ȃ̂ōXVsȂj
   *
   * @todo  now_time̕bOɐ؂̂ĂĉZ邱ƂRTCƎԍXV̌덷
   * ȊOPbɂ邱Ƃ\iǌ؎ԂȂ̂łȂj
   */
  //------------------------------------------------------------------
  bool EvTime::changeTimeCalc( savedata::GameTime::Data* tm, const gfl::std::DateTime * now_date, s32 * diff_day, s32 * diff_minute )
  {
    gfl::std::DateTime sv_date;
    savedata::GameTime::GetDate( tm, &sv_date );
    s64  sv_sec = sv_date.GetDateTimeToSecond();
    u32  sv_day = savedata::GameTime::GetDay( tm );
    s64 now_sec = now_date->GetDateTimeToSecond();
    s32 now_day = now_date->GetDateTimeToDay();
    s32 diff;

    *diff_day = 0;
    *diff_minute = 0;

    if ( now_sec < sv_sec ) {
      //݁@@ߋ@c肦Ȃ͂
      //ݎԂZbg邾Ŗ߂
      DEBUG_EVTIME_DEBUG_PRINT( tm, now_date );
      TOMOYA_PRINT(" Reverse Time!!\n" );
      savedata::GameTime::SetDate( tm, now_date );
      savedata::GameTime::SetDay( tm, now_day );
      return false;
    }

    diff = ( now_sec - sv_sec ) / 60;
    if (diff > 0) {
      //̍XVꍇ
      *diff_minute = diff;
      DEBUG_EVTIME_DEBUG_PRINT( tm, now_date );
      TOMOYA_PRINT(" Update Minute %d\n", *diff_minute );
      savedata::GameTime::SetDate( tm, now_date );

      //̍XVAt̍XV`FbNs
      if ( now_day - sv_day > 0 )
      {
        *diff_day = now_day - sv_day;
        savedata::GameTime::SetDay( tm, now_day );
        TOMOYA_PRINT(" Update Day %d\n", *diff_day );
      }
    }
    return true;
  }
  

} // namespace field
