//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		EventTrainerEye.cpp
 *	@brief  g[i[@GJEg
 *	@author	tomoya takahashi
 *	@date		2011.09.03
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "EventTrainerEye.h"


namespace field{


#if PM_DEBUG

  static const u32 sc_DEBUG_TREYE_CHECK_BUF_WIDHT   = 24;
  static const u32 sc_DEBUG_TREYE_CHECK_BUF_HEIGHT  = 24;
  static const u32 sc_DEBUG_TREYE_CHECK_BUF_HW    = sc_DEBUG_TREYE_CHECK_BUF_WIDHT/2;
  static const u32 sc_DEBUG_TREYE_CHECK_BUF_HH    = sc_DEBUG_TREYE_CHECK_BUF_HEIGHT/2;
  static u32 DEBUG_TrainerEyeCheckBuffer[ sc_DEBUG_TREYE_CHECK_BUF_WIDHT * sc_DEBUG_TREYE_CHECK_BUF_HEIGHT ];
  
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------


  //----------------------------------------------------------------------------
  /**
   *	@brief  GJEg`FbN
   *
   *	@param	p_fieldmap    tB[h}bv
   *
   *	@retval GJEgogCxg
   *	@retval NULL  GJEgȂB
   *	
   */
  //-----------------------------------------------------------------------------
  EventTrainerEye* EventTrainerEye::CheckTrainerEye( const Fieldmap* cp_fieldmap )
  {
    // Kȃf1̌B
    mmodel::MoveModel* p_model = cp_fieldmap->GetFieldPlayer()->GetModel();
    
    // ͈̓`FbN
    for( u32 type=0; type<ENCOUNT_WAY_MAX; ++type ){
    
#if PM_DEBUG
      for( u32 i=0; i<sc_DEBUG_TREYE_CHECK_BUF_WIDHT * sc_DEBUG_TREYE_CHECK_BUF_HEIGHT; ++i ){

        DEBUG_TrainerEyeCheckBuffer[i] = 0;
      }
#endif
      gfl::math::VEC3 pos(-10, 0, -10);
      CheckWay( p_model, &pos, type );
#if PM_DEBUG
      GFL_PRINT( "\ntype:%d\n", type );
      for( u32 i=0; i<sc_DEBUG_TREYE_CHECK_BUF_HEIGHT; ++i ){

        for( u32 j=0; j<sc_DEBUG_TREYE_CHECK_BUF_WIDHT; ++j ){
          
          GFL_PRINT( "%d ", DEBUG_TrainerEyeCheckBuffer[(i * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + j] );
        }
        GFL_PRINT("\n");
      }
#endif
    }
      
    return NULL;
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  GJEg`FbN
   *
   *	@param	cp_model    ff[^
   *	@param  cp_pos      ʒu
   *	@param  way         
   *
   *	@retval true    GJEg
   *	@retval false   qbgȂ
   */
  //-----------------------------------------------------------------------------
  bool EventTrainerEye::CheckWay( const mmodel::MoveModel* cp_model, const gfl::math::VEC3* cp_pos, u32 way )
  {
    static const s32 sc_WayX[ ENCOUNT_WAY_MAX ] = {
      0, 0, -1, 1,
      -1, 1, -1, 1,
      -1, 1, -2, 2,
      -2, 2, -1, 1, 
    };
    static const s32 sc_WayZ[ ENCOUNT_WAY_MAX ] = {
      -1, 1,  0, 0,
      -1, -1, 1, 1,
      -2, -2, -1, -1,
      1,  1, 2, 2, 
    };
    // ꂼ̊֐Ń`FbN
    switch( way ){
    case ENCOUNT_WAY_U:          // @k
    case ENCOUNT_WAY_D:          // @
    case ENCOUNT_WAY_L:          // @
    case ENCOUNT_WAY_R:          // E@
      return Check4Way( cp_model, cp_pos, sc_WayX[way], sc_WayZ[way] );

    case ENCOUNT_WAY_UL:         // k
    case ENCOUNT_WAY_UR:         // k
    case ENCOUNT_WAY_DL:         // 쐼
    case ENCOUNT_WAY_DR:         // 쓌
      return Check8Way( cp_model, cp_pos, sc_WayX[way], sc_WayZ[way] );

    case ENCOUNT_WAY_UUL:         // kk
    case ENCOUNT_WAY_UUR:         // kk
    case ENCOUNT_WAY_LUL:         // k
    case ENCOUNT_WAY_RUR:         // k
    case ENCOUNT_WAY_LDL:         // 쐼
    case ENCOUNT_WAY_RDR:         // 쓌
    case ENCOUNT_WAY_DDL:         // 쐼
    case ENCOUNT_WAY_DDR:         // 쓌
      return Check16Way( cp_model, cp_pos, sc_WayX[way], sc_WayZ[way] );
    
    default:
      GFL_ASSERT(0); 
      break;
    }
    
    return false;
  }
  


  //-----------------------------------------------------------------------------
  /**
   *    GJEg`FbNp֐
   */
  //-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  4@GJEg`FbN ikj
   *
   *	@param	cp_model    ff[^
   *	@param	gx          `FbN@ObhX
   *	@param	gz          `FbN@ObhZ
   *	@param  way_x       `FbNX
   *	@param  way_z       `FbNZ
   *
   *	@retval true    GJEg
   *	@retval false   qbgȂ
   */
  //-----------------------------------------------------------------------------
  bool EventTrainerEye::Check4Way( const mmodel::MoveModel* cp_model, const gfl::math::VEC3* cp_pos, s32 way_x, s32 way_z )
  {
    s16 mgx;
    s16 mgz;
    s16 cgx;
    s16 cgz;
    f32 diff_y;
    u32 range;


    // YW̍`FbN
    diff_y = cp_pos->y - cp_model->GetVectorPosY();
    if(  gfl::math::Abs(diff_y) >= mmodel::H_GRID_FELLOW_SIZE ){
#if PM_DEBUG
#else
      return false;
#endif
      
    }
    
    // f̃ObhW擾
    mgx = cp_model->GetGridPosX(); 
    mgz = cp_model->GetGridPosZ(); 

    // `FbNObhW擾
    cgx = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->x) );
    cgz = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->z) );

    // ff[^烌W擾
    range = TEST_RANGE;

#if PM_DEBUG
    DEBUG_TrainerEyeCheckBuffer[ (sc_DEBUG_TREYE_CHECK_BUF_HH * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + sc_DEBUG_TREYE_CHECK_BUF_HW ] = 1;

    DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (way_z * (range))) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (way_x * range)) ] = 2;
#endif
    

    // cǂ̃`FbNH
    if( way_x != 0 ){
      cgx -= mgx;

      if( (cgx != 0) && 
          (((way_x > 0) && (cgx <= (way_x * range))) || ((way_x < 0) && (cgx >= (way_x * range)))) ){
        return true; 
      }
    }
    else if( way_z != 0 ){
      cgz -= mgz;

      if( (cgz != 0) && 
          (((way_z > 0) && (cgz <= (way_z * range))) || ((way_z < 0) && (cgz >= (way_z * range)))) ){
        return true; 
      }
    }

    return false;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief@8^Cv@GJEg`FbN ikA쓌A쐼Akj
   *
   *	@param	cp_model    ff[^
   *	@param	gx          `FbNObhX
   *	@param	gz          `FbNObhZ
   *	@param  way_x       `FbNX
   *	@param  way_z       `FbNZ
   *
   *	@retval true    GJEg
   *	@retval false   qbgȂ
   */
  //-----------------------------------------------------------------------------
  bool EventTrainerEye::Check8Way( const mmodel::MoveModel* cp_model, const gfl::math::VEC3* cp_pos, s32 way_x, s32 way_z )
  {
    s16 mgx;
    s16 mgz;
    s16 cgx;
    s16 cgz;
    f32 diff_y;
    u32 range;


    // YW̍`FbN
    diff_y = cp_pos->y - cp_model->GetVectorPosY();
    if(  gfl::math::Abs(diff_y) >= mmodel::H_GRID_FELLOW_SIZE ){
#if PM_DEBUG
#else
      return false;
#endif
    }
    
    // f̃ObhW擾
    mgx = cp_model->GetGridPosX(); 
    mgz = cp_model->GetGridPosZ(); 

    // `FbNObhW擾
    cgx = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->x) );
    cgz = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->z) );

    // ff[^烌W擾
    range = TEST_RANGE - 1;

    // range - 1  ͈͂ɂ邩`FbNB
    if( ((way_x < 0) && ((mgx - cgx) >= range)) ||
        ((way_x > 0) && ((mgx - cgx) <= -range)) ){
#if PM_DEBUG
#else
      return false;
#endif
    }
    if( ((way_z < 0) && ((mgz - cgz) >= range)) ||
        ((way_z > 0) && ((mgz - cgz) <= -range)) ){
#if PM_DEBUG
#else
      return false;
#endif
    }

#if PM_DEBUG
    DEBUG_TrainerEyeCheckBuffer[ (sc_DEBUG_TREYE_CHECK_BUF_HH * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + sc_DEBUG_TREYE_CHECK_BUF_HW ] = 1;
#endif


    // ΂ߕɃ`FbNĂB
    for( u32 i=0; i<range; ++i ){

      // x@@ꏊ@Rӏ`FbN
      if( ((mgx + way_x) == cgx) && (mgz == cgz) ){
        return true;
      }

      if( ((mgz + way_z) == cgz) && (mgx == cgx) ){
        return true;
      }

      if( ((mgx + way_x) == cgx) && ((mgz + way_z) == cgz) ){
        return true;
      }

#if PM_DEBUG
      {
        s32 debug_x = (way_x * i);
        s32 debug_z = (way_z * i);
        
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + debug_z) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x + way_x)) ] = 2;
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z + way_z)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x)) ] = 2;
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z + way_z)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x + way_x)) ] = 2;
      }
#endif

      mgx += way_x;
      mgz += way_z;
    }

    return false;
  }
  

  //----------------------------------------------------------------------------
  /**
   *	@brief@16^Cv@GJEg`FbN ikkAkA쓌A쓌A쐼A쐼AkAkkj
   *
   *	@param	cp_model    ff[^
   *	@param	gx          `FbNObhX
   *	@param	gz          `FbNObhZ
   *	@param  way_x       `FbNX
   *	@param  way_z       `FbNZ
   *
   *	@retval true    GJEg
   *	@retval false   qbgȂ
   */
  //-----------------------------------------------------------------------------
  bool EventTrainerEye::Check16Way( const mmodel::MoveModel* cp_model, const gfl::math::VEC3* cp_pos, s32 way_x, s32 way_z )
  {
    s16 mgx;
    s16 mgz;
    s16 cgx;
    s16 cgz;
    f32 diff_y;
    u32 range;
    
    s16 mx; // `FbN
    s16 mz; // `FbN


    // YW̍`FbN
    diff_y = cp_pos->y - cp_model->GetVectorPosY();
    if(  gfl::math::Abs(diff_y) >= mmodel::H_GRID_FELLOW_SIZE ){
#if PM_DEBUG
#else
      return false;
#endif
    }
    
    // f̃ObhW擾
    mgx = cp_model->GetGridPosX(); 
    mgz = cp_model->GetGridPosZ(); 

    // `FbNObhW擾
    cgx = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->x) );
    cgz = POS_TO_GRID<s16>( static_cast<s16>(cp_pos->z) );

    // ff[^烌W擾
    range = TEST_RANGE;

    // range  ͈͂ɂ邩`FbNB
    if( ((way_x < 0) && ((mgx - cgx) >= range)) ||
        ((way_x > 0) && ((mgx - cgx) <= -range)) ){
#if PM_DEBUG
#else
      return false;
#endif
    }
    if( ((way_z < 0) && ((mgz - cgz) >= range)) ||
        ((way_z > 0) && ((mgz - cgz) <= -range)) ){
#if PM_DEBUG
#else
      return false;
#endif
    }

#if PM_DEBUG

    s32 debug_start_mgx = mgx;
    s32 debug_start_mgz = mgz;
    DEBUG_TrainerEyeCheckBuffer[ (sc_DEBUG_TREYE_CHECK_BUF_HH * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + sc_DEBUG_TREYE_CHECK_BUF_HW ] = 1;
#endif

    mx = way_x / gfl::math::Abs(way_x);
    mz = way_z / gfl::math::Abs(way_z);

    if( gfl::math::Abs(way_x) > gfl::math::Abs(way_z) ){
      mgx += mx;
    }
    else if( gfl::math::Abs(way_z) > gfl::math::Abs(way_x) ){
      mgz += mz;
    }
    
    // ́Aŏ́Amgʒuway ̏ȂقɂPi񂾂Ƃ̂݃`FbNB
    bool check_one_way;

    // 
    for( u32 i=0; i<range/2; ++i ){
      check_one_way = false;

#if PM_DEBUG
      s32 debug_x = mgx - debug_start_mgx;
      s32 debug_z = mgz - debug_start_mgz;
#endif
      
      
      // 0̂ƂArangeōŏ
      // way  2̂قւ̃`FbNςB
      if( i==0 && ((range % 2) == 0) ){

        // ́Aŏ́Amgʒuway ̏ȂقɂPi񂾂Ƃ̂݃`FbN
        check_one_way = true; 
      }


#if PM_DEBUG
      DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + debug_z) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x)) ] = 2;
#endif
      if( (mgx == cgx) && (mgz == cgz) ){
        return true;
      }
      
      // i==0rangeȂ班Ȃقɂ`FbNB
      if( (check_one_way && (gfl::math::Abs(way_z) < gfl::math::Abs(way_x))) || (!check_one_way) ){

#if PM_DEBUG
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z + mz)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x)) ] = 2;
#endif
        if( (mgx == cgx) && ((mgz + mz) == cgz) ){
          return true;
        }
      }

      // i==0rangeȂ班Ȃقɂ`FbNB
      if( (check_one_way && (gfl::math::Abs(way_x) < gfl::math::Abs(way_z))) || (!check_one_way) ){

#if PM_DEBUG
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x + mx)) ] = 2;
#endif
        if( ((mgx + mx) == cgx) && (mgz == cgz) ){
          return true;
        }
      }

      // i==0rangeȂmx@@mzObh̓`FbNȂB
      if( !check_one_way ){

#if PM_DEBUG
        DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z + mz)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x + mx)) ] = 2;
#endif
        if( ((mgx + mx) == cgx) && ((mgz + mz) == cgz) ){
          return true;
        }
      }

      if( check_one_way ){
        mgx += mx;
        mgz += mz;
      }else{
        mgx += way_x;
        mgz += way_z;
      }


    }

#if PM_DEBUG
    s32 debug_x = mgx - debug_start_mgx;
    s32 debug_z = mgz - debug_start_mgz;
#endif

    // ŌɁAway_x way_z@̏قObh`FbN
    if( gfl::math::Abs(way_x) > gfl::math::Abs(way_z) ){
      
#if PM_DEBUG
      DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z - way_z)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x)) ] = 2;
#endif
      if( (mgx == cgx) && ((mgz - way_z) == cgz) ){
        return true;
      }
      
    }
    else if( gfl::math::Abs(way_z) > gfl::math::Abs(way_x) ){

#if PM_DEBUG
      DEBUG_TrainerEyeCheckBuffer[ ((sc_DEBUG_TREYE_CHECK_BUF_HH + (debug_z)) * sc_DEBUG_TREYE_CHECK_BUF_WIDHT) + (sc_DEBUG_TREYE_CHECK_BUF_HW + (debug_x - way_x)) ] = 2;
#endif
      if( ((mgx - way_x) == cgx) && (mgz == cgz) ){
        return true;
      }
    }


    return false;

  }

  
  
} // namespace field
