//=======================================================================================
/**
 * @file WazaListBase.h
 * @briefu킴݂vʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.05
 */
//=======================================================================================
#ifndef __WAZALISTBASE_H__
#define __WAZALISTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class WazaListBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( WazaListBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      WazaListBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~WazaListBase();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // J[\ʒu
      enum InitCursorPos {
        INIT_CURSOR_POS_WAZA0,  // 莝Z0
        INIT_CURSOR_POS_WAZA1,  // 莝Z1
        INIT_CURSOR_POS_WAZA2,  // 莝Z2
        INIT_CURSOR_POS_WAZA3,  // 莝Z3
        INIT_CURSOR_POS_LEFT,   // {^
        INIT_CURSOR_POS_RIGHT,  // E{^
        INIT_CURSOR_POS_STATUS, //u悳݂v
        INIT_CURSOR_POS_RETURN, //uǂv
      };

      // ݒ
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
        bool left_enable;                // {^邩ǂ
        bool right_enable;               // E{^邩ǂ
        InitCursorPos init_cursor_pos;   // J[\ʒu
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_LEFT,    // {^I
        RESULT_RIGHT,   // E{^I
        RESULT_STATUS,  //u悳݂vI
        RESULT_WAZA,    // ZI
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;

      /**
       * @brief IZ̃CfbNX擾
       * @note RESULT_WAZA ̏ꍇɂ̂ݗL
       */
      u8 GetSelectedWazaIndex( void ) const;





      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }
      bool IsLeftEnable( void ) const { return m_settings.left_enable; }
      bool IsRightEnable( void ) const { return m_settings.right_enable; }
      InitCursorPos GetInitCursorPos( void ) const { return m_settings.init_cursor_pos; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }
      void SetSelectedWazaIndex( u8 index ) { m_selected_waza_index = index; }


      private:
      Setting m_settings;
      Result m_result;
      u8 m_selected_waza_index;
    };


  }  // namespace app
}  // namespace btl


#endif // __WAZALISTBASE_H__ 
