//=======================================================================================
/**
 * @file WazaList.cpp
 * @briefu킴݂v
 * @author obata_toshihiro
 * @date 2011.09.05
 */
//=======================================================================================
#include <gflib.h>
#include <print/xy_msgWin.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "WazaListBase.h"
#include "WazaList.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "waza_list.h"
#include "waza_list_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 WazaList::APP_HEAPSIZE    =  0x1000;
    const u32 WazaList::DEVICE_HEAPSIZE = 0x60000;

    // ľ
    const u32 WazaList::PP_PLACE_COUNT = 2;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp WazaList::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex 
      WazaList::ANIMATION_DATA_TABLE[ WazaList::ANIMATION_DATA_NUM ] = 
      {
        /* ANIMATION_DATA_POKE_SICK */ LYTRES_WAZA_LIST_WAZA_LIST_POKE_SICK_BCLAN,
        /* ANIMATION_DATA_POKE_DEAD */ LYTRES_WAZA_LIST_WAZA_LIST_POKE_DEAD_BCLAN,
        /* ANIMATION_DATA_DUMMY_TYPE_ICON */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_TYPE_ICON_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_HOLD_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_RELEASE_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_LIST_WAZA_LIST_DUMMY_BUTTON_SELECT_BCLAN,
        /* ANIMATION_DATA_LEFT_BUTTON_ACTIVE */ LYTRES_WAZA_LIST_WAZA_LIST_LEFT_BUTTON_ACTIVE_BCLAN,
        /* ANIMATION_DATA_LEFT_BUTTON_PASSIVE */ LYTRES_WAZA_LIST_WAZA_LIST_LEFT_BUTTON_PASSIVE_BCLAN,
        /* ANIMATION_DATA_RIGHT_BUTTON_ACTIVE */ LYTRES_WAZA_LIST_WAZA_LIST_RIGHT_BUTTON_ACTIVE_BCLAN,
        /* ANIMATION_DATA_RIGHT_BUTTON_PASSIVE */ LYTRES_WAZA_LIST_WAZA_LIST_RIGHT_BUTTON_PASSIVE_BCLAN,
        /* ANIMATION_DATA_WAZA0_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA0_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA0_NOT_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA0_NOT_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA1_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA1_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA1_NOT_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA1_NOT_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA2_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA2_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA2_NOT_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA2_NOT_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA3_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA3_EXIST_BCLAN,
        /* ANIMATION_DATA_WAZA3_NOT_EXIST */ LYTRES_WAZA_LIST_WAZA_LIST_WAZA3_NOT_EXIST_BCLAN,
        /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_FLUCTUATE_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_LEFT */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_LEFT_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_RIGHT */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_RIGHT_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_STATUS */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_STATUS_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_RETURN */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_RETURN_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_WAZA0 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA0_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_WAZA1 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA1_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_WAZA2 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA2_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_WAZA3 */ LYTRES_WAZA_LIST_WAZA_LIST_CURSOR_ON_WAZA3_BCLAN,
      };


    

    // LAj[VƂ̐ݒ
    const WazaList::ShareAnimationDesc 
      WazaList::SHARE_ANIMATION_DESC[ WazaList::SHARE_ANIMATION_NUM ] = 
      {
        /* SHARE_ANIMATION_TYPEICON */
        {
          ANIMATION_TYPEICON, 
          ANIMATION_DATA_DUMMY_TYPE_ICON,
          TYPEICON_NUM,
          PANENAME_WAZA_LIST_GROUP_TYPE_ICON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_HOLD */
        {
          ANIMATION_BUTTON_HOLD, 
          ANIMATION_DATA_DUMMY_BUTTON_HOLD,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_RELEASE */
        {
          ANIMATION_BUTTON_RELEASE, 
          ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_SELECT */
        {
          ANIMATION_BUTTON_SELECT, 
          ANIMATION_DATA_DUMMY_BUTTON_SELECT,
          BUTTON_NUM,
          PANENAME_WAZA_LIST_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // {^Ƃ̐ݒ
    const WazaList::ButtonDesc WazaList::BUTTON_DESC[ WazaList::BUTTON_NUM ] = 
    {
      /* BUTTON_WAZA0 */ 
      {
        WazaListBase::RESULT_WAZA,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_00,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA0,
        WAZA_BUTTON_0,
      },
      /* BUTTON_WAZA1 */ 
      {
        WazaListBase::RESULT_WAZA,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_01,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA1,
        WAZA_BUTTON_1,
      },
      /* BUTTON_WAZA2 */ 
      {
        WazaListBase::RESULT_WAZA,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_02,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA2,
        WAZA_BUTTON_2,
      },
      /* BUTTON_WAZA3 */ 
      {
        WazaListBase::RESULT_WAZA,
        PANENAME_WAZA_LIST_PANE_WAZA_BUTTON_03,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA3,
        WAZA_BUTTON_3,
      },
      /* BUTTON_LEFT */ 
      {
        WazaListBase::RESULT_LEFT,
        PANENAME_WAZA_LIST_PANE_LEFT_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_LEFT ),
        ANIMATION_LEFT_BUTTON_ACTIVE,
        ANIMATION_LEFT_BUTTON_PASSIVE,
        ANIMATION_CURSOR_ON_LEFT,
        WAZA_BUTTON_NULL,
      },
      /* BUTTON_RIGHT */ 
      {
        WazaListBase::RESULT_RIGHT,
        PANENAME_WAZA_LIST_PANE_RIGHT_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RIGHT ),
        ANIMATION_RIGHT_BUTTON_ACTIVE,
        ANIMATION_RIGHT_BUTTON_PASSIVE,
        ANIMATION_CURSOR_ON_RIGHT,
        WAZA_BUTTON_NULL,
      },
      /* BUTTON_STATUS */ 
      {
        WazaListBase::RESULT_STATUS,
        PANENAME_WAZA_LIST_PANE_STATUS_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_STATUS ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_STATUS ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_STATUS ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_STATUS,
        WAZA_BUTTON_NULL,
      },
      /* BUTTON_RETURN */ 
      {
        WazaListBase::RESULT_RETURN,
        PANENAME_WAZA_LIST_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_RETURN,
        WAZA_BUTTON_NULL,
      },
    };




    // Z{^Ƃ̐ݒ
    const WazaList::WazaButtonDesc WazaList::WAZA_BUTTON_DESC[ WazaList::WAZA_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_0 */ 
      {
        0,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_00,
        PANENAME_WAZA_LIST_PANE_PP_00,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_00,
        PANENAME_WAZA_LIST_PANE_PP_MAX_00,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA0 ),
        ANIMATION_WAZA0_EXIST,
        ANIMATION_WAZA0_NOT_EXIST,
      },
      /* WAZA_BUTTON_1 */ 
      {
        1,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_01,
        PANENAME_WAZA_LIST_PANE_PP_01,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_01,
        PANENAME_WAZA_LIST_PANE_PP_MAX_01,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA1 ),
        ANIMATION_WAZA1_EXIST,
        ANIMATION_WAZA1_NOT_EXIST,
      },
      /* WAZA_BUTTON_2 */ 
      {
        2,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_02,
        PANENAME_WAZA_LIST_PANE_PP_02,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_02,
        PANENAME_WAZA_LIST_PANE_PP_MAX_02,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA2 ),
        ANIMATION_WAZA2_EXIST,
        ANIMATION_WAZA2_NOT_EXIST,
      },
      /* WAZA_BUTTON_3 */ 
      {
        3,
        PANENAME_WAZA_LIST_PANE_WAZA_NAME_03,
        PANENAME_WAZA_LIST_PANE_PP_03,
        PANENAME_WAZA_LIST_PANE_PP_VALUE_03,
        PANENAME_WAZA_LIST_PANE_PP_MAX_03,
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA3 ),
        ANIMATION_WAZA3_EXIST,
        ANIMATION_WAZA3_NOT_EXIST,
      },
    };





    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      WazaList::CURSOR_MOVE_DATA[ WazaList::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_WAZA0,  { BUTTON_WAZA0,  BUTTON_WAZA2,  BUTTON_WAZA0,  BUTTON_WAZA1 } },
        { BUTTON_WAZA1,  { BUTTON_WAZA1,  BUTTON_WAZA3,  BUTTON_WAZA0,  BUTTON_WAZA1 } },
        { BUTTON_WAZA2,  { BUTTON_WAZA0,  BUTTON_LEFT,   BUTTON_WAZA2,  BUTTON_WAZA3 } },
        { BUTTON_WAZA3,  { BUTTON_WAZA1,  BUTTON_RETURN, BUTTON_WAZA2,  BUTTON_WAZA3 } },
        { BUTTON_LEFT,   { BUTTON_WAZA2,  BUTTON_LEFT,   BUTTON_LEFT,   BUTTON_RIGHT } },
        { BUTTON_RIGHT,  { BUTTON_WAZA2,  BUTTON_RIGHT,  BUTTON_LEFT,   BUTTON_STATUS } },
        { BUTTON_STATUS, { BUTTON_WAZA3,  BUTTON_STATUS, BUTTON_RIGHT,  BUTTON_RETURN } },
        { BUTTON_RETURN, { BUTTON_WAZA3,  BUTTON_RETURN, BUTTON_STATUS, BUTTON_RETURN } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    WazaList::WazaList( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      WazaListBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_WAZA_LIST: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void WazaList::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void WazaList::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void WazaList::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_waza_list_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_LIST_WAZA_LIST_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void WazaList::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void WazaList::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void WazaList::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void WazaList::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    WazaList::~WazaList()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }



    // J[\ǗIuWFNgj
    void WazaList::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void WazaList::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void WazaList::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void WazaList::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void WazaList::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 

      this->SetupStaticStrings();  // @todo xݒ肵ȍ~͕KvȂ
      this->SetupPokeParamDisplay();
      this->SetupLeftButton();
      this->SetupRightButton();

      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>( i );
        this->SetupWazaButton( button_index );
      }
    }



    // Œ蕶̃ZbgAbv
    void WazaList::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message_data = AppBase::GetMessageData();

      ::app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_LIST_PANE_STATUS_LABEL, message_data, STR_VIEW_STATUS );

      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, WAZA_BUTTON_DESC[i].pp_label_pane, message_data, STR_PP );
      }
    }


    // {^̃ZbgAbv
    void WazaList::SetupLeftButton( void )
    {
      if( this->IsLeftEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_LEFT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_LEFT );
      }
    }


    // E{^̃ZbgAbv
    void WazaList::SetupRightButton( void )
    {
      if( this->IsRightEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_RIGHT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_RIGHT );
      }
    }


    // |Pp[^\̃ZbgAbv
    void WazaList::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Type();
      this->SetupPokeParamDisplay_Status();
      this->SetupPokeParamDisplay_Item();
    }


    // |Pp[^\̃ZbgAbv( O )
    void WazaList::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = ::app::util::GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_LIST_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void WazaList::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      ::app::util::SetTextboxPaneSex( m_layout_work, PANENAME_WAZA_LIST_PANE_POKE_SEX, sex ); 
    }


    // |Pp[^\̃ZbgAbv( ^Cv )
    void WazaList::SetupPokeParamDisplay_Type( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      pml::PokeType type1 = pokeparam->GetType1();
      pml::PokeType type2 = pokeparam->GetType2();

      // ^Cv1
      AnimationIndex type1_anime = 
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKETYPE1 );
      ::app::util::StartAnimation( m_layout_work, type1_anime );
      ::app::util::PauseAnimation( m_layout_work, type1_anime, false );
      ::app::util::SetAnimationFrame( m_layout_work, type1_anime, type1 );

      // ^Cv2
      if( type1 == type2 ) {
        ::app::util::SetPaneInvisible( m_layout_work, PANENAME_WAZA_LIST_PANE_TYPE_ICON2 );
      }
      else {
        AnimationIndex type2_anime = 
          static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKETYPE2 );
        ::app::util::SetPaneVisible( m_layout_work, PANENAME_WAZA_LIST_PANE_TYPE_ICON2 );
        ::app::util::StartAnimation( m_layout_work, type2_anime );
        ::app::util::PauseAnimation( m_layout_work, type2_anime, false );
        ::app::util::SetAnimationFrame( m_layout_work, type2_anime, type2 );
      }
    }


    // |Pp[^\̃ZbgAbv( Ԉُ )
    void WazaList::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        ::app::util::StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        ::app::util::StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        ::app::util::StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        ::app::util::StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        ::app::util::PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        ::app::util::SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }


    // |Pp[^\̃ZbgAbv( ACe )
    void WazaList::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool icon_visible = ( itemno != ITEM_DUMMY_DATA );
      ::app::util::SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_LIST_PANE_ITEM_ICON, icon_visible );
    }




    // Z{^̃ZbgAbv
    void WazaList::SetupWazaButton( WazaButtonIndex waza_button_index )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ waza_button_index ];
      WazaNo wazano = pokeparam->GetWazaNo( desc.waza_index );

      if( wazano == WAZANO_NULL )
      {
        ButtonIndex button_index = 
          static_cast<ButtonIndex>( BUTTON_WAZA0 + waza_button_index );
        m_button_manager->SetButtonPassive( button_index );
        this->SetWazaButtonDisplay_NotExist( waza_button_index );
      }
      else
      {
        ButtonIndex button_index = 
          static_cast<ButtonIndex>( BUTTON_WAZA0 + waza_button_index );
        m_button_manager->SetButtonActive( button_index );
        this->SetWazaButtonDisplay_Exist( waza_button_index );
        this->SetWazaButtonDisplay_Info( waza_button_index );
      }
    }


    // Z݂Ԃɂ
    void WazaList::SetWazaButtonDisplay_Exist( WazaButtonIndex button_index )
    {
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];
      ::app::util::StopAnimation( m_layout_work, desc.not_exist_animation );
      ::app::util::StartAnimation( m_layout_work, desc.exist_animation );
    }


    // Z݂ȂԂɂ
    void WazaList::SetWazaButtonDisplay_NotExist( WazaButtonIndex button_index )
    {
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];
      ::app::util::StopAnimation( m_layout_work, desc.exist_animation );
      ::app::util::StartAnimation( m_layout_work, desc.not_exist_animation );
    }



    // Z{^̏Zbg
    void WazaList::SetWazaButtonDisplay_Info( WazaButtonIndex button_index )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      const WazaButtonDesc& desc = WAZA_BUTTON_DESC[ button_index ];

      // Z
      WazaNo wazano = btlparam->WAZA_GetID( desc.waza_index );
      ::app::util::SetTextboxPaneWazaName( m_layout_work, desc.waza_name_pane, wazano );

      // oo
      u8 now_pp = btlparam->WAZA_GetPP( desc.waza_index );
      u8 max_pp = pokeparam->GetWazaMaxPP( desc.waza_index );
      ::app::util::SetTextboxPaneNumber( 
          m_layout_work, desc.pp_value_pane, now_pp, PP_PLACE_COUNT );
      ::app::util::SetTextboxPaneNumber( 
          m_layout_work, desc.pp_max_pane, max_pp, PP_PLACE_COUNT );

      // ^Cv
      pml::PokeType type = pml::System::WazaDataSystem()->GetType( wazano );
      ::app::util::StartAnimation( m_layout_work, desc.typeicon_animation );
      ::app::util::PauseAnimation( m_layout_work, desc.typeicon_animation, false );
      ::app::util::SetAnimationFrame( m_layout_work, desc.typeicon_animation, type );
    }





    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void WazaList::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_animation_index = ANIMATION_NULL;
      this->InitializeCursorPos();
    }


    // J[\ʒu
    void WazaList::InitializeCursorPos( void )
    {
      InitCursorPos init_pos = this->GetInitCursorPos();
      ButtonIndex init_button = BUTTON_RETURN;

      switch( init_pos ) {
        case INIT_CURSOR_POS_WAZA0:  init_button = BUTTON_WAZA0; break;
        case INIT_CURSOR_POS_WAZA1:  init_button = BUTTON_WAZA1; break;
        case INIT_CURSOR_POS_WAZA2:  init_button = BUTTON_WAZA2; break;
        case INIT_CURSOR_POS_WAZA3:  init_button = BUTTON_WAZA3; break;
        case INIT_CURSOR_POS_LEFT:   init_button = BUTTON_LEFT; break;
        case INIT_CURSOR_POS_RIGHT:  init_button = BUTTON_RIGHT; break;
        case INIT_CURSOR_POS_STATUS: init_button = BUTTON_STATUS; break;
        case INIT_CURSOR_POS_RETURN: init_button = BUTTON_RETURN; break;
      }

      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>( i );
        const ButtonDesc& button_desc = BUTTON_DESC[ button_index ];
        if( button_index == init_button ) {
          ::app::util::StartAnimation( m_layout_work, button_desc.cursor_animation );
        }
        else {
          ::app::util::StopAnimation( m_layout_work, button_desc.cursor_animation );
        } 
      }
      m_cursor_manager->SetPos( init_button );
      ::app::util::StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void WazaList::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void WazaList::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void WazaList::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultByCursorPos( selected_button );
            this->StartSelectAnimation( selected_button );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          if( this->IsSelectEnable( BUTTON_RETURN ) ) {
            this->SetResultByCursorPos( BUTTON_RETURN );
            this->StartSelectAnimation( BUTTON_RETURN );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }






    // {^Ă邩ǂ𒲂ׂ
    bool WazaList::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool WazaList::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    WazaList::ButtonIndex WazaList::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }




    // J[\̓XV
    bool WazaList::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    WazaList::ButtonIndex WazaList::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    WazaList::ButtonIndex WazaList::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void WazaList::StartCursorMoveAnimation( 
        WazaList::ButtonIndex old_cursor_pos, WazaList::ButtonIndex new_cursor_pos )
    {
      ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_animation );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_animation );
    }






    // I\ǂ𒲂ׂ
    bool WazaList::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // J[\ʒu, 쌋ʂZbg
    void WazaList::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );

      WazaButtonIndex waza_button_index = BUTTON_DESC[ cursor_pos ].waza_button_index;
      if( waza_button_index != WAZA_BUTTON_NULL ) {
        u8 waza_index = WAZA_BUTTON_DESC[ waza_button_index ].waza_index;
        this->SetSelectedWazaIndex( waza_index );
      }
    } 


    // ȊIAj[VJn
    void WazaList::StartSelectAnimation( ButtonIndex cursor_pos )
    {
      m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
      ::app::util::StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool WazaList::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }






  }  // namespace app
}  // namespace btl
