//=======================================================================================
/**
 * @file WazaInfoBase.h
 * @briefuZ̏ڍ׏vʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.06
 */
//=======================================================================================
#ifndef __WAZAINFOBASE_H__
#define __WAZAINFOBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class WazaInfoBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( WazaInfoBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      WazaInfoBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~WazaInfoBase();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
        u8 waza_index;                   // \Z̃CfbNX
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_WAZA0,   // Zʒu0I
        RESULT_WAZA1,   // Zʒu1I
        RESULT_WAZA2,   // Zʒu2I
        RESULT_WAZA3,   // Zʒu3I
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;




      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }
      u8 GetWazaIndex( void ) const { return m_settings.waza_index; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __WAZAINFOBASE_H__ 
