//=======================================================================================
/**
 * @file WazaInfo.h
 * @briefuZ̏ڍ׏v
 * @author obata_toshihiro
 * @date 2011.09.06
 */
//=======================================================================================
#ifndef __WAZAINFO_H__
#define __WAZAINFO_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "WazaInfoBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class WazaInfo : public WazaInfoBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( WazaInfo );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      WazaInfo( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~WazaInfo(); 


      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Restart( void );

      /**
       * @brief I[g`tOZbg
       */
      virtual void SetAutoDrawFlag( bool flag );


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting );






      private:


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^ԍ
      enum ButtonIndex {
        BUTTON_WAZA0,   // Zʒu0
        BUTTON_WAZA1,   // Zʒu1
        BUTTON_WAZA2,   // Zʒu2
        BUTTON_WAZA3,   // Zʒu3
        BUTTON_RETURN,  //uǂv
        BUTTON_NUM,
      };


      // ^CvACRԍ
      enum TypeIconIndex {
        TYPEICON_POKE1,
        TYPEICON_POKE2,
        TYPEICON_WAZA,
        TYPEICON_NUM,
      };


      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_POKE_SICK,
        ANIMATION_DATA_POKE_DEAD,
        ANIMATION_DATA_DUMMY_TYPE_ICON,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_CURSOR_FLUCTUATE,
        ANIMATION_DATA_WAZA_KIND,
        ANIMATION_DATA_WAZA_POS_0,
        ANIMATION_DATA_WAZA_POS_1,
        ANIMATION_DATA_WAZA_POS_2,
        ANIMATION_DATA_WAZA_POS_3,
        ANIMATION_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_POKE_SICK,
        ANIMATION_POKE_DEAD,
        ANIMATION_DUMMY_TYPE_ICON,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BUTTON_RELEASE,
        ANIMATION_DUMMY_BUTTON_SELECT,
        ANIMATION_CURSOR_FLUCTUATE,
        ANIMATION_WAZA_KIND,
        ANIMATION_WAZA_POS_0,
        ANIMATION_WAZA_POS_1,
        ANIMATION_WAZA_POS_2,
        ANIMATION_WAZA_POS_3,
        // ȉ, LAj[V
        ANIMATION_TYPEICON,
        ANIMATION_BUTTON_HOLD = ANIMATION_TYPEICON + TYPEICON_NUM,
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + BUTTON_NUM,
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + BUTTON_NUM,
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + BUTTON_NUM,
        ANIMATION_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_TYPE_ICON,
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        WazaInfoBase::Result result;              // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation;            // ꂽۂ̃Aj[V
        AnimationIndex release_animation;         // ꂽۂ̃Aj[V
        AnimationIndex select_animation;          // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation;          // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation;         // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation;          // J[\ZbgAj[V
      };





      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 PP_PLACE_COUNT;
      static const u32 WAZAPARAM_PLACE_COUNT;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation_index;


      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteButtonManager( void );

      void SetupStaticStrings( void );
      void SetupPokeParamDisplay( void );
      void SetupPokeParamDisplay_Name( void );
      void SetupPokeParamDisplay_Sex( void );
      void SetupPokeParamDisplay_Type( void );
      void SetupPokeParamDisplay_Status( void );
      void SetupPokeParamDisplay_Item( void );
      void SetupWazaDisplay( void );
      void SetupWazaDisplay_Name( WazaNo wazano );
      void SetupWazaDisplay_Type( WazaNo wazano );
      void SetupWazaDisplay_PP( u8 waza_index );
      void SetupWazaDisplay_Kind( WazaNo wazano );
      void SetupWazaDisplay_Power( WazaNo wazano );
      void SetupWazaDisplay_Hit( WazaNo wazano );
      void SetupWazaDisplay_Info( WazaNo wazano );
      void SetupWazaPosButtons( void );

      void UpdateSequence( void );
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultByCursorPos( ButtonIndex cursor_pos );

      void StartSelectAnimation( ButtonIndex cursor_pos );
      bool IsSelectAnimationFinished( void ) const;
      void StartCursorMoveAnimation( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __WAZAINFO_H__ 
