//=======================================================================================
/**
 * @file WazaInfo.cpp
 * @briefuZ̏ڍ׏v
 * @author obata_toshihiro
 * @date 2011.09.06
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "WazaInfoBase.h"
#include "WazaInfo.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "waza_info.h"
#include "waza_info_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 WazaInfo::APP_HEAPSIZE    =  0x1000;
    const u32 WazaInfo::DEVICE_HEAPSIZE = 0x50000; 

    // ľ
    const u32 WazaInfo::PP_PLACE_COUNT = 2;
    const u32 WazaInfo::WAZAPARAM_PLACE_COUNT = 3;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp WazaInfo::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex 
      WazaInfo::ANIMATION_DATA_TABLE[ WazaInfo::ANIMATION_DATA_NUM ] = 
      {
        /* ANIMATION_DATA_POKE_SICK */ LYTRES_WAZA_INFO_WAZA_INFO_POKE_SICK_BCLAN,
        /* ANIMATION_DATA_POKE_DEAD */ LYTRES_WAZA_INFO_WAZA_INFO_POKE_DEAD_BCLAN,
        /* ANIMATION_DATA_DUMMY_TYPE_ICON */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_TYPE_ICON_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_HOLD_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_RELEASE_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_INFO_WAZA_INFO_DUMMY_BUTTON_SELECT_BCLAN,
        /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_WAZA_INFO_WAZA_INFO_CURSOR_FLUCTUATE_BCLAN,
        /* ANIMATION_DATA_WAZA_KIND */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_KIND_BCLAN,
        /* ANIMATION_DATA_WAZA_POS_0 */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_POS_0_BCLAN,
        /* ANIMATION_DATA_WAZA_POS_1 */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_POS_1_BCLAN,
        /* ANIMATION_DATA_WAZA_POS_2 */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_POS_2_BCLAN,
        /* ANIMATION_DATA_WAZA_POS_3 */ LYTRES_WAZA_INFO_WAZA_INFO_WAZA_POS_3_BCLAN,
      };


    

    // LAj[VƂ̐ݒ
    const WazaInfo::ShareAnimationDesc 
      WazaInfo::SHARE_ANIMATION_DESC[ WazaInfo::SHARE_ANIMATION_NUM ] = 
      {
        /* SHARE_ANIMATION_TYPE_ICON */
        {
          ANIMATION_TYPEICON, 
          ANIMATION_DATA_DUMMY_TYPE_ICON,
          TYPEICON_NUM,
          PANENAME_WAZA_INFO_GROUP_TYPE_ICON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_HOLD */
        {
          ANIMATION_BUTTON_HOLD, 
          ANIMATION_DATA_DUMMY_BUTTON_HOLD,
          BUTTON_NUM,
          PANENAME_WAZA_INFO_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_RELEASE */
        {
          ANIMATION_BUTTON_RELEASE, 
          ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
          BUTTON_NUM,
          PANENAME_WAZA_INFO_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_SELECT */
        {
          ANIMATION_BUTTON_SELECT, 
          ANIMATION_DATA_DUMMY_BUTTON_SELECT,
          BUTTON_NUM,
          PANENAME_WAZA_INFO_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // {^Ƃ̐ݒ
    const WazaInfo::ButtonDesc WazaInfo::BUTTON_DESC[ WazaInfo::BUTTON_NUM ] = 
    {
      /* BUTTON_WAZA0 */ 
      {
        WazaInfoBase::RESULT_WAZA0,
        PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_00,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* BUTTON_WAZA1 */ 
      {
        WazaInfoBase::RESULT_WAZA1,
        PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_01,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* BUTTON_WAZA2 */ 
      {
        WazaInfoBase::RESULT_WAZA2,
        PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_02,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* BUTTON_WAZA3 */ 
      {
        WazaInfoBase::RESULT_WAZA3,
        PANENAME_WAZA_INFO_PANE_WPOS_BUTTON_03,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
      /* BUTTON_RETURN */ 
      {
        WazaInfoBase::RESULT_RETURN,
        PANENAME_WAZA_INFO_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };











    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    WazaInfo::WazaInfo( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      WazaInfoBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateButtonManager();
      this->SetupButtonManager();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_WAZA_INFO: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void WazaInfo::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void WazaInfo::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void WazaInfo::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_waza_info_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_INFO_WAZA_INFO_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void WazaInfo::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // {^}l[W𐶐
    void WazaInfo::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void WazaInfo::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    WazaInfo::~WazaInfo()
    {
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }


    // {^}l[Wj
    void WazaInfo::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void WazaInfo::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void WazaInfo::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void WazaInfo::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->SetupStaticStrings();
      this->SetupPokeParamDisplay();
      this->SetupWazaDisplay();
      this->SetupWazaPosButtons();
    }



    // Œ蕶̃ZbgAbv
    void WazaInfo::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message_data = AppBase::GetMessageData();
      ::app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP, message_data, STR_PP );
      ::app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_KIND, message_data, STR_WAZA_KIND );
      ::app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_POWER, message_data, STR_WAZA_POWER );
      ::app::util::SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_HIT, message_data, STR_WAZA_HIT );
    }




    // |Pp[^\̃ZbgAbv
    void WazaInfo::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Type();
      this->SetupPokeParamDisplay_Status();
      this->SetupPokeParamDisplay_Item();
    }


    // |Pp[^\̃ZbgAbv( O )
    void WazaInfo::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = ::app::util::GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void WazaInfo::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      ::app::util::SetTextboxPaneSex( m_layout_work, PANENAME_WAZA_INFO_PANE_POKE_SEX, sex ); 
    }


    // |Pp[^\̃ZbgAbv( ^Cv )
    void WazaInfo::SetupPokeParamDisplay_Type( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      pml::PokeType type1 = pokeparam->GetType1();
      pml::PokeType type2 = pokeparam->GetType2();

      // ^Cv1
      AnimationIndex type1_anime = 
        static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKE1 );
      ::app::util::StartAnimation( m_layout_work, type1_anime );
      ::app::util::PauseAnimation( m_layout_work, type1_anime, false );
      ::app::util::SetAnimationFrame( m_layout_work, type1_anime, type1 );

      // ^Cv2
      if( type1 == type2 ) {
        ::app::util::SetPaneInvisible( m_layout_work, PANENAME_WAZA_INFO_PANE_TYPE_ICON2 );
      }
      else {
        AnimationIndex type2_anime = 
          static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_POKE2 );
        ::app::util::SetPaneVisible( m_layout_work, PANENAME_WAZA_INFO_PANE_TYPE_ICON2 );
        ::app::util::StartAnimation( m_layout_work, type2_anime );
        ::app::util::PauseAnimation( m_layout_work, type2_anime, false );
        ::app::util::SetAnimationFrame( m_layout_work, type2_anime, type2 );
      }
    }


    // |Pp[^\̃ZbgAbv( Ԉُ )
    void WazaInfo::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        ::app::util::StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        ::app::util::StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        ::app::util::StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        ::app::util::StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        ::app::util::PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        ::app::util::SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }


    // |Pp[^\̃ZbgAbv( ACe )
    void WazaInfo::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool icon_visible = ( itemno != ITEM_DUMMY_DATA );
      ::app::util::SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_ITEM_ICON, icon_visible );
    }







    // Z̕\ZbgAbv
    void WazaInfo::SetupWazaDisplay( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      u8 waza_index = this->GetWazaIndex();
      WazaNo wazano = pokeparam->GetWazaNo( waza_index );

      this->SetupWazaDisplay_Name( wazano );
      this->SetupWazaDisplay_Type( wazano );
      this->SetupWazaDisplay_PP( waza_index );
      this->SetupWazaDisplay_Kind( wazano );
      this->SetupWazaDisplay_Power( wazano );
      this->SetupWazaDisplay_Hit( wazano );
      this->SetupWazaDisplay_Info( wazano );
    }


    // Z̕\ZbgAbv( O )
    void WazaInfo::SetupWazaDisplay_Name( WazaNo wazano )
    {
      gfl::str::StrBuf* tempbuf = ::app::util::GetTempStrBuf();
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      wazadata_system->GetWazaName( wazano, tempbuf );
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_NAME, tempbuf );
    }


    // Z̕\ZbgAbv( ^Cv )
    void WazaInfo::SetupWazaDisplay_Type( WazaNo wazano )
    {
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      pml::PokeType type = wazadata_system->GetType( wazano );
      AnimationIndex type_anime = static_cast<AnimationIndex>( ANIMATION_TYPEICON + TYPEICON_WAZA );
      ::app::util::StartAnimation( m_layout_work, type_anime );
      ::app::util::PauseAnimation( m_layout_work, type_anime, false );
      ::app::util::SetAnimationFrame( m_layout_work, type_anime, type );
    }


    // Z̕\ZbgAbv( PP )
    void WazaInfo::SetupWazaDisplay_PP( u8 waza_index )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      u8 now_pp = btlparam->WAZA_GetPP( waza_index );
      u8 max_pp = pokeparam->GetWazaMaxPP( waza_index );
      ::app::util::SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP_VALUE, now_pp, PP_PLACE_COUNT );
      ::app::util::SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_PP_MAX, max_pp, PP_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaInfo::SetupWazaDisplay_Kind( WazaNo wazano )
    { 
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      pml::wazadata::WazaDamageType kind = wazadata_system->GetDamageType( wazano );
      ::app::util::StartAnimation( m_layout_work, ANIMATION_WAZA_KIND );
      ::app::util::PauseAnimation( m_layout_work, ANIMATION_WAZA_KIND, false );
      ::app::util::SetAnimationFrame( m_layout_work, ANIMATION_WAZA_KIND, kind );

      u32 strid[] = 
      {
        STR_WAZA_KIND_HENKA,
        STR_WAZA_KIND_BUTURI,
        STR_WAZA_KIND_TOKUSYU,
      }; 
      gfl::str::MsgData* message_data = this->GetMessageData();
      ::app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_KIND_NAME, message_data, strid[ kind ] );
    }


    // Z̕\ZbgAbv( З )
    void WazaInfo::SetupWazaDisplay_Power( WazaNo wazano )
    {
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      u16 power = wazadata_system->GetPower( wazano );
      ::app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_POWER_VALUE, power, WAZAPARAM_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaInfo::SetupWazaDisplay_Hit( WazaNo wazano )
    {
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      u16 hit = wazadata_system->GetParam( wazano, pml::wazadata::PARAM_ID_HITPER );
      ::app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_INFO_PANE_WAZA_HIT_VALUE, hit, WAZAPARAM_PLACE_COUNT );
    }


    // Z̕\ZbgAbv(  )
    void WazaInfo::SetupWazaDisplay_Info( WazaNo wazano )
    {
      gfl::str::StrBuf* tempbuf = ::app::util::GetTempStrBuf();
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();
      wazadata_system->GetWazaInfo( wazano, tempbuf );
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_INFO_PANE_WAZA_INFO, tempbuf );
    }






    // Z̈ʒu{^ZbgAbv
    void WazaInfo::SetupWazaPosButtons( void )
    {
      AnimationIndex wpos_anime[ pml::MAX_WAZA_NUM ] = 
      {
        ANIMATION_WAZA_POS_0,
        ANIMATION_WAZA_POS_1,
        ANIMATION_WAZA_POS_2,
        ANIMATION_WAZA_POS_3,
      };

      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      u8 waza_index = this->GetWazaIndex();

      for( u8 i=0; i<pml::MAX_WAZA_NUM; i++ ) 
      {
        WazaNo wazano = pokeparam->GetWazaNo( i );

        if( i == waza_index ) {  // \̋Z
          m_button_manager->SetButtonPassive(i);
          ::app::util::StartAnimation( m_layout_work, wpos_anime[i] );
        }
        else if( wazano == WAZANO_NULL ) {  // ZȂ
          m_button_manager->SetButtonPassive(i);
          ::app::util::StopAnimation( m_layout_work, wpos_anime[i] );
        }
        else {
          m_button_manager->SetButtonActive(i);
          ::app::util::StopAnimation( m_layout_work, wpos_anime[i] );
        }
      } 
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void WazaInfo::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_animation_index = ANIMATION_NULL;
      ::app::util::StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void WazaInfo::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void WazaInfo::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void WazaInfo::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultByCursorPos( selected_button );
            this->StartSelectAnimation( selected_button );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( 
            ui_button->IsTrigger( gfl::ui::BUTTON_A ) || 
            ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) 
        {
          this->SetResultByCursorPos( BUTTON_RETURN );
          this->StartSelectAnimation( BUTTON_RETURN );
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_FINISH;
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }






    // {^Ă邩ǂ𒲂ׂ
    bool WazaInfo::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool WazaInfo::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    WazaInfo::ButtonIndex WazaInfo::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }






    // I\ǂ𒲂ׂ
    bool WazaInfo::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // J[\ʒu, 쌋ʂZbg
    void WazaInfo::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );
    } 


    // ȊIAj[VJn
    void WazaInfo::StartSelectAnimation( ButtonIndex cursor_pos )
    {
      m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
      ::app::util::StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool WazaInfo::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }






  }  // namespace app
}  // namespace btl
