//=======================================================================================
/**
 * @file wazaoboe_Upper.cpp
 * @brief Zo(  )
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <app/util/app_util.h>
#include "wazaoboe_Base.h"
#include "wazaoboe_Upper.h"

#include <message/msg_waza_oboe.h>
#include <arc/arc_def.h>
#include <arc/waza_oboe.gaix>
#include "waza_oboe_upper.h"
#include "waza_oboe_upper_pane.h"


namespace app {
  namespace wazaoboe {


    // q[vTCY
    const u32 Upper::APP_HEAPSIZE    =  0x1000;
    const u32 Upper::DEVICE_HEAPSIZE = 0x30000;

    // ľ
    const u32 Upper::ZUKANNO_PLACE_COUNT = 3; 
    const u32 Upper::WAZAPOWER_PLACE_COUNT = 3;
    const u32 Upper::WAZAHIT_PLACE_COUNT = 3;
    const u32 Upper::PARAMS_PLACE_COUNT = 3;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Upper::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, 0, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),     // scale
      gfl::math::VEC3( 0, 0, 0 ),  // rotate
      1,                           // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Upper::ANIMATION_DATA_TABLE[ Upper::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_POKE_TYPE1 */ LYTRES_WAZA_OBOE_UPPER_WAZA_OBOE_UPPER_POKE_TYPE1_BCLAN,
      /* ANIMATION_DATA_POKE_TYPE2 */ LYTRES_WAZA_OBOE_UPPER_WAZA_OBOE_UPPER_POKE_TYPE2_BCLAN,
      /* ANIMATION_DATA_WAZA_DAMAGE_TYPE */ LYTRES_WAZA_OBOE_UPPER_WAZA_OBOE_UPPER_WAZA_DAMAGE_TYPE_BCLAN,
      /* ANIMATION_DATA_HP_GUAGE */ LYTRES_WAZA_OBOE_UPPER_WAZA_OBOE_UPPER_HP_GAUGE_BCLAN,
    }; 





    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param parent_heap         gpq[v
     * @param parent_device_heap  gpfoCXq[v
     * @param layout_system       `Ɏgp郌CAEgVXe
     */
    //---------------------------------------------------------------------------------
    Upper::Upper( 
        gfl::heap::HeapBase* parent_heap,
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::grp::g2d::LytSys* layout_system ) : 
      Base( 
          parent_heap, HEAPID_WAZAOBOE_UPPER, APP_HEAPSIZE,
          parent_device_heap, HEAPID_WAZAOBOE_UPPER_DEVICE, DEVICE_HEAPSIZE, 
          layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 )
    {
      this->CreateLayoutWork();
      this->SetupDisplay_Strings();

#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_WAZAOBOE_UPPER: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }


    // CAEg[N𐶐
    void Upper::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_WAZAOBOE, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_waza_oboe_waza_oboe_upper_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_OBOE_UPPER_WAZA_OBOE_UPPER_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // ōXV, `悷
    }


    // e핶Zbg
    void Upper::SetupDisplay_Strings( void )
    {
      gfl::str::MsgData* message_data = this->GetMessageData();
      app::util::SetTextboxPaneMessage( m_layout_work,
          PANENAME_WAZA_OBOE_UPPER_PANE_ZUKAN_LABEL, message_data, msg_waza_oboe_01_15 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_NAME_LABEL, message_data, msg_waza_oboe_01_16 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_TYPE_LABEL, message_data, msg_waza_oboe_01_17 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_DMG_LABEL, message_data, msg_waza_oboe_01_18 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_HIT_LABEL, message_data, msg_waza_oboe_01_19 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_ATK_LABEL, message_data, msg_waza_oboe_01_20 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_HP_LABEL, message_data, msg_waza_oboe_01_21 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_ATK_LABEL, message_data, msg_waza_oboe_01_22 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_DEF_LABEL, message_data, msg_waza_oboe_01_23 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_SPATK_LABEL, message_data, msg_waza_oboe_01_24 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_SPDEF_LABEL, message_data, msg_waza_oboe_01_25 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_AGI_LABEL, message_data, msg_waza_oboe_01_26 );
    }





    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    Upper::~Upper()
    {
      this->DeleteLayoutWork();
    }


    // CAEg[Nj
    void Upper::DeleteLayoutWork( void )
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief \eZbg
     * @param pokeparam  \|P
     */
    //---------------------------------------------------------------------------------
    void Upper::SetDisplayParams( const pml::pokepara::PokemonParam* pokeparam )
    {
      this->SetupDisplay_ZukanNo( pokeparam );
      this->SetupDisplay_Name( pokeparam );
      this->SetupDisplay_Type( pokeparam );
      this->SetupDisplay_Params( pokeparam );
    } 


    // }No.Zbg
    void Upper::SetupDisplay_ZukanNo( const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::str::StrBuf* temp_buf = app::util::GetTempStrBuf();
      u32 zukanno = pokeparam->GetMonsNo(); // @todo n}
      app::util::SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_OBOE_UPPER_PANE_ZUKAN_VALUE, 
          zukanno, ZUKANNO_PLACE_COUNT );
    }


    // X^[Zbg
    void Upper::SetupDisplay_Name( const pml::pokepara::PokemonParam* pokeparam )
    {
      MonsNo monsno = pokeparam->GetMonsNo();
      app::util::SetTextboxPaneMonsName( 
          m_layout_work, PANENAME_WAZA_OBOE_UPPER_PANE_NAME_VALUE, monsno );
    }


    // ^CvZbg
    void Upper::SetupDisplay_Type( const pml::pokepara::PokemonParam* pokeparam )
    {
      pml::PokeType type1 = pokeparam->GetType1(); 
      app::util::StartAnimation( m_layout_work, ANIMATION_POKE_TYPE1 );
      app::util::PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE1, false );
      app::util::SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE1, type1 );

      pml::PokeType type2 = pokeparam->GetType2();
      if( type1 == type2 ) {
        app::util::SetPaneInvisible( m_layout_work, PANENAME_WAZA_OBOE_UPPER_PANE_TYPE_02_ICON );
      }
      else {
        app::util::StartAnimation( m_layout_work, ANIMATION_POKE_TYPE2 );
        app::util::PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE2, false );
        app::util::SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE2, type2 );
      }
    }


    // p[^Zbg
    void Upper::SetupDisplay_Params( const pml::pokepara::PokemonParam* pokeparam )
    {
      u32 now_hp = pokeparam->GetHp();
      u32 max_hp = pokeparam->GetPower( pml::pokepara::POWER_HP );
      u32 atk = pokeparam->GetPower( pml::pokepara::POWER_ATK );
      u32 def = pokeparam->GetPower( pml::pokepara::POWER_DEF );
      u32 spatk = pokeparam->GetPower( pml::pokepara::POWER_SPATK );
      u32 spdef = pokeparam->GetPower( pml::pokepara::POWER_SPDEF );
      u32 agi = pokeparam->GetPower( pml::pokepara::POWER_AGI );

      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_MAX_HP_VALUE, max_hp, PARAMS_PLACE_COUNT ); 
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_HP_VALUE, now_hp, PARAMS_PLACE_COUNT ); 
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_ATK_VALUE, atk, PARAMS_PLACE_COUNT );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_DEF_VALUE, def, PARAMS_PLACE_COUNT );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_SPATK_VALUE, spatk, PARAMS_PLACE_COUNT );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_SPDEF_VALUE, spdef, PARAMS_PLACE_COUNT );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_AGI_VALUE, agi, PARAMS_PLACE_COUNT );

      u32 gauge_frame = ::app::tool::Gauge::GetDottoNum( now_hp, max_hp, 100 );  // ő100t[
      app::util::StartAnimation( m_layout_work, ANIMATION_HP_GAUGE );
      app::util::PauseAnimation( m_layout_work, ANIMATION_HP_GAUGE, false );
      app::util::SetAnimationFrame( m_layout_work, ANIMATION_HP_GAUGE, gauge_frame );
    }




    //---------------------------------------------------------------------------------
    /**
     * @brief \eZbg
     * @param wazano     \Z
     */
    //---------------------------------------------------------------------------------
    void Upper::SetDisplayParams( WazaNo wazano )
    {
      this->SetupDisplay_Waza( wazano );
    } 


    // ZZbg
    void Upper::SetupDisplay_Waza( WazaNo wazano )
    {
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();

      // 
      pml::wazadata::WazaDamageType waza_kind = wazadata_system->GetDamageType( wazano );
      app::util::StartAnimation( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE );
      app::util::PauseAnimation( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE, false );
      app::util::SetAnimationFrame( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE, waza_kind );

      // 傭
      u32 atk = ( wazano == WAZANO_NULL ) ? 
        0 : wazadata_system->GetParam( wazano, pml::wazadata::PARAM_ID_POWER );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_ATK_VALUE, atk, WAZAPOWER_PLACE_COUNT ); 

      // ߂イ
      u32 hit = ( wazano == WAZANO_NULL ) ? 
        0 : wazadata_system->GetParam( wazano, pml::wazadata::PARAM_ID_HITPER );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_HIT_VALUE, hit, WAZAHIT_PLACE_COUNT ); 

      // 
      gfl::str::StrBuf* temp_buf = app::util::GetTempStrBuf();
      wazadata_system->GetWazaInfo( wazano, temp_buf );
      app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_OBOE_UPPER_PANE_WAZA_EXPLANATION, temp_buf );
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void Upper::Update( void )
    {
      m_layout_work->Update();
    }


    //---------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //---------------------------------------------------------------------------------
    void Upper::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* upper_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* right_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );

      m_layout_work->Draw( 
          graphics_system, gfl::grp::DISPLAY_UPPER, upper_frame_buff, right_frame_buff );
    }









  }  // namespace wazaoboe
}  // namespace app 
