//========================================================================================
/**
 * @file wazaoboe_Process.cpp
 * @brief ZovZX
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <app/util/app_util.h>
#include <app/waza_oboe/wazaoboe_Process.h>
#include "wazaoboe_Upper.h"
#include "wazaoboe_Lower.h"
#include "wazaoboe_PokemonDrawer.h"


namespace app {
  namespace wazaoboe {



    // VXetHg̃t@C
    const char* Process::SYSTEMFONT_FILENAME = "cbf_std.bcfnt";


    // CAEgVXẽZbgAbvf[^
    const gfl::grp::g2d::LytSysSetUp Process::LYTSYS_SETUP_DATA = 
    {
      128, // Ǘ\[Xő吔
      10,  // ǗCAEg[Nő吔
    }; 





    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    Process::Process( void ) :
      gamesystem::GameProc(),
      m_heap( NULL ),
      m_device_heap( NULL ),
      m_nw_heap_allocator( NULL ),
      m_nw_device_allocator( NULL ),
      m_g3d_system( NULL ),
      m_layout_system( NULL ),
      m_pokeparam( NULL ),
      m_new_wazano( WAZANO_NULL ),
      m_upper( NULL ),
      m_lower( NULL ),
      m_poke_drawer( NULL ),
      m_result( NULL )
    {
    }



    //--------------------------------------------------------------------------------
    // \|Pݒ肷
    //--------------------------------------------------------------------------------
    void Process::SetPokeParam( const pml::pokepara::PokemonParam* pokeparam )
    {
      m_pokeparam = pokeparam;
    }

    //--------------------------------------------------------------------------------
    // VoZݒ肷
    //--------------------------------------------------------------------------------
    void Process::SetNewWazaNo( WazaNo wazano )
    {
      m_new_wazano = wazano;
    }

    //--------------------------------------------------------------------------------
    // Zoʂ̌ʂi[obt@Zbg
    //--------------------------------------------------------------------------------
    void Process::SetResultBuffer( ResultData* dest )
    {
      m_result = dest;
    }




    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    Process::~Process()
    {
    }








    //------------------------------------------------------------------------------------
    // vZX̏
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::InitFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 
      this->InitResult();
      this->CreateHeap();
      this->CreateG3dSystem();
      this->CreateLayoutSystem();
      this->SetupFont();
      app::util::Initialize( m_heap );
      wazaoboe::Base::Initialize( m_heap, m_pokeparam, m_new_wazano );
      this->CreateUpper();
      this->CreateLower();
      this->CreatePokemonDrawer();
      m_upper->SetDisplayParams( m_pokeparam );
      m_upper->SetDisplayParams( m_lower->GetCursorPosWazaNo() );
      return gfl::proc::RES_FINISH;
    }


    // ʂ
    void Process::InitResult( void )
    {
      if( m_result ) {
        m_result->waza_removed = false;
        m_result->removed_waza_index = 0;
      }
    }


    // q[v쐬
    void Process::CreateHeap( void )
    {
      gfl::heap::HeapBase* parent_heap = 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* parent_device_heap = 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ); 
      size_t app_heap_size = parent_heap->GetTotalAllocatableSize();
      size_t dev_heap_size = parent_device_heap->GetTotalAllocatableSize();
      m_heap = gfl::heap::Manager::CreateHeap( 
          parent_heap, HEAPID_WAZAOBOE, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      m_device_heap = gfl::heap::Manager::CreateHeap( 
          parent_device_heap, HEAPID_WAZAOBOE_DEVICE, dev_heap_size, gfl::heap::HEAP_TYPE_EXP );
      m_nw_heap_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_heap );
      m_nw_device_allocator = GFL_NEW( m_device_heap ) gfl::heap::NwAllocator( m_device_heap );
    }



    // G3D VXe𐶐
    void Process::CreateG3dSystem( void )
    {
      GFL_ASSERT( m_g3d_system == NULL );
      m_g3d_system = GFL_NEW( m_heap ) 
        gfl::grp::g3d::System( m_nw_heap_allocator, m_nw_device_allocator );
    }


    // CAEgVXe𐶐
    void Process::CreateLayoutSystem( void )
    {
      GFL_ASSERT( m_layout_system == NULL );
      m_layout_system = GFL_NEW( m_heap ) 
        gfl::grp::g2d::LytSys( &LYTSYS_SETUP_DATA, m_nw_heap_allocator, m_nw_device_allocator );
    }


    // tHg̃ZbgAbv
    void Process::SetupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Initialize( m_device_heap );
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), SYSTEMFONT_FILENAME );
    }


    // ʊǗIuWFNg𐶐
    void Process::CreateUpper( void )
    {
      m_upper = GFL_NEW( m_heap ) 
        wazaoboe::Upper( m_heap, m_device_heap, m_layout_system );
    }


    // ʊǗIuWFNg𐶐
    void Process::CreateLower( void )
    {
      m_lower = GFL_NEW( m_heap ) 
        wazaoboe::Lower( m_heap, m_device_heap, m_layout_system );
    }


    // |P`NX𐶐
    void Process::CreatePokemonDrawer( void )
    {
      MonsNo monsno = m_pokeparam->GetMonsNo();
      m_poke_drawer = GFL_NEW( m_heap )
        wazaoboe::PokemonDrawer( m_heap, m_device_heap, m_layout_system );
    }









    //------------------------------------------------------------------------------------
    // vZX̏I
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::EndFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 
      this->DeletePokemonDrawer();
      this->DeleteLower();
      this->DeleteUpper();
      wazaoboe::Base::Finalize();
      app::util::Finalize();
      this->CleanupFont();
      this->DeleteLayoutSystem();
      this->DeleteG3dSystem();
      this->DeleteHeap();
      return gfl::proc::RES_FINISH;
    } 


    // |P`NXj
    void Process::DeletePokemonDrawer( void )
    {
      GFL_DELETE m_poke_drawer;
    }


    // ʊǗIuWFNgj
    void Process::DeleteLower( void )
    {
      GFL_DELETE m_lower;
    }


    // ʊǗIuWFNgj
    void Process::DeleteUpper( void )
    {
      GFL_DELETE m_upper;
    }


    // tHǧЕt
    void Process::CleanupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Terminate();
    } 


    // CAEgVXej
    void Process::DeleteLayoutSystem( void )
    {
      GFL_ASSERT( m_layout_system );
      GFL_DELETE m_layout_system; 
    } 


    // G3DVXej
    void Process::DeleteG3dSystem( void )
    {
      GFL_ASSERT( m_g3d_system );
      GFL_DELETE m_g3d_system; 
    }


    // q[v
    void Process::DeleteHeap( void )
    {
      GFL_DELETE m_nw_heap_allocator;
      GFL_DELETE m_nw_device_allocator;
      gfl::heap::Manager::DeleteHeap( m_heap );
      gfl::heap::Manager::DeleteHeap( m_device_heap );
    }











    //------------------------------------------------------------------------------------
    // vZX̍XV
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::UpdateFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 

      m_lower->Update(); 
      m_upper->Update(); 
      m_poke_drawer->Update(); 
      m_layout_system->UpdateAll();

      if( m_lower->GetControlCode() == Lower::CONTROL_CODE_CURSOR_MOVE ) {  // J[\ړ
        WazaNo wazano = m_lower->GetCursorPosWazaNo();
        m_upper->SetDisplayParams( wazano );
      }

      if( m_lower->IsFinished() ) { // ʂ̏I
        this->PutResult();
        return gfl::proc::RES_FINISH;
      }
      return gfl::proc::RES_CONTINUE;
    }


    // vZX̌ʂZbg
    void Process::PutResult( void ) 
    {
      if( m_result ) {
        Lower::Result lower_result = m_lower->GetResult();
        m_result->waza_removed = ( lower_result == Lower::RESULT_SELECT );
        m_result->removed_waza_index = m_lower->GetSelectedWazaIndex();
      }
    }





    //------------------------------------------------------------------------------------
    // vZX̕`揈
    //------------------------------------------------------------------------------------
    void Process::DrawFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager );

      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gfl::grp::GraphicsSystem* graphics_system = game_manager->GetGraphicsSystem();

      gfl::grp::RenderTarget* upper_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* right_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      gfl::grp::RenderTarget* lower_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

      m_layout_system->DrawAll( 
          graphics_system, gfl::grp::DISPLAY_UPPER, upper_frame_buff, right_frame_buff );
      m_layout_system->DrawAll( 
          graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buff );

      m_poke_drawer->Draw();
      m_upper->Draw();
      m_lower->Draw();
    }





  } // namespace wazaoboe
} // namespace app
