//=======================================================================================
/**
 * @file wazaoboe_Lower.h
 * @brief Zo(  )
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=======================================================================================
#ifndef __WAZAOBOELOWER_H__
#define __WAZAOBOELOWER_H__
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "wazaoboe_Base.h"


namespace app {
  namespace wazaoboe {


    class Lower : public Base
    {
      GFL_FORBID_COPY_AND_ASSIGN( Lower );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param parent_heap         gpq[v
       * @param parent_device_heap  gpfoCXq[v
       * @param layout_system       `Ɏgp郌CAEgVXe
       */
      //---------------------------------------------------------------------------------
      Lower( 
          gfl::heap::HeapBase* parent_heap,
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::grp::g2d::LytSys* layout_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~Lower(); 

      //---------------------------------------------------------------------------------
      /**
       * @brief J[\ĂZԍ擾
       */
      //---------------------------------------------------------------------------------
      WazaNo GetCursorPosWazaNo( void ) const; 

      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //---------------------------------------------------------------------------------
      virtual void Update( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief XV̌ʂ擾
       */
      //---------------------------------------------------------------------------------
      enum ControlCode {
        CONTROL_CODE_NONE,         // Ȃ
        CONTROL_CODE_CURSOR_MOVE,  // J[\ړ
      };
      ControlCode GetControlCode( void ) const;

      //---------------------------------------------------------------------------------
      /**
       * @brief `揈
       */
      //---------------------------------------------------------------------------------
      virtual void Draw( void );




      //---------------------------------------------------------------------------------
      /**
       * @brief 쌋ʂ擾
       */
      //---------------------------------------------------------------------------------
      enum Result {
        RESULT_CANCEL,  // LZ
        RESULT_SELECT,  // YꂳZI
        RESULT_NULL,
      };
      Result GetResult( void ) const;
      u8 GetSelectedWazaIndex( void ) const;





      private:


      // V[PX
      enum Sequence {
        SEQ_SELECT_WAIT,    // ZI( ͑҂ )
        SEQ_CONFIRM_WAIT,   // mF( ͑҂ )
        SEQ_ANIME_WAIT,     // Aj[V҂
        SEQ_MESSAGE,        // bZ[W\
        SEQ_FINISH,         // I
      };


      // {^
      enum ButtonGroup {
        BUTTON_GROUP_TOUCH,   // ^b`o[̃{^
        BUTTON_GROUP_WAZA,    // Z{^
        BUTTON_GROUP_CONFIRM, // mF{^
        BUTTON_GROUP_NUM,
      };


      // {^ԍ( BUTTON_GROUP_WAZA )
      enum WazaButtonIndex {
        WAZA_BUTTON_WAZA0,   // 莝Z0
        WAZA_BUTTON_WAZA1,   // 莝Z1
        WAZA_BUTTON_WAZA2,   // 莝Z2
        WAZA_BUTTON_WAZA3,   // 莝Z3
        WAZA_BUTTON_NEW,     // VoZ
        WAZA_BUTTON_NUM,
      }; 

      // {^ԍ( BUTTON_GROUP_CONFIRM )
      enum ConfirmButtonIndex {
        CONFIRM_BUTTON_FORGET,  //uYꂳIv
        CONFIRM_BUTTON_NUM,
      };

      // {^ԍ( BUTTON_GROUP_TOUCH )
      enum TouchButtonIndex {
        TOUCH_BUTTON_UP,       // 
        TOUCH_BUTTON_DOWN,     // 
        TOUCH_BUTTON_RETURN,   //u߂v
        TOUCH_BUTTON_NUM,
      };

      static const u32 TOTAL_BUTTON_NUM = 
        WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_NUM;


      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_STATUS_NORMAL,
        ANIMATION_DATA_STATUS_MAHI,
        ANIMATION_DATA_STATUS_NEMURI,
        ANIMATION_DATA_STATUS_KOORI,
        ANIMATION_DATA_STATUS_YAKEDO,
        ANIMATION_DATA_STATUS_DOKU,
        ANIMATION_DATA_STATUS_POKERUS,
        ANIMATION_DATA_CURSOR_ON_WAZA0,
        ANIMATION_DATA_CURSOR_ON_WAZA1,
        ANIMATION_DATA_CURSOR_ON_WAZA2,
        ANIMATION_DATA_CURSOR_ON_WAZA3,
        ANIMATION_DATA_CURSOR_ON_WAZA4,
        ANIMATION_DATA_DUMMY_WAZATYPE,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_UP_BUTTON_ACTIVE,
        ANIMATION_DATA_UP_BUTTON_PASSIVE,
        ANIMATION_DATA_DOWN_BUTTON_ACTIVE,
        ANIMATION_DATA_DOWN_BUTTON_PASSIVE,
        ANIMATION_DATA_SCENE_SELECT,
        ANIMATION_DATA_SCENE_CONFIRM,
        ANIMATION_DATA_SCENE_MESSAGE,
        ANIMATION_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_STATUS_NORMAL,
        ANIMATION_STATUS_MAHI,
        ANIMATION_STATUS_NEMURI,
        ANIMATION_STATUS_KOORI,
        ANIMATION_STATUS_YAKEDO,
        ANIMATION_STATUS_DOKU,
        ANIMATION_STATUS_POKERUS,
        ANIMATION_CURSOR_ON_WAZA0,
        ANIMATION_CURSOR_ON_WAZA1,
        ANIMATION_CURSOR_ON_WAZA2,
        ANIMATION_CURSOR_ON_WAZA3,
        ANIMATION_CURSOR_ON_WAZA4,
        ANIMATION_DUMMY_WAZATYPE,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BUTTON_RELEASE,
        ANIMATION_DUMMY_BUTTON_SELECT,
        ANIMATION_UP_BUTTON_ACTIVE,
        ANIMATION_UP_BUTTON_PASSIVE,
        ANIMATION_DOWN_BUTTON_ACTIVE,
        ANIMATION_DOWN_BUTTON_PASSIVE,
        ANIMATION_SCENE_SELECT,
        ANIMATION_SCENE_CONFIRM,
        ANIMATION_SCENE_MESSAGE,
        // ȉ, LAj[V
        ANIMATION_WAZATYPE,
        ANIMATION_BUTTON_HOLD = ANIMATION_WAZATYPE + WAZA_BUTTON_NUM,
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + TOTAL_BUTTON_NUM, 
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + TOTAL_BUTTON_NUM,
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + TOTAL_BUTTON_NUM,
        ANIMATION_NULL,
      }; 


      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_WAZATYPE,
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[V
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation;            // ꂽۂ̃Aj[V
        AnimationIndex release_animation;         // ꂽۂ̃Aj[V
        AnimationIndex select_animation;          // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation;          // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation;         // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation;          // J[\ZbgAj[V
      };


      // Z{^Ƃ̐ݒ
      struct WazaButtonDesc {
        u8 waza_index;
        gfl::grp::g2d::LytPaneIndex name_pane;
        gfl::grp::g2d::LytPaneIndex max_pp_pane;
        gfl::grp::g2d::LytPaneIndex now_pp_pane;
        AnimationIndex type_animation;
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE; 
      static const u32 LV_PLACE_COUNT;
      static const u32 PP_PLACE_COUNT;
      static const u16 MESSAGE_LINES = 2;  // bZ[W̍s
      static const gfl::grp::g2d::LytPaneIndex MESSAGE_LINES_PANE[ MESSAGE_LINES ];
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ WAZA_BUTTON_NUM ];
      static const ButtonDesc BUTTON_DESC_WAZA[ WAZA_BUTTON_NUM ];
      static const ButtonDesc BUTTON_DESC_CONFIRM[ CONFIRM_BUTTON_NUM ];
      static const ButtonDesc BUTTON_DESC_TOUCH[ TOUCH_BUTTON_NUM ];
      static const WazaButtonDesc WAZA_BUTTON_DESC[ WAZA_BUTTON_NUM ];
      static const gfl::grp::g2d::LytPaneIndex BOXMARK_PANE[ pml::pokepara::BOX_MARK_NUM ];
      static const AnimationIndex SICK_ANIMATION[ pml::pokepara::SICK_MAX ];


      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id; 
      tool::ButtonManager* m_button_manager[ BUTTON_GROUP_NUM ];
      tool::CursorManager* m_cursor_manager;
      print::MsgWin* m_message_window;

      ControlCode m_control_code;
      Result m_result;
      u8 m_selected_waza_index;
      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation_index;




      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void CreateMessageWindow( void );

      void SetupButtonManager( void ); 
      void InitializeCursorPos( void );

      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );
      void DeleteMessageWindow( void );

      void SetupDisplay( void );
      void SetupParamDisplay_Name( void );
      void SetupParamDisplay_Sex( void );
      void SetupParamDisplay_Level( void );
      void SetupParamDisplay_Status( void );
      void SetupParamDisplay_Item( void );
      void SetupParamDisplay_BoxMark( void );
      void SetupParamDisplay_RareIcon( void );
      void SetupParamDisplay_AntiPokerusIcon( void ); 
      void SetupWazaButtonDisplay( WazaButtonIndex button_index );
      void SetupWazaButtonDisplay_Name( WazaButtonIndex button_index );
      void SetupWazaButtonDisplay_Type( WazaButtonIndex button_index );
      void SetupWazaButtonDisplay_PP( WazaButtonIndex button_index );
      void SetStrings( void );

      void UpdateSequence( void );
      void ChangeSeq( Sequence seq, Sequence next_seq = SEQ_FINISH );
      bool IsButtonHolding( ButtonGroup button_group ) const;
      bool IsButtonSelected( ButtonGroup button_group ) const;
      WazaButtonIndex GetSelectedButton( void ) const;
      TouchButtonIndex GetSelectedTouchButton( void ) const;
      bool IsSelectEnable( WazaButtonIndex button_index ) const;
      bool IsSelectEnable( TouchButtonIndex button_index ) const;
      void CursorMoveUp( void );
      void CursorMoveDown( void );
      void CursorMoveTo( WazaButtonIndex new_pos );
      void OnCursorMoved( WazaButtonIndex old_pos, WazaButtonIndex new_pos );
      void StartCursorMoveAnimation( WazaButtonIndex old_pos, WazaButtonIndex new_pos );
      WazaButtonIndex GetCurrentCursorPos( void ) const;
      WazaButtonIndex GetPrevCursorPos( void ) const;
      bool UpdateCursorMove( void );
      bool IsAnimationFinished( void ) const;

      void StartMessageStream( void );
      bool UpdateMessageStream( void );
    };


  }  // namespace wazaoboe
}  // namespace app 


#endif  // __WAZAOBOELOWER_H__
