//=======================================================================================
/**
 * @file wazaoboe_Lower.cpp
 * @brief Zo(  )
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=======================================================================================
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "wazaoboe_Lower.h"

#include <message/msg_waza_oboe.h>
#include <arc/arc_def.h>
#include <arc/waza_oboe.gaix>
#include "waza_oboe_lower.h"
#include "waza_oboe_lower_pane.h"



namespace app {
  namespace wazaoboe {


    // q[vTCY
    const u32 Lower::APP_HEAPSIZE    =  0x2000;
    const u32 Lower::DEVICE_HEAPSIZE = 0xa0000;

    // ľ
    const u32 Lower::LV_PLACE_COUNT = 3;
    const u32 Lower::PP_PLACE_COUNT = 2;


    // bZ[W̊esɎgpyC
    const gfl::grp::g2d::LytPaneIndex Lower::MESSAGE_LINES_PANE[ Lower::MESSAGE_LINES ] =
    {
      PANENAME_WAZA_OBOE_LOWER_PANE_MSG_LINE1,
      PANENAME_WAZA_OBOE_LOWER_PANE_MSG_LINE2,
    };


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Lower::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, -290, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),     // rotate
      1,                              // priority
    };



    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Lower::ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_STATUS_NORMAL */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_NORMAL_BCLAN,
      /* ANIMATION_DATA_STATUS_MAHI */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_MAHI_BCLAN,
      /* ANIMATION_DATA_STATUS_NEMURI */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_NEMURI_BCLAN,
      /* ANIMATION_DATA_STATUS_KOORI */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_KOORI_BCLAN,
      /* ANIMATION_DATA_STATUS_YAKEDO */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_YAKEDO_BCLAN,
      /* ANIMATION_DATA_STATUS_DOKU */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_DOKU_BCLAN,
      /* ANIMATION_DATA_STATUS_POKERUS */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_STATUS_POKERUS_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA0 */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_CURSOR_ON_WAZA0_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA1 */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_CURSOR_ON_WAZA1_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA2 */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_CURSOR_ON_WAZA2_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA3 */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_CURSOR_ON_WAZA3_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA4 */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_CURSOR_ON_WAZA4_BCLAN,
      /* ANIMATION_DATA_DUMMY_WAZATYPE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DUMMY_WAZATYPE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_UP_BUTTON_ACTIVE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_UP_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_UP_BUTTON_PASSIVE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_UP_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_DOWN_BUTTON_ACTIVE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DOWN_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_DOWN_BUTTON_PASSIVE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_DOWN_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_SCENE_SELECT */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_SCENE_SELECT_BCLAN,
      /* ANIMATION_DATA_SCENE_CONFIRM */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_SCENE_CONFIRM_BCLAN,
      /* ANIMATION_DATA_SCENE_MESSAGE */ LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_SCENE_MESSAGE_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const Lower::ShareAnimationDesc Lower::SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_WAZATYPE */
      {
        ANIMATION_WAZATYPE,
        ANIMATION_DATA_DUMMY_WAZATYPE,
        WAZA_BUTTON_NUM,
        PANENAME_WAZA_OBOE_LOWER_GROUP_WAZATYPE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_HOLD */ 
      {
        ANIMATION_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_OBOE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_RELEASE */ 
      {
        ANIMATION_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_OBOE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_SELECT */ 
      {
        ANIMATION_BUTTON_SELECT,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_OBOE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // J[\ړf[^
    const tool::CursorManager::MOVE_DATA Lower::CURSOR_MOVE_DATA[ WAZA_BUTTON_NUM ] = 
    {
      /*   id              up                 down              left              right  */
      { WAZA_BUTTON_WAZA0,  { WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA0 } },
      { WAZA_BUTTON_WAZA1,  { WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA2,  WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA1 } },
      { WAZA_BUTTON_WAZA2,  { WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA3,  WAZA_BUTTON_WAZA2,  WAZA_BUTTON_WAZA2 } },
      { WAZA_BUTTON_WAZA3,  { WAZA_BUTTON_WAZA2,  WAZA_BUTTON_NEW,    WAZA_BUTTON_WAZA3,  WAZA_BUTTON_WAZA3 } },
      { WAZA_BUTTON_NEW,    { WAZA_BUTTON_WAZA3,  WAZA_BUTTON_NEW,    WAZA_BUTTON_NEW,    WAZA_BUTTON_NEW } },
    };





    // {^Ƃ̐ݒ( BUTTON_GROUP_WAZA )
    const Lower::ButtonDesc Lower::BUTTON_DESC_WAZA[ WAZA_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_WAZA0 */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_W0_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA0,
      },
      /* WAZA_BUTTON_WAZA1 */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_W1_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA1,
      },
      /* WAZA_BUTTON_WAZA2 */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_W2_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA2,
      },
      /* WAZA_BUTTON_WAZA3 */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_W3_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA3,
      },
      /* WAZA_BUTTON_NEW */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_W4_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NEW ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NEW ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NEW ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA4,
      },
    };




    // {^Ƃ̐ݒ( BUTTON_GROUP_CONFIRM )
    const Lower::ButtonDesc Lower::BUTTON_DESC_CONFIRM[ Lower::CONFIRM_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_FORGET */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_FORGET_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };




    // {^Ƃ̐ݒ( BUTTON_GROUP_TOUCH )
    const Lower::ButtonDesc Lower::BUTTON_DESC_TOUCH[ TOUCH_BUTTON_NUM ] = 
    {
      /* TOUCH_BUTTON_UP */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_UP_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        ANIMATION_UP_BUTTON_ACTIVE,
        ANIMATION_UP_BUTTON_PASSIVE,
        ANIMATION_NULL,
      },
      /* TOUCH_BUTTON_DOWN */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_DOWN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        ANIMATION_DOWN_BUTTON_ACTIVE,
        ANIMATION_DOWN_BUTTON_PASSIVE,
        ANIMATION_NULL,
      },
      /* TOUCH_BUTTON_RETURN */ 
      {
        PANENAME_WAZA_OBOE_LOWER_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };





    // Z{^Ƃ̐ݒ
    const Lower::WazaButtonDesc Lower::WAZA_BUTTON_DESC[ Lower::WAZA_BUTTON_NUM ] =
    {
      /* WAZA_BUTTON_WAZA0 */
      {
        0,
        PANENAME_WAZA_OBOE_LOWER_PANE_W0_NAME_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W0_MAX_PP_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W0_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA0 ),
      },
      /* WAZA_BUTTON_WAZA1 */
      {
        1,
        PANENAME_WAZA_OBOE_LOWER_PANE_W1_NAME_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W1_MAX_PP_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W1_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA1 ),
      },
      /* WAZA_BUTTON_WAZA2 */
      {
        2,
        PANENAME_WAZA_OBOE_LOWER_PANE_W2_NAME_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W2_MAX_PP_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W2_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA2 ),
      },
      /* WAZA_BUTTON_WAZA3 */
      {
        3,
        PANENAME_WAZA_OBOE_LOWER_PANE_W3_NAME_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W3_MAX_PP_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W3_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA3 ),
      },
      /* WAZA_BUTTON_NEW */
      {
        0,  // dummy
        PANENAME_WAZA_OBOE_LOWER_PANE_W4_NAME_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W4_MAX_PP_VALUE,
        PANENAME_WAZA_OBOE_LOWER_PANE_W4_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_NEW ),
      },
    };





    // {bNX}[ÑyC
    const gfl::grp::g2d::LytPaneIndex Lower::BOXMARK_PANE[ pml::pokepara::BOX_MARK_NUM ] = 
    {
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_00,
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_01,
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_02,
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_03,
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_04,
      PANENAME_WAZA_OBOE_LOWER_PANE_BOX_MARK_05,
    };



    // ԈُɑΉAj[Vԍ
    const Lower::AnimationIndex Lower::SICK_ANIMATION[ pml::pokepara::SICK_MAX ] =
    {
      ANIMATION_STATUS_NORMAL,
      ANIMATION_STATUS_MAHI,
      ANIMATION_STATUS_NEMURI,
      ANIMATION_STATUS_KOORI,
      ANIMATION_STATUS_YAKEDO,
      ANIMATION_STATUS_DOKU,
    };






    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    Lower::Lower( 
        gfl::heap::HeapBase* parent_heap,
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::grp::g2d::LytSys* layout_system ) :
      Base( 
          parent_heap, HEAPID_WAZAOBOE_LOWER, APP_HEAPSIZE,
          parent_device_heap, HEAPID_WAZAOBOE_LOWER_DEVICE, DEVICE_HEAPSIZE,
          layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager(),
      m_cursor_manager( NULL ),
      m_message_window( NULL ),
      m_control_code( CONTROL_CODE_NONE ),
      m_result( RESULT_NULL ),
      m_selected_waza_index( 0 ),
      m_seq( SEQ_SELECT_WAIT ),
      m_next_seq( SEQ_SELECT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      for( u8 i=0; i<BUTTON_GROUP_NUM; i++ ) {
        m_button_manager[i] = NULL;
      }
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
      this->CreateMessageWindow();
      this->InitializeCursorPos(); 
      this->SetupDisplay();

#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_WAZAOBOE_LOWER: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // CAEg[N𐶐
    void Lower::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_WAZAOBOE, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_waza_oboe_waza_oboe_lower_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_OBOE_LOWER_WAZA_OBOE_LOWER_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // ōXV, `悷
    }



    // VFAAj[V𐶐
    void Lower::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }



    // J[\}l[W𐶐
    void Lower::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, WAZA_BUTTON_NUM, heap, 0 );
    }



    // {^}l[W𐶐
    void Lower::CreateButtonManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap(); 
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      m_button_manager[ BUTTON_GROUP_WAZA ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, WAZA_BUTTON_NUM, ANIMATION_NULL );
      m_button_manager[ BUTTON_GROUP_CONFIRM ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, CONFIRM_BUTTON_NUM, ANIMATION_NULL );
      m_button_manager[ BUTTON_GROUP_TOUCH ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, TOUCH_BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[W̃ZbgAbv
    void Lower::SetupButtonManager( void )
    {
      for( u32 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_WAZA[i];
        m_button_manager[ BUTTON_GROUP_WAZA ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }

      for( u32 i=0; i<CONFIRM_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_CONFIRM[i];
        m_button_manager[ BUTTON_GROUP_CONFIRM ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }

      for( u32 i=0; i<TOUCH_BUTTON_NUM; i++ ) {
        TouchButtonIndex button_index = static_cast<TouchButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_TOUCH[i];
        m_button_manager[ BUTTON_GROUP_TOUCH ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }
    }


    // bZ[WEBhE𐶐
    void Lower::CreateMessageWindow( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      m_message_window = GFL_NEW( heap ) 
        print::MsgWin( ui_device_manager, m_layout_work, MESSAGE_LINES, 0, heap );
      for( u16 i=0; i<MESSAGE_LINES; i++ ) {
        m_message_window->AddLinePaneIdx( MESSAGE_LINES_PANE[i] );
      }
    }


    // J[\ʒu
    void Lower::InitializeCursorPos( void )
    {
      WazaButtonIndex cursor_pos = WAZA_BUTTON_WAZA0;
      m_cursor_manager->SetPos( cursor_pos );
      app::util::StartAnimation( m_layout_work, BUTTON_DESC_WAZA[ cursor_pos ].cursor_animation );
    }






    // \XV
    void Lower::SetupDisplay( void )
    {
      this->SetupParamDisplay_Name();
      this->SetupParamDisplay_Sex();
      this->SetupParamDisplay_Level();
      this->SetupParamDisplay_Status();
      this->SetupParamDisplay_Item();
      this->SetupParamDisplay_BoxMark();
      this->SetupParamDisplay_RareIcon();
      this->SetupParamDisplay_AntiPokerusIcon();
      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        this->SetupWazaButtonDisplay( static_cast<WazaButtonIndex>(i) );
      }
      this->SetStrings();
    }


    // O̕\XV
    void Lower::SetupParamDisplay_Name( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      gfl::str::StrBuf* temp_buf = app::util::GetTempStrBuf();
      pokeparam->GetNickName( temp_buf );
      app::util::SetTextboxPaneString( m_layout_work, 
          PANENAME_WAZA_OBOE_LOWER_PANE_NICKNAME_VALUE, temp_buf );
    }


    // ʂ̕\XV
    void Lower::SetupParamDisplay_Sex( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      pml::Sex sex = pokeparam->GetSex();
      app::util::SetTextboxPaneSex( 
          m_layout_work, PANENAME_WAZA_OBOE_LOWER_PANE_SEX_VALUE, sex ); 
    }


    // x̕\XV
    void Lower::SetupParamDisplay_Level( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      u32 level = pokeparam->GetLevel();
      app::util::SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_OBOE_LOWER_PANE_LEVEL_VALUE, level, LV_PLACE_COUNT );
    }


    // Xe[^XACR̕\XV
    void Lower::SetupParamDisplay_Status( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      AnimationIndex anime = ANIMATION_NULL;
      if( pokeparam->HavePokerusJustNow() ) {
        anime = ANIMATION_STATUS_POKERUS;  // Ԉُł|PXD
      }
      else {
        pml::pokepara::Sick sick = pokeparam->GetSick();
        anime = SICK_ANIMATION[ sick ];
      }
      app::util::StartAnimation( m_layout_work, anime );
    }


    // ACe̕\XV
    void Lower::SetupParamDisplay_Item( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::str::StrBuf* temp_buf = app::util::GetTempStrBuf();

      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      u16 itemno = pokeparam->GetParam( pml::pokepara::PARAM_ID_item );
      if( ITEM_DATA_MAX < itemno ) { itemno = 0; }
      item::ITEM_DATA item_data( itemno, heap ); 
      item_data.ITEM_GetItemName( temp_buf, heap );
      app::util::SetTextboxPaneString( m_layout_work, 
          PANENAME_WAZA_OBOE_LOWER_PANE_ITEM_VALUE, temp_buf );
    }


    // {bNX}[N̕\XV
    void Lower::SetupParamDisplay_BoxMark( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      u32 boxmark_value = pokeparam->GetParam( pml::pokepara::PARAM_ID_box_mark );
      for( u32 i=0; i<pml::pokepara::BOX_MARK_NUM; i++ ) {
        u32 check_bit = 1 << i;
        bool visibility = ( ( boxmark_value & check_bit ) != 0 );
        app::util::SetPaneVisibility( m_layout_work, BOXMARK_PANE[i], visibility );
      }
    }


    // AACR̕\XV
    void Lower::SetupParamDisplay_RareIcon( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      bool is_rare = pokeparam->IsRare();
      app::util::SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_OBOE_LOWER_PANE_RARE_ICON, is_rare );
    }


    // |PXR̃ACR̕\XV
    void Lower::SetupParamDisplay_AntiPokerusIcon( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      bool icon_visibility = pokeparam->HavePokerusUntilNow();
      app::util::SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_OBOE_LOWER_PANE_ANTI_POKERUS_ICN, icon_visibility );
    }




    // Z{^̕\XV
    void Lower::SetupWazaButtonDisplay( WazaButtonIndex button_index )
    {
      this->SetupWazaButtonDisplay_Name( button_index );
      this->SetupWazaButtonDisplay_Type( button_index );
      this->SetupWazaButtonDisplay_PP( button_index );
    }


    // Z̕\XV
    void Lower::SetupWazaButtonDisplay_Name( WazaButtonIndex button_index )
    {
      gfl::str::StrBuf* temp_buf = app::util::GetTempStrBuf();
      WazaNo wazano = WAZANO_NULL;
      if( button_index == WAZA_BUTTON_NEW ) {
        wazano = this->GetNewWazaNo();
      }
      else {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
        u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
        wazano = pokeparam->GetWazaNo( waza_index );
      }
      pml::System::WazaDataSystem()->GetWazaName( wazano, temp_buf );
      app::util::SetTextboxPaneString( 
          m_layout_work, WAZA_BUTTON_DESC[ button_index ].name_pane, temp_buf );
    }


    // Z^Cv̕\XV
    void Lower::SetupWazaButtonDisplay_Type( WazaButtonIndex button_index )
    {
      WazaNo wazano = WAZANO_NULL;
      if( button_index == WAZA_BUTTON_NEW ) {
        wazano = this->GetNewWazaNo();
      }
      else {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
        u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
        wazano = pokeparam->GetWazaNo( waza_index );
      }
      pml::PokeType type = pml::System::WazaDataSystem()->GetType( wazano );
      AnimationIndex anime = WAZA_BUTTON_DESC[ button_index ].type_animation;
      app::util::StartAnimation( m_layout_work, anime );
      app::util::PauseAnimation( m_layout_work, anime, false );
      app::util::SetAnimationFrame( m_layout_work, anime, type );
    }


    // PPl̕\XV
    void Lower::SetupWazaButtonDisplay_PP( WazaButtonIndex button_index )
    {
      u8 max_pp = 0;
      u8 now_pp = 0;
      if( button_index == WAZA_BUTTON_NEW ) {
        WazaNo wazano = this->GetNewWazaNo();
        max_pp = pml::System::WazaDataSystem()->GetMaxPP( wazano, 0 );
        now_pp = max_pp;
      }
      else {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
        u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
        max_pp = pokeparam->GetWazaMaxPP( waza_index );
        now_pp = pokeparam->GetWazaPP( waza_index );
      }
      app::util::SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ button_index ].max_pp_pane, max_pp, PP_PLACE_COUNT );
      app::util::SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ button_index ].now_pp_pane, now_pp, PP_PLACE_COUNT );
    }




    // e탁bZ[WZbg
    void Lower::SetStrings( void )
    {
      gfl::str::MsgData* message_data = this->GetMessageData();
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_LOWER_PANE_FORGET_LABEL, message_data, msg_waza_oboe_01_13 );
      app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_WAZA_OBOE_LOWER_PANE_ITEM_NAME, message_data, msg_waza_oboe_01_14 );
    }








    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    Lower::~Lower()
    {
      this->DeleteMessageWindow();
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
    } 


    // bZ[WEBhEj
    void Lower::DeleteMessageWindow( void )
    {
      if( m_message_window ) {
        GFL_DELETE m_message_window;
      }
    }


    // J[\}l[Wj
    void Lower::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void Lower::DeleteButtonManager( void )
    {
      for( u8 i=0; i<BUTTON_GROUP_NUM; i++ ) {
        if( m_button_manager[i] ) {
          GFL_DELETE m_button_manager[i];
        }
      }
    }


    // CAEg[Nj
    void Lower::DeleteLayoutWork( void )
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }










    //---------------------------------------------------------------------------------
    // `揈
    //---------------------------------------------------------------------------------
    void Lower::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }





    //---------------------------------------------------------------------------------
    // J[\ĂZԍ擾
    //---------------------------------------------------------------------------------
    WazaNo Lower::GetCursorPosWazaNo( void ) const
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      WazaButtonIndex cursor_pos = this->GetCurrentCursorPos();
      if( cursor_pos == WAZA_BUTTON_NEW ) {
        return this->GetNewWazaNo();
      }
      else {
        return pokeparam->GetWazaNo( cursor_pos );
      }
    } 

    //---------------------------------------------------------------------------------
    // 쌋ʂ擾
    //---------------------------------------------------------------------------------
    Lower::Result Lower::GetResult( void ) const
    {
      return m_result;
    } 

    //---------------------------------------------------------------------------------
    // IꂽZ̃CfbNX擾
    //---------------------------------------------------------------------------------
    u8 Lower::GetSelectedWazaIndex( void ) const
    {
      return m_selected_waza_index;
    }

    //---------------------------------------------------------------------------------
    // XV̌ʂ擾
    //---------------------------------------------------------------------------------
    Lower::ControlCode Lower::GetControlCode( void ) const
    {
      return m_control_code;
    }


    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void Lower::Update( void )
    {
      m_layout_work->Update();
      this->UpdateSequence();
    } 



    // V[PX
    void Lower::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      m_control_code = CONTROL_CODE_NONE;

      switch( m_seq )
      {
      case SEQ_SELECT_WAIT:
        m_button_manager[ BUTTON_GROUP_TOUCH ]->Update();
        m_button_manager[ BUTTON_GROUP_WAZA ]->Update();
        if( this->IsButtonSelected( BUTTON_GROUP_WAZA ) ) {
          WazaButtonIndex selected_button = this->GetSelectedButton();
          if( this->IsSelectEnable( selected_button ) ) {
            if( selected_button == WAZA_BUTTON_NEW ) {
              m_wait_animation_index = BUTTON_DESC_WAZA[ WAZA_BUTTON_NEW ].select_animation;
              app::util::StartAnimation( m_layout_work, m_wait_animation_index );
              this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
              m_result = RESULT_CANCEL;
            }
            else {
              m_control_code = CONTROL_CODE_CURSOR_MOVE;
              m_selected_waza_index = selected_button;
              this->CursorMoveTo( selected_button );
              this->ChangeSeq( SEQ_CONFIRM_WAIT );
            }
          }
        }
        else if( this->IsButtonSelected( BUTTON_GROUP_TOUCH ) ) {
          TouchButtonIndex selected_button = this->GetSelectedTouchButton();
          if( this->IsSelectEnable( selected_button ) ) {
            switch( selected_button ) {
            case TOUCH_BUTTON_UP:  // ^b`
              m_control_code = CONTROL_CODE_CURSOR_MOVE;
              this->CursorMoveUp();
              break;
            case TOUCH_BUTTON_DOWN:  // ^b`
              m_control_code = CONTROL_CODE_CURSOR_MOVE;
              this->CursorMoveDown();
              break;
            case TOUCH_BUTTON_RETURN:  //u߂v{^^b`
              m_result = RESULT_CANCEL;
              m_wait_animation_index = BUTTON_DESC_TOUCH[ TOUCH_BUTTON_RETURN ].select_animation;
              this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
              break;
            }
          }
        }
        else if( this->IsButtonHolding( BUTTON_GROUP_WAZA ) ||
            this->IsButtonHolding( BUTTON_GROUP_TOUCH ) ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          WazaButtonIndex selected_button = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( selected_button ) ) {
            if( selected_button == WAZA_BUTTON_NEW ) {
              m_wait_animation_index = BUTTON_DESC_WAZA[ WAZA_BUTTON_NEW ].select_animation;
              app::util::StartAnimation( m_layout_work, m_wait_animation_index );
              this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
              m_result = RESULT_CANCEL;
            }
            else {
              m_selected_waza_index = selected_button;
              m_wait_animation_index = BUTTON_DESC_WAZA[ selected_button ].select_animation;
              app::util::StartAnimation( m_layout_work, m_wait_animation_index );
              this->ChangeSeq( SEQ_CONFIRM_WAIT );
            }
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          m_result = RESULT_CANCEL;
          m_wait_animation_index = BUTTON_DESC_TOUCH[ TOUCH_BUTTON_RETURN ].select_animation;
          app::util::StartAnimation( m_layout_work, m_wait_animation_index );
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
        }
        else if( this->UpdateCursorMove() ) {  // \L[ŃJ[\ړ
          WazaButtonIndex old_pos = this->GetPrevCursorPos();
          WazaButtonIndex new_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_pos, new_pos );
          this->OnCursorMoved( old_pos, new_pos );
          m_control_code = CONTROL_CODE_CURSOR_MOVE;
        }
        break;


      case SEQ_CONFIRM_WAIT:
        m_button_manager[ BUTTON_GROUP_CONFIRM ]->Update();
        if( this->IsButtonSelected( BUTTON_GROUP_CONFIRM ) ) {
          m_result = RESULT_SELECT;
          m_wait_animation_index = BUTTON_DESC_CONFIRM[ CONFIRM_BUTTON_FORGET ].select_animation;
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_MESSAGE );
        }
        else if( this->IsButtonHolding( BUTTON_GROUP_CONFIRM ) ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          m_result = RESULT_SELECT;
          m_wait_animation_index = BUTTON_DESC_CONFIRM[ CONFIRM_BUTTON_FORGET ].select_animation;
          app::util::StartAnimation( m_layout_work, m_wait_animation_index );
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_MESSAGE );
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          this->ChangeSeq( SEQ_SELECT_WAIT );
        }
        break; 


      case SEQ_ANIME_WAIT:
        m_button_manager[ BUTTON_GROUP_TOUCH ]->Update();
        m_button_manager[ BUTTON_GROUP_WAZA ]->Update();
        m_button_manager[ BUTTON_GROUP_CONFIRM ]->Update();
        if( this->IsAnimationFinished() ) {
          this->ChangeSeq( m_next_seq );
        }
        break;


      case SEQ_MESSAGE:
        if( this->UpdateMessageStream() ) {
          this->ChangeSeq( SEQ_FINISH );
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }





    // V[PXύX
    void Lower::ChangeSeq( Sequence seq, Sequence next_seq )
    {
      switch( seq ) {
      case SEQ_SELECT_WAIT:
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA0 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA1 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA2 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA3 );
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_CONFIRM );
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_MESSAGE );
        app::util::StartAnimation( m_layout_work, ANIMATION_SCENE_SELECT );
        break;
      case SEQ_CONFIRM_WAIT:
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_SELECT );
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_MESSAGE );
        app::util::StartAnimation( m_layout_work, ANIMATION_SCENE_CONFIRM );
        break;
      case SEQ_MESSAGE:
        this->StartMessageStream();
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_CONFIRM );
        app::util::StopAnimation( m_layout_work, ANIMATION_SCENE_SELECT );
        app::util::StartAnimation( m_layout_work, ANIMATION_SCENE_MESSAGE );
        break;
      }
      m_seq = seq;
      m_next_seq = next_seq;
    }





    // {^Ă邩ǂ𒲂ׂ
    bool Lower::IsButtonHolding( ButtonGroup button_group ) const
    {
      return m_button_manager[ button_group ]->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool Lower::IsButtonSelected( ButtonGroup button_group ) const
    {
      return m_button_manager[ button_group ]->IsButtonSelected();
    }

    // Iꂽ{^擾
    Lower::WazaButtonIndex Lower::GetSelectedButton( void ) const
    {
      return static_cast<WazaButtonIndex>( 
          m_button_manager[ BUTTON_GROUP_WAZA ]->GetSelectedButtonId() );
    }

    // Iꂽ^b`{^擾
    Lower::TouchButtonIndex Lower::GetSelectedTouchButton( void ) const
    {
      return static_cast<TouchButtonIndex>( 
          m_button_manager[ BUTTON_GROUP_TOUCH ]->GetSelectedButtonId() );
    }




    // {^I\ǂ𒲂ׂ
    bool Lower::IsSelectEnable( WazaButtonIndex button_index ) const
    {
      return m_button_manager[ BUTTON_GROUP_WAZA ]->IsButtonActive( button_index );
    }

    // {^I\ǂ𒲂ׂ
    bool Lower::IsSelectEnable( TouchButtonIndex button_index ) const
    {
      return m_button_manager[ BUTTON_GROUP_TOUCH ]->IsButtonActive( button_index );
    }







    // J[\ֈړ
    void Lower::CursorMoveUp( void )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      WazaButtonIndex new_pos = static_cast<WazaButtonIndex>( 
          ( old_pos + WAZA_BUTTON_NUM - 1 ) % WAZA_BUTTON_NUM );
      this->CursorMoveTo( new_pos );
    }


    // J[\ֈړ
    void Lower::CursorMoveDown( void )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      WazaButtonIndex new_pos = static_cast<WazaButtonIndex>( ( old_pos + 1 ) % WAZA_BUTTON_NUM );
      this->CursorMoveTo( new_pos );
    }


    // J[\ړ
    void Lower::CursorMoveTo( WazaButtonIndex new_pos )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      m_cursor_manager->SetPos( new_pos );
      this->StartCursorMoveAnimation( old_pos, new_pos );
      this->OnCursorMoved( old_pos, new_pos );
    }


    // J[\ړۂ̏
    void Lower::OnCursorMoved( WazaButtonIndex old_pos, WazaButtonIndex new_pos )
    {
      if( new_pos == WAZA_BUTTON_WAZA0 ) {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonPassive( TOUCH_BUTTON_UP );
      }
      else {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonActive( TOUCH_BUTTON_UP );
      }

      if( new_pos == WAZA_BUTTON_NEW ) {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonPassive( TOUCH_BUTTON_DOWN );
      }
      else {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonActive( TOUCH_BUTTON_DOWN );
      }
    }


    // J[\ړAj[V
    void Lower::StartCursorMoveAnimation( WazaButtonIndex old_pos, WazaButtonIndex new_pos )
    {
      const ButtonDesc& old_desc = BUTTON_DESC_WAZA[ old_pos ];
      const ButtonDesc& new_desc = BUTTON_DESC_WAZA[ new_pos ];
      app::util::StopAnimation( m_layout_work, old_desc.cursor_animation );
      app::util::StartAnimation( m_layout_work, new_desc.cursor_animation );
    } 


    // ݂̃J[\ʒu擾
    Lower::WazaButtonIndex Lower::GetCurrentCursorPos( void ) const
    {
      return static_cast<WazaButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    Lower::WazaButtonIndex Lower::GetPrevCursorPos( void ) const
    {
      return static_cast<WazaButtonIndex>( m_cursor_manager->GetOldID() );
    } 


    // J[\̓XV
    bool Lower::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 






    // ҂Aj[VIǂ𒲂ׂ
    bool Lower::IsAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }







    // bZ[W̕\Jn
    void Lower::StartMessageStream( void )
    {
      gfl::str::StrBuf* source_buf = ::app::util::GetTempStrBuf( 0 );
      gfl::str::StrBuf* expand_buf = ::app::util::GetTempStrBuf( 1 );
      WordSet* wordset = ::app::util::GetWordset();
      gfl::str::MsgData* message_data = this->GetMessageData();
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();

      WazaNo forget_wazano = this->GetCursorPosWazaNo();  // J[\ʒűZY
      WazaNo learn_wazano = this->GetNewWazaNo();   // VoZ
      message_data->GetString( msg_waza_oboe_01_27, *source_buf );
      wordset->RegisterPokeNickName( 0, pokeparam );
      wordset->RegisterWazaName( 1, forget_wazano );
      wordset->RegisterWazaName( 2, learn_wazano );
      wordset->Expand( expand_buf, source_buf );

      m_message_window->Clear();
      m_message_window->SetString( *expand_buf );
      m_message_window->SetFinishMode( gfl::str::StrWin::FINISH_USER, 0 );
    }


    // bZ[W̕\XV
    bool Lower::UpdateMessageStream( void )
    {
      gfl::str::StrWin::Result result = m_message_window->Proc();
      return ( result == gfl::str::StrWin::RES_FINISH );
    }




  }  // namespace wazaoboe
}  // namespace app 
