//=================================================================================================
/**
 * @file wazaoboe_Base.h
 * @brief Zoʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=================================================================================================
#ifndef __WAZAOBOEBASE_H__
#define __WAZAOBOEBASE_H__
#include <gflib.h>
#include <pmlib.h>


namespace app { 
  namespace wazaoboe {


    class Base
    {
      GFL_FORBID_COPY_AND_ASSIGN( Base );  // Rs[֎~

      public:
      static void Initialize( 
          gfl::heap::HeapBase* heap, 
          const pml::pokepara::PokemonParam* pokeparam,
          WazaNo new_wazano );
      static void Finalize( void ); 

      private:
      static gfl::str::MsgData* s_message_data;
      static const pml::pokepara::PokemonParam* s_pokeparam;
      static WazaNo s_new_wazano;


      public:
      Base( 
          gfl::heap::HeapBase* parent_heap,
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size,
          gfl::grp::g2d::LytSys* layout_system );
      virtual ~Base();
      virtual void Update( void ) = 0;
      virtual void Draw( void ) = 0;
      bool IsFinished( void ) const;


      protected:
      gfl::heap::HeapBase* GetHeap( void ) const;
      gfl::heap::HeapBase* GetDeviceHeap( void ) const;
      gfl::heap::NwAllocator* GetNwAllocator( void ) const;
      gfl::heap::NwAllocator* GetNwDeviceAllocator( void ) const;
      gfl::grp::GraphicsSystem* GetGraphicsSystem( void ) const;
      gfl::grp::g2d::LytSys* GetLayoutSystem( void ) const;
      gfl::ui::DeviceManager* GetUiDeviceManager( void ) const; 
      gfl::str::MsgData* GetMessageData( void ) const; // @todo static֐ɂ
      const pml::pokepara::PokemonParam* GetPokeParam( void ) const; // @todo static֐ɂ
      WazaNo GetNewWazaNo( void ) const; // @todo static֐ɂ
      void SetFinishFlag( void );
      void ResetFinishFlag( void );


      private:
      void CreateHeap( 
          gfl::heap::HeapBase* parent_heap, 
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size );
      void CreateNwAllocator( void );
      void DeleteHeap( void );
      void DeleteNwAllocator( void );
      gfl::heap::HeapBase* m_heap;
      gfl::heap::HeapBase* m_device_heap;
      gfl::heap::NwAllocator* m_nw_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;
      gfl::grp::g2d::LytSys* m_layout_system;
      bool m_finish_flag; 

    };


  } // namespace wazaoboe 
} // namespace app


#endif // __WAZAOBOEBASE_H__
