//=================================================================================================
/**
 * @file wazaoboe_Base.cpp
 * @brief Zoʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=================================================================================================
#include <gflib.h>
#include <pmlib.h>
#include "wazaoboe_Base.h"

#include <message/msg_waza_oboe.h>


namespace app { 
  namespace wazaoboe {


    gfl::str::MsgData* Base::s_message_data = NULL;
    const pml::pokepara::PokemonParam* Base::s_pokeparam = NULL;
    WazaNo Base::s_new_wazano = WAZANO_NULL;

    void Base::Initialize( 
        gfl::heap::HeapBase* heap,
        const pml::pokepara::PokemonParam* pokeparam,
        WazaNo new_wazano )
    {
      s_pokeparam = pokeparam;
      s_new_wazano = new_wazano;
      if( s_message_data == NULL ) {
        s_message_data = GFL_NEW( heap ) 
          gfl::str::MsgData( 
              L"rom:/message.garc", 
              GARC_message_waza_oboe_DAT, 
              heap, 
              gfl::str::MsgData::LOAD_FULL );
      }
    }

    void Base::Finalize( void )
    {
      if( s_message_data ) {
        GFL_DELETE s_message_data;
        s_message_data = NULL;
      }
    }

    gfl::str::MsgData* Base::GetMessageData( void ) const
    { 
      return s_message_data; 
    }

    const pml::pokepara::PokemonParam* Base::GetPokeParam( void ) const
    {
      return s_pokeparam;
    }

    WazaNo Base::GetNewWazaNo( void ) const
    {
      return s_new_wazano;
    }


    Base::Base( 
        gfl::heap::HeapBase* parent_heap,
        gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::heap::HEAPID device_heap_id, u32 device_heap_size,
        gfl::grp::g2d::LytSys* layout_system ) :
      m_heap( NULL ),
      m_device_heap( NULL ),
      m_nw_allocator( NULL ),
      m_nw_device_allocator( NULL ),
      m_layout_system( layout_system ),
      m_finish_flag( false )
    {
      this->CreateHeap( 
          parent_heap, app_heap_id, app_heap_size, 
          parent_device_heap, device_heap_id, device_heap_size );
      this->CreateNwAllocator();
    }

    void Base::CreateHeap( 
        gfl::heap::HeapBase* parent_heap, 
        gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::heap::HEAPID device_heap_id, u32 device_heap_size )
    {
      GFL_ASSERT( !m_heap );
      if( !m_heap ) {
        m_heap = gfl::heap::Manager::CreateHeap( 
            parent_heap, app_heap_id, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }

      GFL_ASSERT( !m_device_heap );
      if( !m_device_heap ) {
        m_device_heap = gfl::heap::Manager::CreateHeap( 
            parent_device_heap, device_heap_id, device_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }
    }

    void Base::CreateNwAllocator( void )
    {
      GFL_ASSERT( !m_nw_allocator );
      if( !m_nw_allocator ) {
        m_nw_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_heap );
      }

      GFL_ASSERT( !m_nw_device_allocator );
      if( !m_nw_device_allocator ) {
        m_nw_device_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_device_heap );
      }
    }






    Base::~Base()
    {
      this->DeleteNwAllocator();
      this->DeleteHeap();
    }

    void Base::DeleteNwAllocator( void )
    {
      if( m_nw_allocator ) {
        GFL_DELETE m_nw_allocator;
        m_nw_allocator = NULL;
      }
      if( m_nw_device_allocator ) {
        GFL_DELETE m_nw_device_allocator;
        m_nw_device_allocator = NULL;
      }
    }

    void Base::DeleteHeap( void )
    {
      if( m_heap ) {
        gfl::heap::Manager::DeleteHeap( m_heap );
        m_heap = NULL;
      } 
      if( m_device_heap ) {
        gfl::heap::Manager::DeleteHeap( m_device_heap );
        m_device_heap = NULL;
      }
    }





    bool Base::IsFinished( void ) const
    {
      return m_finish_flag;
    }

    void Base::SetFinishFlag( void )
    {
      m_finish_flag = true;
    }

    void Base::ResetFinishFlag( void )
    {
      m_finish_flag = false;
    }




    gfl::heap::HeapBase* Base::GetHeap( void ) const
    {
      return m_heap;
    }

    gfl::heap::HeapBase* Base::GetDeviceHeap( void ) const
    {
      return m_device_heap;
    }

    gfl::heap::NwAllocator* Base::GetNwAllocator( void ) const
    {
      return m_nw_allocator;
    }

    gfl::heap::NwAllocator* Base::GetNwDeviceAllocator( void ) const
    {
      return m_nw_device_allocator;
    }

    gfl::grp::GraphicsSystem* Base::GetGraphicsSystem( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetGraphicsSystem();
    }

    gfl::grp::g2d::LytSys* Base::GetLayoutSystem( void ) const
    {
      return m_layout_system;
    }

    gfl::ui::DeviceManager* Base::GetUiDeviceManager( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetUiDeviceManager();
    }









  } // namespace wazaoboe 
} // namespace app
