//========================================================================================
/**
 * @file wazaoboe_Process.h
 * @brief ZovZX
 * @author obata_toshihiro
 * @date 2011.08.28
 */
//========================================================================================
#ifndef __WAZAOBOEPROCESS_H__
#define __WAZAOBOEPROCESS_H__
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>


namespace app {
  namespace wazaoboe {

    class Upper;
    class Lower;
    class PokemonDrawer;


    class Process : public gamesystem::GameProc
    {
      public: 

        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         */
        //--------------------------------------------------------------------------------
        Process( void );

        //--------------------------------------------------------------------------------
        /**
         * @brief fXgN^
         */
        //--------------------------------------------------------------------------------
        virtual ~Process();

        //--------------------------------------------------------------------------------
        /**
         * @brief \|Pݒ肷
         */
        //--------------------------------------------------------------------------------
        void SetPokeParam( const pml::pokepara::PokemonParam* pokeparam ); 

        //--------------------------------------------------------------------------------
        /**
         * @brief VoZݒ肷
         */
        //--------------------------------------------------------------------------------
        void SetNewWazaNo( WazaNo wazano );

        //--------------------------------------------------------------------------------
        /**
         * @biref Zoʂ̌ʂi[obt@Zbg
         */
        //--------------------------------------------------------------------------------
        struct ResultData {
          bool waza_removed;     // ZYꂽǂ
          u8 removed_waza_index; // Ԗڂ̋ZYꂽH
        };
        void SetResultBuffer( ResultData* dest );




        // vZXƂĂ̓

        //--------------------------------------------------------------------------------
        /**
         * @brief	vZX̏
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  p
         * @retval RES_FINISH    I
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result InitFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̍XV
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Cp
         * @retval RES_FINISH    CI
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̕`揈
         * @param proc_manager  vZX̃}l[W
         */
        //--------------------------------------------------------------------------------
        virtual void DrawFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̏I
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Ip
         * @retval RES_FINISH    II
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result EndFunc( gfl::proc::Manager* proc_manager );






      protected:

        static const gfl::grp::g2d::LytSysSetUp LYTSYS_SETUP_DATA;
        static const char* SYSTEMFONT_FILENAME;

        gfl::heap::HeapBase* m_heap;
        gfl::heap::HeapBase* m_device_heap;
        gfl::heap::NwAllocator* m_nw_heap_allocator;
        gfl::heap::NwAllocator* m_nw_device_allocator;
        gfl::grp::g3d::System* m_g3d_system;
        gfl::grp::g2d::LytSys* m_layout_system;
        const pml::pokepara::PokemonParam* m_pokeparam; 
        WazaNo m_new_wazano;
        wazaoboe::Upper* m_upper;
        wazaoboe::Lower* m_lower;
        wazaoboe::PokemonDrawer* m_poke_drawer;
        ResultData* m_result;

        void InitResult( void );
        void CreateHeap( void ); 
        void CreateG3dSystem( void );
        void CreateLayoutSystem( void );
        void SetupFont( void );
        void CreateUpper( void );
        void CreateLower( void );
        void CreatePokemonDrawer( void );

        void DeleteHeap( void );
        void DeleteG3dSystem( void );
        void DeleteLayoutSystem( void ); 
        void CleanupFont( void ); 
        void DeleteUpper( void );
        void DeleteLower( void );
        void DeletePokemonDrawer( void );

        void PutResult( void );
    };


  } // namespace wazaoboe
} // namespace app


#endif // __WAZAOBOEPROCESS_H__
