//=======================================================================================
/**
 * @file app_util.h
 * @brief AvP[Vp[eBeB֐Q
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=======================================================================================
#ifndef __APPUTIL_H__
#define __APPUTIL_H__
#include <gflib.h>
#include <pmlib.h>
#include <print/wordset.h>


namespace app {
  namespace util {


    //-------------------------------------------------------------------------------
    /**
     * @brief gp
     * @param heap  Ɏgpq[v
     */
    //-------------------------------------------------------------------------------
    static void Initialize( gfl::heap::HeapBase* heap );

    //-------------------------------------------------------------------------------
    /**
     * @brief Еt
     */
    //-------------------------------------------------------------------------------
    static void Finalize( void );



    // yC̉ԂύX
    static void SetPaneVisibility( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, bool visibility );

    static void SetPaneVisible(
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index );

    static void SetPaneInvisible(
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index );




    // eLXgyCɕZbg
    static void SetTextboxPaneMessage( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, 
        gfl::str::MsgData* message_data, u32 str_id );

    static void SetTextboxPaneString( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::StrBuf* strbuf );

    static void SetTextboxPaneNumber( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, u32 value, u32 keta );

    static void SetTextboxPaneMonsName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, MonsNo monsno );

    static void SetTextboxPaneTokuseiName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, TokuseiNo tokusei );

    static void SetTextboxPaneTokuseiInfo( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, TokuseiNo tokusei );

    static void SetTextboxPaneSex( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, pml::Sex sex );

    static void SetTextboxPaneWazaName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, WazaNo wazano );

    static void SetTextboxPaneItemName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, u32 itemno, gfl::heap::HeapBase* heap );




    // Aj[V𐧌䂷
    static void StartAnimation( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index );

    static void StopAnimation( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index );

    static void PauseAnimation( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index, bool pause );

    static void SetAnimationFrame( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index, u32 frame ); 




    // ꎞobt@擾
    static gfl::str::StrBuf* GetTempStrBuf( u32 idx = 0 );

    // [hZbg擾
    static WordSet* GetWordset( void );



    static const u32 TEMP_STRBUF_NUM = 2;
    static const u32 TEMP_STRBUF_LENGTH = 256;
    static gfl::str::StrBuf* m_temp_strbuf[ TEMP_STRBUF_NUM ] = { NULL, NULL };
    static gfl::str::MsgData* m_message_data = NULL;
    static WordSet* m_wordset = NULL;


  }  // namespace util
}  // namespace app


#endif // __APPUTIL_H__ 
