//=======================================================================================
/**
 * @file app_util.cpp
 * @brief AvP[Vp[eBeB֐Q
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//=======================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <print/wordset.h>
#include <app/util/app_util.h>

#include <message/message.gaix>
#include <message/msg_app_util.h>


namespace app {
  namespace util {



    //-------------------------------------------------------------------------------
    /**
     * @brief gp
     * @param heap  CX^X̐Ɏgpq[v
     */
    //-------------------------------------------------------------------------------
    void Initialize( gfl::heap::HeapBase* heap )
    {
      for( u32 i=0; i<TEMP_STRBUF_NUM; i++ ) {
        if( m_temp_strbuf[i] == NULL ) {
          m_temp_strbuf[i] = GFL_NEW( heap ) 
            gfl::str::StrBuf( TEMP_STRBUF_LENGTH, heap );
        }
      }

      if( m_message_data == NULL ) {
        m_message_data = GFL_NEW( heap ) 
          gfl::str::MsgData( 
              L"rom:/message.garc", 
              GARC_message_app_util_DAT, 
              heap, 
              gfl::str::MsgData::LOAD_FULL );
      }

      if( m_wordset == NULL ) {
        m_wordset = GFL_NEW( heap ) WordSet( heap );
      }
    }

    //-------------------------------------------------------------------------------
    /**
     * @brief Еt
     */
    //-------------------------------------------------------------------------------
    void Finalize( void )
    {
      for( u32 i=0; i<TEMP_STRBUF_NUM; i++ ) {
        if( m_temp_strbuf[i] ) {
          GFL_DELETE m_temp_strbuf[i];
          m_temp_strbuf[i] = NULL;
        }
      }

      if( m_message_data ) {
        GFL_DELETE m_message_data;
        m_message_data = NULL;
      }

      if( m_wordset ) {
        GFL_DELETE m_wordset;
      }
    }





    // ꎞobt@擾
    gfl::str::StrBuf* GetTempStrBuf( u32 idx ) 
    { 
      if( idx < TEMP_STRBUF_NUM ) 
      {
        return m_temp_strbuf[ idx ]; 
      }
      else
      {
        GFL_ASSERT(0);
        return m_temp_strbuf[0]; 
      }
    }

    // [hZbg擾
    WordSet* GetWordset( void ) 
    { 
      return m_wordset; 
    }





    //-----------------------------------------------------------------------------------
    // yC̉ԂύX
    //-----------------------------------------------------------------------------------
    void SetPaneVisibility( 
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index, bool visibility )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layout_work->GetPane( pane_index ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetVisible( visibility );
      }
    }

    //-----------------------------------------------------------------------------------
    // yC\
    //-----------------------------------------------------------------------------------
    void SetPaneVisible(
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index )
    {
      SetPaneVisibility( layout_work, pane_index, true );
    }

    //-----------------------------------------------------------------------------------
    // yC\ɂ
    //-----------------------------------------------------------------------------------
    void SetPaneInvisible(
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index )
    {
      SetPaneVisibility( layout_work, pane_index, false );
    }





    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɐʂZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneSex( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, pml::Sex sex )
    {
      u32 str_table[ pml::SEX_NUM ] = 
      {
        APP_UTIL_MALE,
        APP_UTIL_FEMALE,
        APP_UTIL_UNKNOWN,
      };
      app::util::SetTextboxPaneMessage( 
          layout_work, pane_index, m_message_data, str_table[ sex ] );
    }


    //-----------------------------------------------------------------------------------
    // eLXgyCɕZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneMessage( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, 
        gfl::str::MsgData* message_data, u32 str_id )
    {
      GFL_ASSERT( m_temp_strbuf[0] );
      message_data->GetString( str_id, *m_temp_strbuf[0] );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɕݒ肷
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneString( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::StrBuf* strbuf )
    {
      gfl::grp::g2d::LytTextBox* text_box;
      text_box = layout_work->GetTextBoxPane( pane_index ); 
      GFL_ASSERT( text_box );
      if( text_box ) {
        const wchar_t* string = strbuf->GetPtr();
        text_box->SetString( string );
      }
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɐlZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneNumber( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, u32 value, u32 keta )
    {
      print::StrNumber( m_temp_strbuf[0], value, keta, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɋZZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneWazaName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, WazaNo wazano )
    {
      pml::System::WazaDataSystem()->GetWazaName( wazano, m_temp_strbuf[0] );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɃX^[Zbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneMonsName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, MonsNo monsno )
    {
      pml::System::PersonalSystem()->GetMonsName( monsno, m_temp_strbuf[0] );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɓZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneTokuseiName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, TokuseiNo tokusei )
    {
      pml::personal::System* personal_system = pml::System::PersonalSystem();
      personal_system->GetTokuseiName( tokusei, m_temp_strbuf[0] );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɓZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneTokuseiInfo( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, TokuseiNo tokusei )
    {
      pml::personal::System* personal_system = pml::System::PersonalSystem();
      personal_system->GetTokuseiInfo( tokusei, m_temp_strbuf[0] );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }


    //-----------------------------------------------------------------------------------
    // eLXg{bNXyCɃACeZbg
    //-----------------------------------------------------------------------------------
    void SetTextboxPaneItemName( 
        gfl::grp::g2d::LytWk* layout_work, 
        gfl::grp::g2d::LytPaneIndex pane_index, u32 itemno, gfl::heap::HeapBase* heap )
    {
      gfl::heap::HeapBase* lower_heap = heap->GetLowerHandle();
      item::ITEM_DATA item_data( itemno, heap );
      item_data.ITEM_GetItemName( m_temp_strbuf[0], lower_heap );
      app::util::SetTextboxPaneString( layout_work, pane_index, m_temp_strbuf[0] );
    }






    //-----------------------------------------------------------------------------------
    // Aj[VJn
    //-----------------------------------------------------------------------------------
    void StartAnimation( gfl::grp::g2d::LytWk* layout_work, u32 animation_index )
    {
      if( layout_work->IsBindAnime( animation_index ) == false ) {
        layout_work->BindAnime( animation_index );
      }
      layout_work->SetAutoAnime( animation_index, true );
      layout_work->SetAnimeFrame( animation_index, 0 );
    }


    //-----------------------------------------------------------------------------------
    // Aj[V~
    //-----------------------------------------------------------------------------------
    void StopAnimation( gfl::grp::g2d::LytWk* layout_work, u32 animation_index )
    {
      if( layout_work->IsBindAnime( animation_index ) ) {
        layout_work->UnBindAnime( animation_index );
      }
    }


    //-----------------------------------------------------------------------------------
    // Aj[Vꎞ~
    //-----------------------------------------------------------------------------------
    void PauseAnimation( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index, bool pause )
    {
      if( layout_work->IsBindAnime( animation_index ) ) {
        layout_work->SetAutoAnime( animation_index, pause );
      }
    }


    //-----------------------------------------------------------------------------------
    // Aj[Vꎞ~
    //-----------------------------------------------------------------------------------
    void SetAnimationFrame( 
        gfl::grp::g2d::LytWk* layout_work, u32 animation_index, u32 frame )
    {
      if( layout_work->IsBindAnime( animation_index ) ) {
        layout_work->SetAnimeFrame( animation_index, frame );
      }
    }







  }  // namespace util
}  // namespace app
