//========================================================================================
/**
 * @file wazawasure_PokemonDrawer.h
 * @brief ZY( |P`NX )
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//========================================================================================
#ifndef __WAZAWASURE_POKEMONDRAWER_H__
#define __WAZAWASURE_POKEMONDRAWER_H__
#include <gflib.h>
#include <pmlib.h> 
#include "wazawasure_Base.h"

namespace app {
  namespace wazawasure {


    class PokemonDrawer : public Base
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokemonDrawer );  // Rs[֎~

      public:
      //--------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap                 CX^X̐Ɏgpq[v
       * @param device_heap          CX^X̐Ɏgpq[v
       * @param layout_system        `Ɏgp郌CAEgVXe
       * @param monsno               `悷|P
       */
      //--------------------------------------------------------------------------------
      PokemonDrawer( 
          gfl::heap::HeapBase* heap,
          gfl::heap::HeapBase* device_heap,
          gfl::grp::g2d::LytSys* layout_system, 
          MonsNo monsno );

      //--------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //--------------------------------------------------------------------------------
      virtual ~PokemonDrawer(); 

      //--------------------------------------------------------------------------------
      /**
       * @brief \eXV
       */
      //--------------------------------------------------------------------------------
      virtual void Update( void );

      //--------------------------------------------------------------------------------
      /**
       * @brief ʂ`悷
       */
      //--------------------------------------------------------------------------------
      virtual void Draw( void );




      private: 

      // f̃Aj[V
      enum ModelAnimaiton {
        MODEL_ANIMATION_WAIT,  // ҋ@Aj
        MODEL_ANIMATION_NUM,
      };


      // `ɕKvȃf[^
      struct DrawData {
        gfl::grp::g3d::Camera* camera;
        gfl::grp::g3d::Model* model;
        gfl::grp::g3d::ResAnim* model_animation[ MODEL_ANIMATION_NUM ];
        gfl::grp::g3d::Scene* scene;
        gfl::grp::g3d::Resource* environment_resource;
        gfl::grp::g3d::Resource* camera_resource;
        gfl::grp::g3d::Resource* model_resource;
        gfl::grp::g3d::Resource* model_animation_resource[ MODEL_ANIMATION_NUM ];
      };


      static u32 APP_HEAPSIZE;
      static u32 DEVICE_HEAPSIZE; 

      DrawData m_draw_data;
      MonsNo m_monsno;


      void CreateDrawData( void );
      void DeleteDrawData( void );
      void LoadDrawData( void );
      void SetupDrawData( void );
      void SetupDrawData_MODEL( void ); 
      void SetupDrawData_MODEL_ANIMATION( void ); 
      void SetupDrawData_SCENE( void ); 
    };


  } // namespace wazawasure
} // namespace app


#endif // __WAZAWASURE_POKEMONDRAWER_H__
