//========================================================================================
/**
 * @file wazawasure_PokemonDrawer.cpp
 * @brief ZY( |P`NX )
 * @author obata_toshihiro
 * @date 2011.09.03
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include "wazawasure_Base.h"
#include "wazawasure_PokemonDrawer.h" 

#include <arc/arc_def.h>
#include <arc/waza_wasure_3d_data.gaix>


namespace app {
  namespace wazawasure { 


    // q[vTCY
    u32 PokemonDrawer::APP_HEAPSIZE    =  0x10000;
    u32 PokemonDrawer::DEVICE_HEAPSIZE = 0x500000;


    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawer::PokemonDrawer( 
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* device_heap,
        gfl::grp::g2d::LytSys* layout_system, 
        MonsNo monsno ) : 
      Base( 
          heap, HEAPID_WAZAWASURE_POKEDRAWER, APP_HEAPSIZE,
          device_heap, HEAPID_WAZAWASURE_POKEDRAWER_DEVICE, DEVICE_HEAPSIZE,
          layout_system ), 
      m_draw_data(),
      m_monsno( monsno )
    {
      this->CreateDrawData();
      this->LoadDrawData();
      this->SetupDrawData();

      // fAjJn
      gfl::heap::NwAllocator* nw_heap_allocator = this->GetNwAllocator();
      m_draw_data.model->ChangeAnimation( 
          nw_heap_allocator, m_draw_data.model_animation[ MODEL_ANIMATION_WAIT ] );
      m_draw_data.model->SetAnimationLoop( true );
      
#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_WAZAWASURE_POKEDRAWER: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif 
    }



    // `f[^𐶐
    void PokemonDrawer::CreateDrawData( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_draw_data.camera = NULL;
      m_draw_data.model = GFL_NEW( heap ) gfl::grp::g3d::Model();
      m_draw_data.model_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      m_draw_data.scene = GFL_NEW( heap ) gfl::grp::g3d::Scene();
      m_draw_data.environment_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      m_draw_data.camera_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        m_draw_data.model_animation_resource[i] = GFL_NEW( heap ) gfl::grp::g3d::Resource();
        m_draw_data.model_animation[i] = GFL_NEW( heap ) gfl::grp::g3d::ResAnim();
      } 
    }



    // `f[^ǂݍ
    void PokemonDrawer::LoadDrawData( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::fs::ArcFile arcfile( ARCID_WAZAWASURE_3D, heap );
      gfl::fs::ArcFile::ARCDATID arcdatid = 0;

      switch( m_monsno ) {
      case MONSNO_PIKATYUU:  arcdatid = GARC_waza_wasure_3d_data_pikachu_BCRES;  break;
      case MONSNO_SIKIZIKA:  arcdatid = GARC_waza_wasure_3d_data_shikijika_BCRES;  break;
      default:  arcdatid = GARC_waza_wasure_3d_data_candela_BCRES;  break;
      }

      // f
      gfl::grp::g3d::Resource::Description resource_description;
      u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
      common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT; 
      m_draw_data.model_resource->LoadAndSetup( nw_device_allocator, 
          &arcfile, arcdatid, &resource_description, common_resource_flag ); 

      // fAj[V
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        m_draw_data.model_animation_resource[i]->LoadAndSetup( 
            nw_device_allocator, &arcfile, arcdatid );
      }

      // 
      m_draw_data.environment_resource->LoadAndSetup( 
          nw_device_allocator, &arcfile, GARC_waza_wasure_3d_data_environment_BCENV ); 

      // J
      m_draw_data.camera_resource->LoadAndSetup( 
          nw_device_allocator, &arcfile, GARC_waza_wasure_3d_data_camera_BCENV );
    }





    // `f[^̃ZbgAbv
    void PokemonDrawer::SetupDrawData( void )
    {
      this->SetupDrawData_MODEL();
      this->SetupDrawData_MODEL_ANIMATION();
      this->SetupDrawData_SCENE();
    }


    // ff[^̃ZbgAbv
    void PokemonDrawer::SetupDrawData_MODEL( void )
    {
      f32 scale = 1.0f;
      switch( m_monsno ) {
      case MONSNO_PIKATYUU:  scale = 4.00f;  break;
      case MONSNO_SIKIZIKA:  scale = 3.50f;  break;
      }

      gfl::heap::NwAllocator* nw_heap_allocator = this->GetNwAllocator();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      m_draw_data.model->Create( 
          nw_heap_allocator, nw_device_allocator, m_draw_data.model_resource, 0 );
      m_draw_data.model->SetScale( scale, scale, scale );
    }


    // fAj[ṼZbgAbv
    void PokemonDrawer::SetupDrawData_MODEL_ANIMATION( void )
    { 
      gfl::heap::NwAllocator* nw_heap_allocator = this->GetNwAllocator();
      for( u32 i=0; i<MODEL_ANIMATION_NUM; i++ ) {
        m_draw_data.model_animation[i]->Create( 
            nw_heap_allocator, 
            m_draw_data.model_animation_resource[i], 
            0, 
            gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
      }
    } 


    // V[̃ZbgAbv
    void PokemonDrawer::SetupDrawData_SCENE( void )
    {
      gfl::heap::NwAllocator* nw_heap_allocator = this->GetNwAllocator();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();

      gfl::grp::g3d::Scene::Description scene_desc;
      scene_desc.own_model_num_max = 8; 
      m_draw_data.scene->Create( nw_device_allocator, &scene_desc );
      m_draw_data.scene->BuildSceneUsingResource( 
          nw_heap_allocator, nw_device_allocator, m_draw_data.environment_resource ); 
      m_draw_data.scene->BuildSceneUsingResource( 
          nw_heap_allocator, nw_device_allocator, m_draw_data.camera_resource ); 

      m_draw_data.camera = 
        m_draw_data.scene->GetOwnCamera( m_draw_data.camera_resource->GetId(), 0 );
      GFL_ASSERT_STOP( m_draw_data.camera );
      m_draw_data.camera->SetPivotDirection( gfl::math::PIVOT_UPSIDE_TO_TOP ); 

      m_draw_data.scene->AddSceneNode( m_draw_data.model );
      m_draw_data.scene->AddModelToSceneCalculateGroup( m_draw_data.model, 0 );
      m_draw_data.scene->AddModelToSceneDrawGroup( m_draw_data.model, 0 );

#ifdef EDGE_ENABLE
      gfl::grp::g3d::G3DPostEffectSystem::Description post_effect_desc;
      post_effect_desc.edge_draw_group_id = 0;
      post_effect_desc.edge_enable = true;
      post_effect_desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DEFAULT_EDGE;
      post_effect_desc.bloom_filter_enable = false;
      m_draw_data.scene->CreatePostEffectSystem( 
          nw_heap_allocator, nw_device_allocator, &post_effect_desc ); 
      m_draw_data.scene->CreateEdgeMapSystem( nw_heap_allocator, nw_device_allocator, 0 ); 
      m_draw_data.scene->SetEdgeEnable( true ); 
      m_draw_data.scene->SwitchEdgeMapModel( m_draw_data.model, true );
#endif 

      m_draw_data.scene->Initialize();
      m_draw_data.scene->SetSceneEnvironmentUsingOwnObject();
      m_draw_data.scene->Calculate(); 
    }






    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawer::~PokemonDrawer()
    {
      this->DeleteDrawData();
    }


    // `f[^j
    void PokemonDrawer::DeleteDrawData( void )
    {
      m_draw_data.scene->RemoveAllSceneNodes();
      m_draw_data.scene->DestroyOwnObject();
#ifdef WAZAWASURE_EDGE_ENABLE
      m_draw_data.scene->DestroyEdgeMapSystem();
      m_draw_data.scene->DestroyPostEffectSystem();
#endif
      GFL_DELETE( m_draw_data.model );
      GFL_DELETE( m_draw_data.scene );
      GFL_DELETE( m_draw_data.environment_resource );
      GFL_DELETE( m_draw_data.camera_resource );
      GFL_DELETE( m_draw_data.model_resource );
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        GFL_DELETE( m_draw_data.model_animation[i] );
        GFL_DELETE( m_draw_data.model_animation_resource[i] );
      }
    }





    //------------------------------------------------------------------------------------
    // \eXV
    //------------------------------------------------------------------------------------
    void PokemonDrawer::Update( void )
    {
      m_draw_data.scene->Calculate(); // 3D V[̌vZ
      m_draw_data.scene->SubmitView( m_draw_data.camera ); // _ɈˑXVRenderQueue̍\z
#ifdef WAZAWASURE_EDGE_ENABLE
      m_draw_data.scene->SubmitViewOfEdge( m_draw_data.camera );
#endif
    }





    //------------------------------------------------------------------------------------
    // ʂ`悷
    //------------------------------------------------------------------------------------
    void PokemonDrawer::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();

#ifdef WAZAWASURE_EDGE_ENABLE
      m_draw_data.scene->EdgeMapDraw( 
          graphics_system, gfl::grp::DISPLAY_LOWER, m_draw_data.camera );
#endif

      m_draw_data.scene->Draw( 
          graphics_system, gfl::grp::DISPLAY_LOWER, m_draw_data.camera );

#ifdef WAZAWASURE_EDGE_ENABLE
      m_draw_data.scene->PostEffectDraw( 
          graphics_system, gfl::grp::DISPLAY_LOWER, m_draw_data.camera );
#endif 
    } 




  } // namespace wazawasure
} // namespace app 
