//=======================================================================================
/**
 * @file PokeStatusBase.h
 * @briefu悳݂vʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.01
 */
//=======================================================================================
#ifndef __POKESTATUSBASE_H__
#define __POKESTATUSBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class PokeStatusBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokeStatusBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      //---------------------------------------------------------------------------------
      PokeStatusBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~PokeStatusBase();





      // ݒ
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
        bool left_enable;                // {^邩ǂ
        bool right_enable;               // E{^邩ǂ
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting ) = 0;



      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_LEFT,    // E{^I
        RESULT_RIGHT,   // {^I
        RESULT_WAZA,    //u킴݂vI
        RESULT_NULL,
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;




      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }
      bool IsLeftEnable( void ) const { return m_settings.left_enable; }
      bool IsRightEnable( void ) const { return m_settings.right_enable; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __POKESTATUSBASE_H__ 
