//=======================================================================================
/**
 * @file PokeStatus.h
 * @briefu悳݂v
 * @author obata_toshihiro
 * @date 2011.09.01
 */
//=======================================================================================
#ifndef __POKESTATUS_H__
#define __POKESTATUS_H__
#include <gflib.h>
#include <print/xy_msgWin.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawUtil.h"
#include "PokeStatusBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class PokeStatus : public PokeStatusBase, public AppDrawUtil
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokeStatus );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      //---------------------------------------------------------------------------------
      PokeStatus( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~PokeStatus(); 

      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //---------------------------------------------------------------------------------
      virtual void Update( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      //---------------------------------------------------------------------------------
      virtual void Restart( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief I[g`tOZbg
       */
      //---------------------------------------------------------------------------------
      virtual void SetAutoDrawFlag( bool flag );

      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting );






      private:


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^ԍ
      enum ButtonIndex {
        BUTTON_LEFT,    // {^
        BUTTON_RIGHT,   // E{^
        BUTTON_WAZA,    //u킴݂v
        BUTTON_RETURN,  //uǂv
        BUTTON_NUM,
      };


      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_POKE_TYPE1,
        ANIMATION_DATA_POKE_TYPE2,
        ANIMATION_DATA_POKE_SICK,
        ANIMATION_DATA_POKE_DEAD,
        ANIMATION_DATA_HP_GAUGE,
        ANIMATION_DATA_EXP_GAUGE,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_LEFT_BUTTON_ACTIVE,
        ANIMATION_DATA_LEFT_BUTTON_PASSIVE,
        ANIMATION_DATA_RIGHT_BUTTON_ACTIVE,
        ANIMATION_DATA_RIGHT_BUTTON_PASSIVE,
        ANIMATION_DATA_CURSOR_ON_LEFT,
        ANIMATION_DATA_CURSOR_ON_RIGHT,
        ANIMATION_DATA_CURSOR_ON_WAZA,
        ANIMATION_DATA_CURSOR_ON_RETURN,
        ANIMATION_DATA_CURSOR_FLUCTUATE,
        ANIMATION_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_POKE_TYPE1,
        ANIMATION_POKE_TYPE2,
        ANIMATION_POKE_SICK,
        ANIMATION_POKE_DEAD,
        ANIMATION_HP_GAUGE,
        ANIMATION_EXP_GAUGE,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BUTTON_RELEASE,
        ANIMATION_DUMMY_BUTTON_SELECT,
        ANIMATION_LEFT_BUTTON_ACTIVE,
        ANIMATION_LEFT_BUTTON_PASSIVE,
        ANIMATION_RIGHT_BUTTON_ACTIVE,
        ANIMATION_RIGHT_BUTTON_PASSIVE,
        ANIMATION_CURSOR_ON_LEFT,
        ANIMATION_CURSOR_ON_RIGHT,
        ANIMATION_CURSOR_ON_WAZA,
        ANIMATION_CURSOR_ON_RETURN,
        ANIMATION_CURSOR_FLUCTUATE,
        // ȉ, LAj[V
        ANIMATION_BUTTON_HOLD,
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + BUTTON_NUM,
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + BUTTON_NUM,
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + BUTTON_NUM,
        ANIMATION_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        PokeStatusBase::Result result;            // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation;            // ꂽۂ̃Aj[V
        AnimationIndex release_animation;         // ꂽۂ̃Aj[V
        AnimationIndex select_animation;          // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation;          // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation;         // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation;          // J[\ZbgAj[V
      };





      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 LV_PLACE_COUNT;
      static const u32 EXP_PLACE_COUNT;
      static const u32 POWER_PLACE_COUNT;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation_index;


      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );

      void InitializeCursorPos( void );

      void SetupStaticStrings( void );
      void SetupLeftButton( void );
      void SetupRightButton( void );
      void SetupPokeParamDisplay( void );
      void SetupPokeParamDisplay_Name( void );
      void SetupPokeParamDisplay_Sex( void );
      void SetupPokeParamDisplay_Type( void );
      void SetupPokeParamDisplay_Status( void );
      void SetupPokeParamDisplay_Item( void );
      void SetupPokeParamDisplay_Tokusei( void );
      void SetupPokeParamDisplay_Lv( void );
      void SetupPokeParamDisplay_Exp( void );
      void SetupPokeParamDisplay_Params( void );

      void UpdateSequence( void );
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultByCursorPos( ButtonIndex cursor_pos );

      void StartSelectAnimation( ButtonIndex cursor_pos );
      bool IsSelectAnimationFinished( void ) const;
      void StartCursorMoveAnimation( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __POKESTATUS_H__ 
