//=======================================================================================
/**
 * @file PokeStatus.cpp
 * @briefu悳݂v
 * @author obata_toshihiro
 * @date 2011.09.01
 */
//=======================================================================================
#include <gflib.h>
#include <print/xy_msgWin.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <app/tool/app_tool_Gauge.h>
#include "AppDrawUtil.h"
#include "PokeStatusBase.h"
#include "PokeStatus.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "poke_status.h"
#include "poke_status_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 PokeStatus::APP_HEAPSIZE = 0x1000;
    const u32 PokeStatus::DEVICE_HEAPSIZE = 0x100000; 

    // ľ
    const u32 PokeStatus::LV_PLACE_COUNT = 3;
    const u32 PokeStatus::EXP_PLACE_COUNT = 5;
    const u32 PokeStatus::POWER_PLACE_COUNT = 3;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp PokeStatus::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex 
      PokeStatus::ANIMATION_DATA_TABLE[ PokeStatus::ANIMATION_DATA_NUM ] = 
      {
        /* ANIMATION_DATA_POKE_TYPE1 */ LYTRES_POKE_STATUS_POKE_STATUS_POKE_TYPE1_BCLAN,
        /* ANIMATION_DATA_POKE_TYPE2 */ LYTRES_POKE_STATUS_POKE_STATUS_POKE_TYPE2_BCLAN,
        /* ANIMATION_DATA_POKE_SICK */ LYTRES_POKE_STATUS_POKE_STATUS_POKE_SICK_BCLAN,
        /* ANIMATION_DATA_POKE_DEAD */ LYTRES_POKE_STATUS_POKE_STATUS_POKE_DEAD_BCLAN,
        /* ANIMATION_DATA_HP_GAUGE */ LYTRES_POKE_STATUS_POKE_STATUS_HP_GAUGE_BCLAN,
        /* ANIMATION_DATA_EXP_GAUGE */ LYTRES_POKE_STATUS_POKE_STATUS_EXP_GAUGE_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_POKE_STATUS_POKE_STATUS_DUMMY_BUTTON_HOLD_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_POKE_STATUS_POKE_STATUS_DUMMY_BUTTON_RELEASE_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_POKE_STATUS_POKE_STATUS_DUMMY_BUTTON_SELECT_BCLAN,
        /* ANIMATION_DATA_LEFT_BUTTON_ACTIVE */ LYTRES_POKE_STATUS_POKE_STATUS_LEFT_BUTTON_ACTIVE_BCLAN,
        /* ANIMATION_DATA_LEFT_BUTTON_PASSIVE */ LYTRES_POKE_STATUS_POKE_STATUS_LEFT_BUTTON_PASSIVE_BCLAN,
        /* ANIMATION_DATA_RIGHT_BUTTON_ACTIVE */ LYTRES_POKE_STATUS_POKE_STATUS_RIGHT_BUTTON_ACTIVE_BCLAN,
        /* ANIMATION_DATA_RIGHT_BUTTON_PASSIVE */ LYTRES_POKE_STATUS_POKE_STATUS_RIGHT_BUTTON_PASSIVE_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_LEFT */ LYTRES_POKE_STATUS_POKE_STATUS_CURSOR_ON_LEFT_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_RIGHT */ LYTRES_POKE_STATUS_POKE_STATUS_CURSOR_ON_RIGHT_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_WAZA */ LYTRES_POKE_STATUS_POKE_STATUS_CURSOR_ON_WAZA_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_RETURN */ LYTRES_POKE_STATUS_POKE_STATUS_CURSOR_ON_RETURN_BCLAN,
        /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_POKE_STATUS_POKE_STATUS_CURSOR_FLUCTUATE_BCLAN,
      };


    

    // LAj[VƂ̐ݒ
    const PokeStatus::ShareAnimationDesc 
      PokeStatus::SHARE_ANIMATION_DESC[ PokeStatus::SHARE_ANIMATION_NUM ] = 
      {
        /* SHARE_ANIMATION_BUTTON_HOLD */
        {
          ANIMATION_BUTTON_HOLD, 
          ANIMATION_DATA_DUMMY_BUTTON_HOLD,
          BUTTON_NUM,
          PANENAME_POKE_STATUS_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_RELEASE */
        {
          ANIMATION_BUTTON_RELEASE, 
          ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
          BUTTON_NUM,
          PANENAME_POKE_STATUS_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_SELECT */
        {
          ANIMATION_BUTTON_SELECT, 
          ANIMATION_DATA_DUMMY_BUTTON_SELECT,
          BUTTON_NUM,
          PANENAME_POKE_STATUS_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // {^Ƃ̐ݒ
    const PokeStatus::ButtonDesc PokeStatus::BUTTON_DESC[ PokeStatus::BUTTON_NUM ] = 
    {
      /* BUTTON_LEFT */ 
      {
        PokeStatusBase::RESULT_LEFT,
        PANENAME_POKE_STATUS_PANE_LEFT_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_LEFT ),
        ANIMATION_LEFT_BUTTON_ACTIVE,
        ANIMATION_LEFT_BUTTON_PASSIVE,
        ANIMATION_CURSOR_ON_LEFT,
      },
      /* BUTTON_RIGHT */ 
      {
        PokeStatusBase::RESULT_RIGHT,
        PANENAME_POKE_STATUS_PANE_RIGHT_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RIGHT ),
        ANIMATION_RIGHT_BUTTON_ACTIVE,
        ANIMATION_RIGHT_BUTTON_PASSIVE,
        ANIMATION_CURSOR_ON_RIGHT,
      },
      /* BUTTON_WAZA */ 
      {
        PokeStatusBase::RESULT_WAZA,
        PANENAME_POKE_STATUS_PANE_WAZA_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_WAZA ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_WAZA ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_WAZA ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA,
      },
      /* BUTTON_RETURN */ 
      {
        PokeStatusBase::RESULT_RETURN,
        PANENAME_POKE_STATUS_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_RETURN,
      },
    };




    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      PokeStatus::CURSOR_MOVE_DATA[ PokeStatus::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_LEFT,   { BUTTON_LEFT,   BUTTON_LEFT,   BUTTON_LEFT,  BUTTON_RIGHT } },
        { BUTTON_RIGHT,  { BUTTON_RIGHT,  BUTTON_RIGHT,  BUTTON_LEFT,  BUTTON_WAZA } },
        { BUTTON_WAZA,   { BUTTON_WAZA,   BUTTON_WAZA,   BUTTON_RIGHT, BUTTON_RETURN } },
        { BUTTON_RETURN, { BUTTON_RETURN, BUTTON_RETURN, BUTTON_WAZA,  BUTTON_RETURN } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param app_heap      gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    PokeStatus::PokeStatus( 
        gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      PokeStatusBase( app_heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      AppDrawUtil(),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
    }



    // OtBbNXVXe
    void PokeStatus::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void PokeStatus::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void PokeStatus::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_poke_status_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_POKE_STATUS_POKE_STATUS_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void PokeStatus::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void PokeStatus::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void PokeStatus::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void PokeStatus::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    PokeStatus::~PokeStatus()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }



    // J[\ǗIuWFNgj
    void PokeStatus::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void PokeStatus::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void PokeStatus::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void PokeStatus::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void PokeStatus::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->SetupStaticStrings();
      this->SetupLeftButton();
      this->SetupRightButton();
      this->SetupPokeParamDisplay();
    }



    // Œ蕶̃ZbgAbv
    void PokeStatus::SetupStaticStrings( void )
    {
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_LEVEL, STR_LV );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_HP, STR_HP );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_ATK, STR_ATK );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_DEF, STR_DEF );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_SPATK, STR_SPATK );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_SPDEF, STR_SPDEF );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_AGI, STR_AGI );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_WAZA_LABEL, STR_CMD_WAZA );
      this->SetTextboxPaneMessage( m_layout_work, PANENAME_POKE_STATUS_PANE_NEXT_LEVEL, STR_NEXT_LV );
    }


    // {^̃ZbgAbv
    void PokeStatus::SetupLeftButton( void )
    {
      if( this->IsLeftEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_LEFT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_LEFT );
      }
    }


    // E{^̃ZbgAbv
    void PokeStatus::SetupRightButton( void )
    {
      if( this->IsRightEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_RIGHT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_RIGHT );
      }
    }


    // |Pp[^\̃ZbgAbv
    void PokeStatus::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Type();
      this->SetupPokeParamDisplay_Status();
      this->SetupPokeParamDisplay_Item();
      this->SetupPokeParamDisplay_Tokusei();
      this->SetupPokeParamDisplay_Lv();
      this->SetupPokeParamDisplay_Exp();
      this->SetupPokeParamDisplay_Params();
    }


    // |Pp[^\̃ZbgAbv( O )
    void PokeStatus::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void PokeStatus::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      this->SetTextboxPaneSex( m_layout_work, PANENAME_POKE_STATUS_PANE_POKE_SEX, sex ); 
    }


    // |Pp[^\̃ZbgAbv( ^Cv )
    void PokeStatus::SetupPokeParamDisplay_Type( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      pml::PokeType type1 = pokeparam->GetType1();
      pml::PokeType type2 = pokeparam->GetType2();

      // ^Cv1
      this->StartAnimation( m_layout_work, ANIMATION_POKE_TYPE1 );
      this->PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE1, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE1, type1 );

      // ^Cv2
      if( type1 == type2 ) {
        this->SetPaneInvisible( m_layout_work, PANENAME_POKE_STATUS_PANE_TYPE_ICON2 );
      }
      else {
        this->SetPaneVisible( m_layout_work, PANENAME_POKE_STATUS_PANE_TYPE_ICON2 );
        this->StartAnimation( m_layout_work, ANIMATION_POKE_TYPE2 );
        this->PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE2, false );
        this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE2, type2 );
      }
    }


    // |Pp[^\̃ZbgAbv( Ԉُ )
    void PokeStatus::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        this->StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        this->StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        this->PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }


    // |Pp[^\̃ZbgAbv( ACe )
    void PokeStatus::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool icon_visible = ( itemno != ITEM_DUMMY_DATA );
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_ITEM_ICON, icon_visible );
      this->SetTextboxPaneItemName( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_ITEM_NAME, itemno, this->GetHeap() );
    }


    // |Pp[^\̃ZbgAbv(  )
    void PokeStatus::SetupPokeParamDisplay_Tokusei( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      TokuseiNo tokusei = static_cast<TokuseiNo>( btlparam->GetValue( BTL_POKEPARAM::BPP_TOKUSEI ) );
      this->SetTextboxPaneTokuseiName( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_TOKUSEI_NAME, tokusei );
      this->SetTextboxPaneTokuseiInfo( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_TOKUSEI_INFO, tokusei );
    }


    // |Pp[^\̃ZbgAbv( x )
    void PokeStatus::SetupPokeParamDisplay_Lv( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 level = btlparam->GetValue( BTL_POKEPARAM::BPP_LEVEL );
      u32 max_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_MAX_HP );
      u32 now_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_HP );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_LEVEL_VALUE, level, LV_PLACE_COUNT );
    }


    // |Pp[^\̃ZbgAbv( ̃x܂ł̌ol )
    void PokeStatus::SetupPokeParamDisplay_Exp( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      u32 exp = pokeparam->GetExpForNextLevel();
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_NEXT_LEVEL_VALUE, exp, EXP_PLACE_COUNT );

      u32 ratio = 50;  // @todo
      this->StartAnimation( m_layout_work, ANIMATION_EXP_GAUGE );
      this->PauseAnimation( m_layout_work, ANIMATION_EXP_GAUGE, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_EXP_GAUGE, ratio );
    }


    // |Pp[^\̃ZbgAbv( p[^ )
    void PokeStatus::SetupPokeParamDisplay_Params( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 now_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_HP );
      u32 max_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_MAX_HP );
      u32 atk = btlparam->GetValue( BTL_POKEPARAM::BPP_ATTACK );
      u32 def = btlparam->GetValue( BTL_POKEPARAM::BPP_DEFENCE );
      u32 spatk = btlparam->GetValue( BTL_POKEPARAM::BPP_SP_ATTACK );
      u32 spdef = btlparam->GetValue( BTL_POKEPARAM::BPP_SP_DEFENCE );
      u32 agi = btlparam->GetValue( BTL_POKEPARAM::BPP_AGILITY );

      // 
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_HP_MAX, max_hp, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_HP_VALUE, now_hp, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_ATK_VALUE, atk, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_DEF_VALUE, def, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_SPATK_VALUE, spatk, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_SPDEF_VALUE, spdef, POWER_PLACE_COUNT );
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_POKE_STATUS_PANE_AGI_VALUE, agi, POWER_PLACE_COUNT );

      // goQ[W
      u32 gauge_frame = ::app::tool::Gauge::GetDottoNum( now_hp, max_hp, 100 );  // ő100t[
      this->StartAnimation( m_layout_work, ANIMATION_HP_GAUGE );
      this->PauseAnimation( m_layout_work, ANIMATION_HP_GAUGE, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_HP_GAUGE, gauge_frame );
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void PokeStatus::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_animation_index = ANIMATION_NULL;
      this->InitializeCursorPos();
    }


    // J[\ʒu
    void PokeStatus::InitializeCursorPos( void )
    {
      ButtonIndex cursor_pos = BUTTON_LEFT;
      const ButtonDesc& button_desc = BUTTON_DESC[ cursor_pos ];
      m_cursor_manager->SetPos( cursor_pos );
      this->StartAnimation( m_layout_work, button_desc.cursor_animation );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void PokeStatus::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void PokeStatus::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void PokeStatus::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultByCursorPos( selected_button );
            this->StartSelectAnimation( selected_button );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }






    // {^Ă邩ǂ𒲂ׂ
    bool PokeStatus::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool PokeStatus::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    PokeStatus::ButtonIndex PokeStatus::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }




    // J[\̓XV
    bool PokeStatus::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    PokeStatus::ButtonIndex PokeStatus::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    PokeStatus::ButtonIndex PokeStatus::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void PokeStatus::StartCursorMoveAnimation( 
        PokeStatus::ButtonIndex old_cursor_pos, PokeStatus::ButtonIndex new_cursor_pos )
    {
      this->StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_animation );
      this->StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_animation );
    }






    // I\ǂ𒲂ׂ
    bool PokeStatus::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // J[\ʒu, 쌋ʂZbg
    void PokeStatus::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );
    } 


    // ȊIAj[VJn
    void PokeStatus::StartSelectAnimation( ButtonIndex cursor_pos )
    {
      m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
      this->StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool PokeStatus::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }






  }  // namespace app
}  // namespace btl

