//=============================================================================
/**
 *
 *	@file		ScriptFuncSetCommon.cpp
 *	@brief  XNvg߃ZbgFW߃Zbg
 *	@author hosaka genya
 *	@data		2011.09.02
 *
 */
//=============================================================================

GFL_NAMESPACE_BEGIN( field )
GFL_NAMESPACE_BEGIN( script )
  
// L[擾ix^j
cell AMX_NATIVE_CALL FuncSetCommon::GetKeyCont( AMX *, const cell * )
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gfl::ui::Button *uiButton = p_gman->GetUiDeviceManager()->GetButton(0);
  return uiButton->GetHold();
}

// L[擾igK[j
cell AMX_NATIVE_CALL FuncSetCommon::GetKeyTrg( AMX *, const cell * )
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gfl::ui::Button *uiButton = p_gman->GetUiDeviceManager()->GetButton(0);
  return uiButton->GetTrigger();
}

struct BGWinMsgSeq
{ 
  gfl::str::MsgData* MsgData;
  gfl::str::StrBuf*  StrBuf;
};

#include <message/message.gaix>
// BGbZ[W\ 
// @todo bZ[Wėpɑg݊
cell AMX_NATIVE_CALL FuncSetCommon::BGWinMsg_Seq( AMX *, const cell * ptr )
{
  enum
  {
    SEQ_INIT,
    SEQ_MSGWAIT,
    SEQ_END,
  };
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  u16* seq = pThis->GetCellSeq();
  void** UserWork = pThis->GetCellUserWork();
  
  switch( *seq )
  {
  case SEQ_INIT :
    HOSAKA_PRINT("bgwin msg init\n");
    
    // 
    {
      gfl::heap::HeapBase* heap = p_gman->GetFieldmap()->GetHeapField();
      field::ZoneDataLoader* zone = p_gman->GetGameData()->GetZoneDataLoader();
      u16 dat_id = zone->GetMessageArcID();
      u16 str_id = ptr[1];
      u16 type = ptr[2];
      
      GFL_UNUSED( type ); // @todo g^Cv
      
      //@todo ZoneŃbZ[Wǂݑւ(\[XȂ̂Ŏ荇Œ)
      dat_id = GARC_message_r00_DAT;
      
      BGWinMsgSeq* wk = GFL_NEW( heap ) BGWinMsgSeq();
  
      wk->StrBuf = GFL_NEW( heap ) gfl::str::StrBuf( 1024, heap );
      wk->MsgData = GFL_NEW( heap )
        gfl::str::MsgData( L"rom:/message.garc", dat_id, heap, gfl::str::MsgData::LOAD_PART );
      
      wk->MsgData->GetString( str_id, *wk->StrBuf );

      *UserWork = wk;

    }
    
    {
      BGWinMsgSeq* wk = static_cast<BGWinMsgSeq*>(*UserWork);
      Fieldmap* p_fieldmap = p_gman->GetFieldmap();
      MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
      
      {
        p_msgwin->DispMessageReq_Board( wk->StrBuf, MSGWIN_POS_LOWER );
      }
    }
    
    *seq = SEQ_MSGWAIT;
    break;
  
  case SEQ_MSGWAIT :
    {
      Fieldmap* p_fieldmap = p_gman->GetFieldmap();
      MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
      if( p_msgwin->IsDispEnd() )
      {
        *seq = SEQ_END;
      }
    }
    break;
  
  case SEQ_END :
    HOSAKA_PRINT("talk_test delete\n");
    {
      BGWinMsgSeq* wk = static_cast<BGWinMsgSeq*>(*UserWork);
      GFL_DELETE wk->MsgData;
      GFL_DELETE wk->StrBuf;
      GFL_DELETE *UserWork;
    }

    return true;
  
  }

  return false;
}
  
//-----------------------------------------------------------------------------
/**
 *	@brief  ߃e[uZbg擾
 */
//-----------------------------------------------------------------------------
const GFL_PAWN_FUNC_TABLE* FuncSetCommon::GetTable( void )
{
  static const GFL_PAWN_FUNC_TABLE s_FuncTable[] = 
  {
    GFL_PAWN_FUNC( GetKeyCont ) 
    GFL_PAWN_FUNC( GetKeyTrg ) 
    GFL_PAWN_FUNC( BGWinMsg_Seq ) 
    GFL_PAWN_FUNC_END,
  };

  return s_FuncTable;
}

GFL_NAMESPACE_END( script )
GFL_NAMESPACE_END( field )
  
