//=======================================================================================
/**
 * @file RepairSelectBase.h
 * @brief 񕜑Iʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.08.29
 */
//=======================================================================================
#ifndef __REPAIRSELECTBASE_H__
#define __REPAIRSELECTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class RepairSelectBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( RepairSelectBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      //---------------------------------------------------------------------------------
      RepairSelectBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~RepairSelectBase();





      // ݒ
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting ) = 0;





      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_HP_PP,   //uHP/PPvI
        RESULT_STATUS,  //uԁvI
        RESULT_NULL,
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;






      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __REPAIRSELECTBASE_H__ 
