//=======================================================================================
/**
 * @file RepairSelect.cpp
 * @brief 񕜑I
 * @author obata_toshihiro
 * @date 2011.09.01
 */
//=======================================================================================
#include <gflib.h>
#include <print/xy_msgWin.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <app/tool/app_tool_Gauge.h>
#include "AppDrawUtil.h"
#include "RepairSelectBase.h"
#include "RepairSelect.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "repair_select.h"
#include "repair_select_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 RepairSelect::APP_HEAPSIZE = 0x1000;
    const u32 RepairSelect::DEVICE_HEAPSIZE = 0x100000; 


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp RepairSelect::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex 
      RepairSelect::ANIMATION_DATA_TABLE[ RepairSelect::ANIMATION_DATA_NUM ] = 
      {
        /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_BUTTON_HOLD_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_BUTTON_RELEASE_BCLAN,
        /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_BUTTON_SELECT_BCLAN,
        /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_FLUCTUATE_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_HP */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_HP_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_STATUS */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_STATUS_BCLAN,
        /* ANIMATION_DATA_CURSOR_ON_RETURN */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_RETURN_BCLAN,
        /* ANIMATION_DATA_POKE_SICK */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE_SICK_BCLAN,
        /* ANIMATION_DATA_POKE_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE_DEAD_BCLAN,
        /* ANIMATION_DATA_POKE_HP_GAUGE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE_HP_GAUGE_BCLAN,
      };


    

    // LAj[VƂ̐ݒ
    const RepairSelect::ShareAnimationDesc 
      RepairSelect::SHARE_ANIMATION_DESC[ RepairSelect::SHARE_ANIMATION_NUM ] = 
      {
        /* SHARE_ANIMATION_BUTTON_HOLD */
        {
          ANIMATION_BUTTON_HOLD, 
          ANIMATION_DATA_DUMMY_BUTTON_HOLD,
          BUTTON_NUM,
          PANENAME_REPAIR_SELECT_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_RELEASE */
        {
          ANIMATION_BUTTON_RELEASE, 
          ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
          BUTTON_NUM,
          PANENAME_REPAIR_SELECT_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIMATION_BUTTON_SELECT */
        {
          ANIMATION_BUTTON_SELECT, 
          ANIMATION_DATA_DUMMY_BUTTON_SELECT,
          BUTTON_NUM,
          PANENAME_REPAIR_SELECT_GROUP_BUTTON,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // {^Ƃ̐ݒ
    const RepairSelect::ButtonDesc RepairSelect::BUTTON_DESC[ RepairSelect::BUTTON_NUM ] = 
    {
      /* BUTTON_HP */ 
      {
        RepairSelectBase::RESULT_HP_PP,
        PANENAME_REPAIR_SELECT_PANE_HP_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_HP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_HP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_HP ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_HP,
      },
      /* BUTTON_STATUS */ 
      {
        RepairSelectBase::RESULT_STATUS,
        PANENAME_REPAIR_SELECT_PANE_STATUS_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_STATUS ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_STATUS ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_STATUS ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_STATUS,
      },
      /* BUTTON_RETURN */ 
      {
        RepairSelectBase::RESULT_RETURN,
        PANENAME_REPAIR_SELECT_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_RETURN,
      },
    };




    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      RepairSelect::CURSOR_MOVE_DATA[ RepairSelect::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_HP,     { BUTTON_HP,     BUTTON_STATUS, BUTTON_HP,     BUTTON_RETURN } },
        { BUTTON_STATUS, { BUTTON_HP,     BUTTON_STATUS, BUTTON_STATUS, BUTTON_RETURN } },
        { BUTTON_RETURN, { BUTTON_RETURN, BUTTON_RETURN, BUTTON_HP,     BUTTON_RETURN } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param app_heap      gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    RepairSelect::RepairSelect( 
        gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      RepairSelectBase( app_heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      AppDrawUtil(),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
    }



    // OtBbNXVXe
    void RepairSelect::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void RepairSelect::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void RepairSelect::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_repair_select_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_REPAIR_SELECT_REPAIR_SELECT_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void RepairSelect::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        u32 count = 
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
        GFL_PRINT( "count = %d\n", count );
      }
    }


    // J[\ǗIuWFNg𐶐
    void RepairSelect::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void RepairSelect::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void RepairSelect::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation,
            BUTTON_DESC[i].release_animation,
            BUTTON_DESC[i].select_animation,
            BUTTON_DESC[i].active_animation,
            BUTTON_DESC[i].passive_animation,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    RepairSelect::~RepairSelect()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }


    // J[\ǗIuWFNgj
    void RepairSelect::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void RepairSelect::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void RepairSelect::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void RepairSelect::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void RepairSelect::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->SetupHpButton();
      this->SetupStatusButton();
      this->SetupPokeParamDisplay();
    }


    //uHP/PPv{^̃ZbgAbv
    void RepairSelect::SetupHpButton( void )
    {
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_REPAIR_SELECT_PANE_HP_LABEL, STR_RPR_HP_PP );
    }


    //uԁv{^̃ZbgAbv
    void RepairSelect::SetupStatusButton( void )
    {
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_REPAIR_SELECT_PANE_STATUS_LABEL, STR_RPR_STATUS );
    }



    // |Pp[^\̃ZbgAbv
    void RepairSelect::SetupPokeParamDisplay( void )
    {
      this->SetupPokeParamDisplay_Name();
      this->SetupPokeParamDisplay_Sex();
      this->SetupPokeParamDisplay_Item();
      this->SetupPokeParamDisplay_Hp();
      this->SetupPokeParamDisplay_Status();
    }


    // |Pp[^\̃ZbgAbv( X^[ )
    void RepairSelect::SetupPokeParamDisplay_Name( void )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      const pml::pokepara::PokemonParam* pokeparam = this->GetBtlParam()->GetSrcData();
      pokeparam->GetNickName( temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_REPAIR_SELECT_PANE_POKE_NAME, temp_buf );
    }


    // |Pp[^\̃ZbgAbv(  )
    void RepairSelect::SetupPokeParamDisplay_Sex( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      pml::Sex sex = static_cast<pml::Sex>( btlparam->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      this->SetTextboxPaneSex( m_layout_work, PANENAME_REPAIR_SELECT_PANE_POKE_SEX, sex ); 
    }


    // |Pp[^\̃ZbgAbv( ACeACR )
    void RepairSelect::SetupPokeParamDisplay_Item( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 itemno = btlparam->GetItem();
      bool pane_visible = ( itemno != ITEM_DUMMY_DATA );
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_REPAIR_SELECT_PANE_POKE_ITEM, pane_visible );
    }


    // |Pp[^\̃ZbgAbv( HP )
    void RepairSelect::SetupPokeParamDisplay_Hp( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      u32 max_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_MAX_HP );
      u32 now_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_HP );
      u32 gauge_frame = ::app::tool::Gauge::GetDottoNum( now_hp, max_hp, 100 );  // ő100t[
      this->StartAnimation( m_layout_work, ANIMATION_POKE_HP_GAUGE );
      this->PauseAnimation( m_layout_work, ANIMATION_POKE_HP_GAUGE, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_HP_GAUGE, gauge_frame );
    }


    // |Pp[^\̃ZbgAbv( Xe[^X )
    void RepairSelect::SetupPokeParamDisplay_Status( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetBtlParam();
      if( btlparam->IsDead() ) {
        this->StartAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StopAnimation( m_layout_work, ANIMATION_POKE_SICK );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        this->StopAnimation( m_layout_work, ANIMATION_POKE_DEAD );
        this->StartAnimation( m_layout_work, ANIMATION_POKE_SICK );
        this->PauseAnimation( m_layout_work, ANIMATION_POKE_SICK, false );
        this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_SICK, sick );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void RepairSelect::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_animation_index = ANIMATION_NULL;
      this->InitializeCursorPos();
    }


    // J[\ʒu
    void RepairSelect::InitializeCursorPos( void )
    {
      ButtonIndex cursor_pos = BUTTON_HP;
      const ButtonDesc& button_desc = BUTTON_DESC[ cursor_pos ];
      m_cursor_manager->SetPos( cursor_pos );
      this->StartAnimation( m_layout_work, button_desc.cursor_animation );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void RepairSelect::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void RepairSelect::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void RepairSelect::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultByCursorPos( selected_button );
            this->StartSelectAnimation( selected_button );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }






    // {^Ă邩ǂ𒲂ׂ
    bool RepairSelect::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool RepairSelect::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    RepairSelect::ButtonIndex RepairSelect::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }




    // J[\̓XV
    bool RepairSelect::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    RepairSelect::ButtonIndex RepairSelect::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    RepairSelect::ButtonIndex RepairSelect::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void RepairSelect::StartCursorMoveAnimation( 
        RepairSelect::ButtonIndex old_cursor_pos, RepairSelect::ButtonIndex new_cursor_pos )
    {
      this->StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_animation );
      this->StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_animation );
    }






    // I\ǂ𒲂ׂ
    bool RepairSelect::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    }




    // J[\ʒu, 쌋ʂZbg
    void RepairSelect::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );
    } 


    // ȊIAj[VJn
    void RepairSelect::StartSelectAnimation( ButtonIndex cursor_pos )
    {
      m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation;
      this->StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool RepairSelect::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }




  }  // namespace app
}  // namespace btl
