//=======================================================================================
/**
 * @file wazawasure_Upper.h
 * @brief ZY(  )
 * @author obata_toshihiro
 * @date 2011.08.30
 */
//=======================================================================================
#ifndef __WAZAWASUREUPPER_H__
#define __WAZAWASUREUPPER_H__
#include "wazawasure_Base.h"


namespace app {
  namespace wazawasure {


    class Upper : public Base
    {
      GFL_FORBID_COPY_AND_ASSIGN( Upper );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param parent_heap         gpq[v
       * @param parent_device_heap  gpfoCXq[v
       * @param layout_system       `Ɏgp郌CAEgVXe
       */
      //---------------------------------------------------------------------------------
      Upper( 
          gfl::heap::HeapBase* parent_heap,
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::grp::g2d::LytSys* layout_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~Upper();

      //---------------------------------------------------------------------------------
      /**
       * @brief \eZbg
       * @param pokeparam  \|P
       * @param wazano     \Z
       */
      //---------------------------------------------------------------------------------
      void SetDisplayParams( 
          const pml::pokepara::PokemonParam* pokeparam, WazaNo wazano );




      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //---------------------------------------------------------------------------------
      virtual void Update( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief `揈
       */
      //---------------------------------------------------------------------------------
      virtual void Draw( void );





      private:


      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_POKE_TYPE1,
        ANIMATION_DATA_POKE_TYPE2,
        ANIMATION_DATA_WAZA_DAMAGE_TYPE,
        ANIMATION_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_POKE_TYPE1,
        ANIMATION_POKE_TYPE2,
        ANIMATION_WAZA_DAMAGE_TYPE,
        ANIMATION_NUM,
        ANIMATION_NULL,
      }; 



      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE; 
      static const u32 ZUKANNO_PLACE_COUNT;
      static const u32 WAZAPOWER_PLACE_COUNT;
      static const u32 WAZAHIT_PLACE_COUNT;
      static const u32 PARAMS_PLACE_COUNT;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];


      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id; 


      void CreateLayoutWork( void );
      void DeleteLayoutWork( void );

      void SetupDisplay_Strings( void );
      void SetupDisplay_ZukanNo( const pml::pokepara::PokemonParam* pokeparam );
      void SetupDisplay_Name( const pml::pokepara::PokemonParam* pokeparam );
      void SetupDisplay_Type( const pml::pokepara::PokemonParam* pokeparam );
      void SetupDisplay_Params( const pml::pokepara::PokemonParam* pokeparam );
      void SetupDisplay_Waza( WazaNo wazano );
    };


  }  // namespace wazawasure
}  // namespace app 


#endif  // __WAZAWASUREUPPER_H__
