//=======================================================================================
/**
 * @file wazawasure_Upper.cpp
 * @brief ZY(  )
 * @author obata_toshihiro
 * @date 2011.08.30
 */
//=======================================================================================
#include "wazawasure_Base.h"
#include "wazawasure_Upper.h"

#include <message/msg_waza_wasure.h>
#include <arc/arc_def.h>
#include <arc/waza_wasure.gaix>
#include "waza_wasure_upper.h"
#include "waza_wasure_upper_pane.h"


namespace app {
  namespace wazawasure {


    // q[vTCY
    const u32 Upper::APP_HEAPSIZE = 0x1000;
    const u32 Upper::DEVICE_HEAPSIZE = 0x100000;

    // ľ
    const u32 Upper::ZUKANNO_PLACE_COUNT = 3; 
    const u32 Upper::WAZAPOWER_PLACE_COUNT = 3;
    const u32 Upper::WAZAHIT_PLACE_COUNT = 3;
    const u32 Upper::PARAMS_PLACE_COUNT = 3;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Upper::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, 0, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),     // scale
      gfl::math::VEC3( 0, 0, 0 ),  // rotate
      1,                           // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Upper::ANIMATION_DATA_TABLE[ Upper::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_POKE_TYPE1 */ LYTRES_WAZA_WASURE_UPPER_WAZA_WASURE_UPPER_POKE_TYPE1_BCLAN,
      /* ANIMATION_DATA_POKE_TYPE2 */ LYTRES_WAZA_WASURE_UPPER_WAZA_WASURE_UPPER_POKE_TYPE2_BCLAN,
      /* ANIMATION_DATA_WAZA_DAMAGE_TYPE */ LYTRES_WAZA_WASURE_UPPER_WAZA_WASURE_UPPER_WAZA_DAMAGE_TYPE_BCLAN,
    }; 





    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param parent_heap         gpq[v
     * @param parent_device_heap  gpfoCXq[v
     * @param layout_system       `Ɏgp郌CAEgVXe
     */
    //---------------------------------------------------------------------------------
    Upper::Upper( 
        gfl::heap::HeapBase* parent_heap,
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::grp::g2d::LytSys* layout_system ) : 
      Base( 
          parent_heap, HEAPID_WAZAWASURE_UPPER, APP_HEAPSIZE,
          parent_device_heap, HEAPID_WAZAWASURE_UPPER_DEVICE, DEVICE_HEAPSIZE, 
          layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 )
    {
      this->CreateLayoutWork();
      this->SetupDisplay_Strings();
    }


    // CAEg[N𐶐
    void Upper::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_WAZAWASURE, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_waza_wasure_waza_wasure_upper_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_WASURE_UPPER_WAZA_WASURE_UPPER_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // ōXV, `悷
    }


    // e핶Zbg
    void Upper::SetupDisplay_Strings( void )
    {
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_ZUKAN_LABEL, STR_WW_ZUKAN );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_NAME_LABEL, STR_WW_NAME );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_TYPE_LABEL, STR_WW_TYPE );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_DMG_LABEL, STR_WW_WAZA_POWER );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_HIT_LABEL, STR_WW_WAZA_HIT );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_ATK_LABEL, STR_WW_WAZA_POWER );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_HP_LABEL, STR_WW_HP );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_ATK_LABEL, STR_WW_ATK );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_DEF_LABEL, STR_WW_DEF );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_SPATK_LABEL, STR_WW_SPATK );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_SPDEF_LABEL, STR_WW_SPDEF );
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_AGI_LABEL, STR_WW_AGI );
    }





    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    Upper::~Upper()
    {
      this->DeleteLayoutWork();
    }


    // CAEg[Nj
    void Upper::DeleteLayoutWork( void )
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief \eZbg
     * @param pokeparam  \|P
     * @param wazano     \Z
     */
    //---------------------------------------------------------------------------------
    void Upper::SetDisplayParams( 
        const pml::pokepara::PokemonParam* pokeparam, WazaNo wazano )
    {
      this->SetupDisplay_ZukanNo( pokeparam );
      this->SetupDisplay_Name( pokeparam );
      this->SetupDisplay_Type( pokeparam );
      this->SetupDisplay_Params( pokeparam );
      this->SetupDisplay_Waza( wazano );
    } 


    // }No.Zbg
    void Upper::SetupDisplay_ZukanNo( const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      u32 zukanno = pokeparam->GetMonsNo(); // @todo n}
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_ZUKAN_VALUE, 
          zukanno, ZUKANNO_PLACE_COUNT );
    }


    // X^[Zbg
    void Upper::SetupDisplay_Name( const pml::pokepara::PokemonParam* pokeparam )
    {
      MonsNo monsno = pokeparam->GetMonsNo();
      this->SetTextboxPaneMonsName( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_NAME_VALUE, monsno );
    }


    // ^CvZbg
    void Upper::SetupDisplay_Type( const pml::pokepara::PokemonParam* pokeparam )
    {
      pml::PokeType type1 = pokeparam->GetType1(); 
      this->StartAnimation( m_layout_work, ANIMATION_POKE_TYPE1 );
      this->PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE1, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE1, type1 );

      pml::PokeType type2 = pokeparam->GetType2();
      this->StartAnimation( m_layout_work, ANIMATION_POKE_TYPE2 );
      this->PauseAnimation( m_layout_work, ANIMATION_POKE_TYPE2, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_POKE_TYPE2, type2 );
    }


    // p[^Zbg
    void Upper::SetupDisplay_Params( const pml::pokepara::PokemonParam* pokeparam )
    {
      u32 now_hp = pokeparam->GetHp();
      u32 max_hp = pokeparam->GetPower( pml::pokepara::POWER_HP );
      u32 atk = pokeparam->GetPower( pml::pokepara::POWER_ATK );
      u32 def = pokeparam->GetPower( pml::pokepara::POWER_DEF );
      u32 spatk = pokeparam->GetPower( pml::pokepara::POWER_SPATK );
      u32 spdef = pokeparam->GetPower( pml::pokepara::POWER_SPDEF );
      u32 agi = pokeparam->GetPower( pml::pokepara::POWER_AGI );

      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_MAX_HP_VALUE, max_hp, PARAMS_PLACE_COUNT ); 
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_ATK_VALUE, atk, PARAMS_PLACE_COUNT );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_DEF_VALUE, def, PARAMS_PLACE_COUNT );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_SPATK_VALUE, spatk, PARAMS_PLACE_COUNT );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_SPDEF_VALUE, spdef, PARAMS_PLACE_COUNT );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_AGI_VALUE, agi, PARAMS_PLACE_COUNT );
    }



    // ZZbg
    void Upper::SetupDisplay_Waza( WazaNo wazano )
    {
      pml::wazadata::System* wazadata_system = pml::System::WazaDataSystem();

      // 
      pml::wazadata::WazaDamageType waza_kind = wazadata_system->GetDamageType( wazano );
      this->StartAnimation( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE );
      this->PauseAnimation( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE, false );
      this->SetAnimationFrame( m_layout_work, ANIMATION_WAZA_DAMAGE_TYPE, waza_kind );

      // 傭
      u32 atk = ( wazano == WAZANO_NULL ) ? 
        0 : wazadata_system->GetParam( wazano, pml::wazadata::PARAM_ID_POWER );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_ATK_LABEL, atk, WAZAPOWER_PLACE_COUNT ); 

      // ߂イ
      u32 hit = ( wazano == WAZANO_NULL ) ? 
        0 : wazadata_system->GetParam( wazano, pml::wazadata::PARAM_ID_HITPER );
      this->SetTextboxPaneNumber( m_layout_work, 
          PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_HIT_LABEL, hit, WAZAHIT_PLACE_COUNT ); 

      // 
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      wazadata_system->GetWazaInfo( wazano, temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, PANENAME_WAZA_WASURE_UPPER_PANE_WAZA_EXPLANATION, temp_buf );
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void Upper::Update( void )
    {
      m_layout_work->Update();
    }


    //---------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //---------------------------------------------------------------------------------
    void Upper::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }









  }  // namespace wazawasure
}  // namespace app 
