//========================================================================================
/**
 * @file wazawasure_Process.cpp
 * @brief ZYvZX
 * @author obata_toshihiro
 * @date 2011.08.28
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <app/waza_wasure/wazawasure_Process.h>
#include "wazawasure_Lower.h"


namespace app {
  namespace wazawasure {



    // VXetHg̃t@C
    const char* Process::SYSTEMFONT_FILENAME = "cbf_std.bcfnt";


    // CAEgVXẽZbgAbvf[^
    const gfl::grp::g2d::LytSysSetUp Process::LYTSYS_SETUP_DATA = 
    {
      128, // Ǘ\[Xő吔
      10,  // ǗCAEg[Nő吔
    }; 





    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    Process::Process( void ) :
      gamesystem::GameProc(),
      m_heap( NULL ),
      m_device_heap( NULL ),
      m_nw_heap_allocator( NULL ),
      m_nw_device_allocator( NULL ),
      m_g3d_system( NULL ),
      m_layout_system( NULL ),
      m_pokeparam( NULL ),
      m_lower( NULL )
    {
    }


    //--------------------------------------------------------------------------------
    // \|Pݒ肷
    //--------------------------------------------------------------------------------
    void Process::SetPokeParam( const pml::pokepara::PokemonParam* pokeparam )
    {
      m_pokeparam = pokeparam;
    }




    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    Process::~Process()
    {
    }








    //------------------------------------------------------------------------------------
    // vZX̏
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::InitFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 
      this->CreateHeap();
      this->CreateG3dSystem();
      this->CreateLayoutSystem();
      this->SetupFont();
      wazawasure::Base::Initialize( m_heap );
      this->CreateLower();
      return gfl::proc::RES_FINISH;
    }



    // q[v쐬
    void Process::CreateHeap( void )
    {
      gfl::heap::HeapBase* parent_heap = 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* parent_device_heap = 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ); 
      size_t app_heap_size = parent_heap->GetTotalAllocatableSize();
      size_t dev_heap_size = parent_device_heap->GetTotalAllocatableSize();
      m_heap = gfl::heap::Manager::CreateHeap( 
          parent_heap, HEAPID_WAZAWASURE, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      m_device_heap = gfl::heap::Manager::CreateHeap( 
          parent_device_heap, HEAPID_WAZAWASURE_DEVICE, dev_heap_size, gfl::heap::HEAP_TYPE_EXP );
      m_nw_heap_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_heap );
      m_nw_device_allocator = GFL_NEW( m_device_heap ) gfl::heap::NwAllocator( m_device_heap );
    }



    // G3D VXe𐶐
    void Process::CreateG3dSystem( void )
    {
      GFL_ASSERT( m_g3d_system == NULL );
      m_g3d_system = GFL_NEW( m_heap ) 
        gfl::grp::g3d::System( m_nw_heap_allocator, m_nw_device_allocator );
    }


    // CAEgVXe𐶐
    void Process::CreateLayoutSystem( void )
    {
      GFL_ASSERT( m_layout_system == NULL );
      m_layout_system = GFL_NEW( m_heap ) 
        gfl::grp::g2d::LytSys( &LYTSYS_SETUP_DATA, m_nw_heap_allocator, m_nw_device_allocator );
    }


    // tHg̃ZbgAbv
    void Process::SetupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Initialize( m_device_heap );
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), SYSTEMFONT_FILENAME );
    }


    // ʊǗIuWFNg𐶐
    void Process::CreateLower( void )
    {
      m_lower = GFL_NEW( m_heap ) wazawasure::Lower( 
          m_heap, m_device_heap, m_layout_system, m_pokeparam );
    }









    //------------------------------------------------------------------------------------
    // vZX̏I
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::EndFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 
      this->DeleteLower();
      wazawasure::Base::Finalize();
      this->CleanupFont();
      this->DeleteLayoutSystem();
      this->DeleteG3dSystem();
      this->DeleteHeap();
      return gfl::proc::RES_FINISH;
    } 


    // ʊǗIuWFNgj
    void Process::DeleteLower( void )
    {
      GFL_DELETE m_lower;
    }


    // tHǧЕt
    void Process::CleanupFont( void )
    {
      //ʏōs܂Ariizumi11/06/02
      //SystemFont_Terminate();
    } 


    // CAEgVXej
    void Process::DeleteLayoutSystem( void )
    {
      GFL_ASSERT( m_layout_system );
      GFL_DELETE m_layout_system; 
    } 


    // G3DVXej
    void Process::DeleteG3dSystem( void )
    {
      GFL_ASSERT( m_g3d_system );
      GFL_DELETE m_g3d_system; 
    }


    // q[v
    void Process::DeleteHeap( void )
    {
      GFL_DELETE m_nw_heap_allocator;
      GFL_DELETE m_nw_device_allocator;
      gfl::heap::Manager::DeleteHeap( m_heap );
      gfl::heap::Manager::DeleteHeap( m_device_heap );
    }











    //------------------------------------------------------------------------------------
    // vZX̍XV
    //------------------------------------------------------------------------------------
    gfl::proc::Result Process::UpdateFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager ); 
      m_lower->Update();
      m_layout_system->UpdateAll();
      if( m_lower->IsFinished() ) {
        return gfl::proc::RES_FINISH;
      }
      return gfl::proc::RES_CONTINUE;
    }



    //------------------------------------------------------------------------------------
    // vZX̕`揈
    //------------------------------------------------------------------------------------
    void Process::DrawFunc( gfl::proc::Manager* proc_manager )
    {
      GFL_UNUSED( proc_manager );

      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gfl::grp::GraphicsSystem* graphics_system = game_manager->GetGraphicsSystem();

      gfl::grp::RenderTarget* upper_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* right_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      gfl::grp::RenderTarget* lower_frame_buff = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

      m_layout_system->DrawAll( 
          graphics_system, gfl::grp::DISPLAY_UPPER, upper_frame_buff, right_frame_buff );
      m_layout_system->DrawAll( 
          graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buff );

      m_lower->Draw();
    }





  } // namespace wazawasure
} // namespace app
